/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.BlockItemRGB16;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.common.rgb16.TileEntityRGB16;

public class BlockRGB16
extends Block
implements EntityBlock,
IColored,
IRGB16_Block {
    private final BlockEntityFactory<TileEntityRGB16> supplier;
    private int[] tintedIndexes;

    public BlockRGB16(BlockBehaviour.Properties properties, BlockEntityFactory<TileEntityRGB16> supplier) {
        super(properties);
        this.supplier = supplier;
    }

    public BlockRGB16 callback(Consumer<BlockRGB16> consumer) {
        consumer.accept(this);
        return this;
    }

    public BlockRGB16 tint(int ... indexes) {
        this.tintedIndexes = indexes;
        return this;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.supplier.create(pos, state);
    }

    protected TileEntityRGB16 getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityRGB16 ? (TileEntityRGB16)tile : null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityRGB16 tile = this.getTile((BlockGetter)world, pos);
        if (tile != null && stack.m_41720_() instanceof BlockItemRGB16) {
            tile.setRGB16(((BlockItemRGB16)stack.m_41720_()).getRGB16(stack), placer instanceof Player ? (Player)placer : null);
        }
    }

    @Override
    public boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hitVec, String dyeName) {
        TileEntityRGB16 tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((BlockGetter)world, pos)) != null) {
            RGB16 rgb16;
            if (!world.m_5776_() && (rgb16 = tile.getRGB16(player)) != null) {
                if (player == null) {
                    rgb16.setValues(dyeName);
                } else {
                    rgb16.recolor(player, dyeName);
                }
                Function.syncTile(tile);
            }
            if (player != null) {
                player.m_6674_(hand);
            }
            return true;
        }
        return false;
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        RGB16 rgb16;
        TileEntityRGB16 tile = this.getTile((BlockGetter)world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            int color = rgb16.getColor();
            return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        }
        return null;
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        RGB16 rgb16;
        TileEntityRGB16 tile;
        if (data.world != null && data.pos != null && (this.tintedIndexes == null || Arrays.stream(this.tintedIndexes).anyMatch(value -> value == index)) && (tile = this.getTile((BlockGetter)data.world, data.pos)) != null && (rgb16 = tile.getRGB16(null)) != null) {
            return rgb16.getColor();
        }
        return 0xFFFFFF;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        RGB16 rgb16;
        ItemStack stack = new ItemStack((ItemLike)this);
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            RGB16StackHelper.setRGB16(stack, rgb16);
        }
        return stack;
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends TileEntityRGB16> {
        public T create(BlockPos var1, BlockState var2);
    }
}

