/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.rsgauges.blocks.RsBlock;

public abstract class RsDirectedBlock
extends RsBlock {
    public static final long RSBLOCK_CONFIG_WALLMOUNT = 0x4000000000000000L;
    public static final long RSBLOCK_CONFIG_LATERAL = Long.MIN_VALUE;
    public static final long RSBLOCK_CONFIG_FULLCUBE = 0L;
    public static final long RSBLOCK_CONFIG_OPOSITE_PLACEMENT = 0x800000000000000L;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    protected final VoxelShape[][] shapes_;
    private static final Direction[][] facing_transform_lut = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.UP, Direction.DOWN, Direction.WEST, Direction.EAST}, {Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}};

    public RsDirectedBlock(long config, BlockBehaviour.Properties properties, @Nullable AABB aabb1, @Nullable AABB aabb2) {
        super(config | ((config & 0x3000000000000000L) == 0L && (aabb1.m_82362_() < 0.99 || aabb1.m_82376_() < 0.99 || aabb1.m_82362_() < 0.99) ? 0x1000000000000000L : 0L), properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
        VoxelShape[][] shapes = new VoxelShape[Direction.values().length][2];
        if (aabb1 == null) {
            aabb1 = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        if (aabb2 == null) {
            aabb2 = aabb1;
        }
        for (int i_dir = 0; i_dir < Direction.values().length; ++i_dir) {
            for (int i_pow = 0; i_pow < 2; ++i_pow) {
                AABB bb;
                AABB aABB = bb = i_pow == 0 ? aabb1 : aabb2;
                if ((config & Long.MIN_VALUE) == 0L) {
                    switch (i_dir) {
                        case 0: {
                            bb = new AABB(1.0 - bb.f_82291_, 1.0 - bb.f_82293_, 1.0 - bb.f_82292_, 1.0 - bb.f_82288_, 1.0 - bb.f_82290_, 1.0 - bb.f_82289_);
                            break;
                        }
                        case 1: {
                            bb = new AABB(1.0 - bb.f_82291_, bb.f_82290_, bb.f_82289_, 1.0 - bb.f_82288_, bb.f_82293_, bb.f_82292_);
                            break;
                        }
                        case 2: {
                            bb = new AABB(1.0 - bb.f_82291_, bb.f_82289_, 1.0 - bb.f_82293_, 1.0 - bb.f_82288_, bb.f_82292_, 1.0 - bb.f_82290_);
                            break;
                        }
                        case 3: {
                            bb = new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
                            break;
                        }
                        case 4: {
                            bb = new AABB(1.0 - bb.f_82293_, bb.f_82289_, bb.f_82288_, 1.0 - bb.f_82290_, bb.f_82292_, bb.f_82291_);
                            break;
                        }
                        case 5: {
                            bb = new AABB(bb.f_82290_, bb.f_82289_, 1.0 - bb.f_82291_, bb.f_82293_, bb.f_82292_, 1.0 - bb.f_82288_);
                        }
                    }
                } else {
                    bb = switch (i_dir) {
                        case 0, 1, 2 -> new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
                        case 3 -> new AABB(1.0 - bb.f_82291_, bb.f_82289_, 1.0 - bb.f_82293_, 1.0 - bb.f_82288_, bb.f_82292_, 1.0 - bb.f_82290_);
                        case 4 -> new AABB(bb.f_82290_, bb.f_82289_, 1.0 - bb.f_82291_, bb.f_82293_, bb.f_82292_, 1.0 - bb.f_82288_);
                        case 5 -> new AABB(1.0 - bb.f_82293_, bb.f_82289_, bb.f_82288_, 1.0 - bb.f_82290_, bb.f_82292_, bb.f_82291_);
                        default -> bb;
                    };
                }
                shapes[i_dir][i_pow] = Shapes.m_83064_((AABB)bb);
            }
        }
        this.shapes_ = shapes;
    }

    protected VoxelShape getShape(BlockState state) {
        return this.shapes_[((Direction)state.m_61143_((Property)FACING)).m_122411_()][0];
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
        return this.getShape(state);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.m_5940_(state, world, pos, selectionContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (!this.isValidPositionOnSide((LevelReader)context.m_43725_(), context.m_8083_(), context.m_43719_())) {
            return null;
        }
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        Direction facing = this.isWallMount() && !this.isLateral() ? context.m_43719_() : (this.isWallMount() && this.isLateral() ? context.m_43719_().m_122424_() : (!this.isWallMount() && this.isLateral() ? context.m_8125_() : context.m_7820_()));
        if (this.isOpositePlacement()) {
            facing = facing.m_122424_();
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (this.isCube() || !world.m_46859_(facingPos) && !facingState.m_60767_().m_76332_()) {
            return state;
        }
        Direction blockfacing = (Direction)state.m_61143_((Property)FACING);
        if (!this.isWallMount() && this.isLateral() && facing == Direction.DOWN) {
            return Blocks.f_50016_.m_49966_();
        }
        if (this.isWallMount() && !this.isLateral() && facing == ((Direction)state.m_61143_((Property)FACING)).m_122424_()) {
            return Blocks.f_50016_.m_49966_();
        }
        if (this.isWallMount() && this.isLateral() && facing == state.m_61143_((Property)FACING)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean isWallMount() {
        return (this.config & 0x4000000000000000L) != 0L;
    }

    public boolean isLateral() {
        return (this.config & Long.MIN_VALUE) != 0L;
    }

    public boolean isCube() {
        return (this.config & 0xC000000000000000L) == 0L;
    }

    public boolean isOpositePlacement() {
        return (this.config & 0x800000000000000L) != 0L;
    }

    protected boolean isAffectedByNeigbour(BlockState state, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.isCube()) {
            return true;
        }
        if (!this.isWallMount() && !pos.m_7495_().equals((Object)neighborPos)) {
            return false;
        }
        if (!this.isLateral() && !pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()).equals((Object)neighborPos)) {
            return false;
        }
        if (!pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()).equals((Object)neighborPos)) {
            return false;
        }
        BlockState neighborState = world.m_8055_(neighborPos);
        if (neighborState == null) {
            return false;
        }
        return !world.m_46859_(neighborPos) && !neighborState.m_60767_().m_76332_();
    }

    protected Direction getAbsoluteFacing(BlockState state, Direction relativeSide) {
        return state == null || relativeSide == null ? Direction.NORTH : facing_transform_lut[((Direction)state.m_61143_((Property)FACING)).m_122411_()][relativeSide.m_122411_()];
    }

    protected boolean isValidPositionOnSide(LevelReader world, BlockPos pos, Direction side) {
        if (this.isCube()) {
            return true;
        }
        if (this.isLateral() && !this.isWallMount()) {
            if (side != Direction.UP) {
                return false;
            }
            return Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_());
        }
        if (this.isWallMount()) {
            if (this.isLateral() && (side == Direction.UP || side == Direction.DOWN)) {
                return false;
            }
            BlockPos blockpos = pos.m_121945_(side.m_122424_());
            BlockState blockState = world.m_8055_(blockpos);
        }
        return true;
    }
}

