/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.RsAuxiliaries;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class IntervalTimerSwitchBlock
extends AutoSwitchBlock {
    public IntervalTimerSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public IntervalTimerSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IntervalTimerSwitchTileEntity(pos, state);
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof IntervalTimerSwitchBlock)) {
            return Optional.empty();
        }
        return Optional.of((Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0);
    }

    public static class IntervalTimerSwitchTileEntity
    extends AutoSwitchBlock.AutoSwitchTileEntity {
        private static final int ramp_max = 5;
        private static final int t_max = 12000;
        private static final int t_min = 5;
        private int p_set_ = 15;
        private int t_on_ = 20;
        private int t_off_ = 20;
        private int ramp_ = 0;
        private int update_timer_ = 0;
        private int p_ = 0;
        private boolean s_ = false;

        public IntervalTimerSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public IntervalTimerSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_TIMER_SWITCH, pos, state);
        }

        public void restart() {
            this.update_timer_ = 0;
            this.p_ = 0;
            this.s_ = false;
        }

        public int p_set() {
            return this.p_set_;
        }

        public int t_on() {
            return this.t_on_;
        }

        public int t_off() {
            return this.t_off_;
        }

        public int ramp() {
            return this.ramp_;
        }

        public void p_set(int v) {
            this.p_set_ = v < 1 ? 1 : Math.min(v, 15);
        }

        public void t_on(int v) {
            this.t_on_ = v < 0 ? 0 : Math.min(v, 12000);
        }

        public void t_off(int v) {
            this.t_off_ = v < 0 ? 0 : Math.min(v, 12000);
        }

        public void ramp(int v) {
            this.ramp_ = v < 0 ? 0 : Math.min(v, 5);
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            super.write(nbt, updatePacket);
            nbt.m_128405_("pset", this.p_set());
            nbt.m_128405_("toff", this.t_off());
            nbt.m_128405_("ton", this.t_on());
            nbt.m_128405_("ramp", this.ramp());
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            super.read(nbt, updatePacket);
            this.p_set(nbt.m_128451_("pset"));
            this.t_off(nbt.m_128451_("toff"));
            this.t_on(nbt.m_128451_("ton"));
            this.ramp(nbt.m_128451_("ramp"));
        }

        private int next_higher_interval_setting(int ticks) {
            ticks = ticks < 100 ? (ticks += 5) : (ticks < 200 ? (ticks += 10) : (ticks < 400 ? (ticks += 20) : (ticks < 600 ? (ticks += 40) : (ticks < 800 ? (ticks += 100) : (ticks < 2400 ? (ticks += 200) : (ticks += 600))))));
            return Math.min(ticks, 12000);
        }

        private int next_lower_interval_setting(int ticks) {
            ticks = ticks < 100 ? (ticks -= 5) : (ticks < 200 ? (ticks -= 10) : (ticks < 400 ? (ticks -= 20) : (ticks < 600 ? (ticks -= 40) : (ticks < 800 ? (ticks -= 100) : (ticks < 2400 ? (ticks -= 200) : (ticks -= 600))))));
            return Math.max(ticks, 5);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            boolean selected;
            int direction;
            if (state == null || !(state.m_60734_() instanceof SwitchBlock)) {
                return false;
            }
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int field = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (x >= 11.0 && x <= 13.0 ? 4 : 0)));
            boolean bl = selected = direction != 0 && field != 0;
            if (selected && !show_only) {
                switch (field) {
                    case 1: {
                        this.t_on(direction > 0 ? this.next_higher_interval_setting(this.t_on()) : this.next_lower_interval_setting(this.t_on()));
                        break;
                    }
                    case 2: {
                        this.t_off(direction > 0 ? this.next_higher_interval_setting(this.t_off()) : this.next_lower_interval_setting(this.t_off()));
                        break;
                    }
                    case 3: {
                        this.ramp(this.ramp() + direction);
                        break;
                    }
                    case 4: {
                        this.p_set((this.p_set() <= 0 ? 15 : this.p_set()) + direction);
                    }
                }
                this.m_6596_();
            }
            boolean switch_state = (Boolean)state.m_61143_((Property)SwitchBlock.POWERED);
            if (!selected) {
                switch_state = !switch_state;
            }
            this.updateSwitchState(state, (AutoSwitchBlock)state.m_60734_(), switch_state, 0);
            MutableComponent separator = Component.m_237113_((String)" | ");
            separator.m_130940_(ChatFormatting.GRAY);
            ArrayList<MutableComponent> tr = new ArrayList<MutableComponent>();
            tr.add(Auxiliaries.localizable("switchconfig.intervaltimer.t_on", ChatFormatting.BLUE, new Object[]{RsAuxiliaries.ticksToSecondsString(this.t_on())}));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.intervaltimer.t_off", ChatFormatting.YELLOW, new Object[]{RsAuxiliaries.ticksToSecondsString(this.t_off())})));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.intervaltimer.output_power", ChatFormatting.RED, new Object[]{this.p_set()})));
            if (this.ramp() > 0) {
                tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.intervaltimer.ramp", ChatFormatting.DARK_GREEN, new Object[]{this.ramp()})));
            }
            if (!switch_state) {
                tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.intervaltimer.standby", ChatFormatting.AQUA, new Object[0])));
            }
            while (tr.size() < 5) {
                tr.add(Component.m_237113_((String)""));
            }
            Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.intervaltimer", ChatFormatting.RESET, tr.toArray()));
            return selected;
        }

        @Override
        public int power(BlockState state, boolean strong) {
            return this.nooutput() || (Boolean)state.m_61143_((Property)SwitchBlock.POWERED) == false || strong && this.weak() ? 0 : this.setpower();
        }

        @Override
        public void tick() {
            if (!this.m_58898_() || this.m_58904_().m_5776_() || --this.update_timer_ > 0) {
                return;
            }
            int p = this.p_;
            if (this.t_on() <= 0 || this.t_off() <= 0 || this.p_set() <= 0) {
                this.p_ = 0;
                this.update_timer_ = 20;
            } else if (!this.s_) {
                this.update_timer_ = this.t_on();
                if (this.ramp() <= 0 || (this.p_ += this.ramp()) >= this.p_set()) {
                    this.p_ = this.p_set();
                    this.s_ = true;
                } else {
                    this.update_timer_ = 5;
                }
            } else {
                this.update_timer_ = this.t_off();
                if (this.ramp() <= 0 || (this.p_ -= this.ramp()) <= 0) {
                    this.p_ = 0;
                    this.s_ = false;
                } else {
                    this.update_timer_ = 5;
                }
            }
            if (p != this.p_) {
                this.setpower(this.inverted() ? 15 - this.p_ : this.p_);
                BlockState state = this.m_58904_().m_8055_(this.m_58899_());
                if (state == null || !(state.m_60734_() instanceof AutoSwitchBlock) || !((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue()) {
                    this.update_timer_ = 200 + (int)(Math.random() * 10.0);
                    this.setpower(this.inverted() ? 15 : 0);
                }
                this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                this.f_58857_.m_46672_(this.f_58858_.m_121945_(((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_122424_()), state.m_60734_());
            }
        }
    }
}

