/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.system;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerTileEntity;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingRequest;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingSystem {
    private final StorageScannerTileEntity storage;
    private final Queue<CraftingRequest> queuedRequests = new ArrayDeque<CraftingRequest>();
    private final List<CraftingRequest> suspendedRequests = new ArrayList<CraftingRequest>();
    private final List<CraftingRequest> failedRequests = new ArrayList<CraftingRequest>();
    private int currentRequestId = 0;
    private final Map<Integer, CraftingRequest> craftingRequestMap = new HashMap<Integer, CraftingRequest>();

    public CraftingSystem(StorageScannerTileEntity storage) {
        this.storage = storage;
    }

    public void tick(Level world) {
        CraftingRequest request = this.queuedRequests.poll();
        if (request != null) {
            this.startRequest(world, request);
        }
        boolean[] checkSuspendedCrafts = new boolean[]{false};
        this.storage.getCraftingInventories().forEach(pos -> {
            CraftingManagerTileEntity craftingManager;
            boolean ready;
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof CraftingManagerTileEntity && (ready = (craftingManager = (CraftingManagerTileEntity)te).tick(this))) {
                checkSuspendedCrafts[0] = true;
            }
        });
        if (checkSuspendedCrafts[0]) {
            this.queuedRequests.addAll(this.suspendedRequests);
            this.suspendedRequests.clear();
        }
    }

    public StorageScannerTileEntity getStorage() {
        return this.storage;
    }

    public List<CraftingRequest> getFailedRequests() {
        return this.failedRequests;
    }

    private void startRequest(Level world, CraftingRequest request) {
        BestDevice bestDevice = this.storage.getCraftingInventories().stream().collect(BestDevice::new, (best, pos) -> {
            CraftingManagerTileEntity craftingManager;
            Pair<Double, Integer> pair;
            Double quality;
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof CraftingManagerTileEntity && (quality = (Double)(pair = (craftingManager = (CraftingManagerTileEntity)te).getCraftingQuality(request.ingredient(), request.amount())).getLeft()) >= 0.0 && quality > best.quality) {
                best.quality = quality;
                best.queue = (Integer)pair.getRight();
                best.craftingManager = craftingManager;
            }
        }, (best1, best2) -> {});
        if (bestDevice.craftingManager == null) {
            this.failedRequests.add(request);
        } else {
            List<Ingredient> ingredients = bestDevice.craftingManager.getIngredients(bestDevice.queue, request);
            List<ItemStack> extractedItems = this.storage.requestIngredients(ingredients, ingredient -> {
                CraftingRequest newRequest = new CraftingRequest(this.newRequestId(), (Ingredient)ingredient, 1, request.id());
                this.queuedRequests.add(newRequest);
            }, bestDevice.quality >= 10000.0);
            if (extractedItems == null) {
                this.failedRequests.add(request);
            } else if (extractedItems.isEmpty()) {
                this.suspendedRequests.add(request);
            } else if (!bestDevice.craftingManager.startCraft(bestDevice.queue, request, extractedItems)) {
                this.rollback(world, extractedItems);
                this.failedRequests.add(request);
            }
        }
    }

    private void rollback(Level world, List<ItemStack> extractedItems) {
        for (ItemStack stack : extractedItems) {
            ItemStack left = this.storage.insertInternal(stack, false);
            if (left.m_41619_()) continue;
            Containers.m_18992_((Level)world, (double)((double)this.storage.m_58899_().m_123341_() + 0.5), (double)((double)this.storage.m_58899_().m_123342_() + 1.5), (double)((double)this.storage.m_58899_().m_123343_() + 0.5), (ItemStack)left);
        }
    }

    private int newRequestId() {
        int id = this.currentRequestId++;
        return id;
    }

    public void requestCraft(ItemStack stack, int amount) {
        CraftingRequest request = new CraftingRequest(this.newRequestId(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), amount, -1);
        this.queuedRequests.add(request);
    }

    public void read(CompoundTag tag) {
        this.currentRequestId = tag.m_128451_("currentRequestId");
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("currentRequestId", this.currentRequestId);
        return tag;
    }

    private static class BestDevice {
        double quality = -1.0;
        int queue = -1;
        CraftingManagerTileEntity craftingManager;

        private BestDevice() {
        }
    }
}

