/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.setup.RFToolsPowerMessages;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class GuiDimensionalCell
extends GenericGuiContainer<DimensionalCellTileEntity, GenericContainer> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolspower", "textures/gui/dimensionalcell.png");

    public GuiDimensionalCell(DimensionalCellTileEntity te, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)te, (AbstractContainerMenu)container, inventory, ((DimensionalCellBlock)((Object)DimensionalCellModule.DIMENSIONAL_CELL.get())).getManualEntry());
        this.f_97726_ = 180;
        this.f_97727_ = 152;
    }

    public static void register() {
        GuiDimensionalCell.register((MenuType)((MenuType)DimensionalCellModule.CONTAINER_DIMENSIONAL_CELL.get()), GuiDimensionalCell::new);
    }

    public void m_7856_() {
        super.m_7856_();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue(1000L).hint(10, 7, 8, 54)).showText(false);
        this.energyBar.value(0L);
        Button allNone = (Button)((Button)Widgets.button((int)140, (int)10, (int)32, (int)15, (String)"None").name("allnone")).tooltips(new String[]{"Set all sides to 'none'"});
        Button allInput = (Button)((Button)Widgets.button((int)140, (int)27, (int)32, (int)15, (String)"In").name("allinput")).tooltips(new String[]{"Set all sides to", "accept energy"});
        Button allOutput = (Button)((Button)Widgets.button((int)140, (int)44, (int)32, (int)15, (String)"Out").name("alloutput")).tooltips(new String[]{"Set all sides to", "send energy"});
        this.stats = (Button)((Button)Widgets.button((int)100, (int)10, (int)32, (int)15, (String)"Stats").name("clearstats")).tooltips(new String[]{"Power statistics. Press to clear:"});
        Label label = (Label)Widgets.label((int)26, (int)30, (int)40, (int)18, (String)"Link:").tooltips(new String[]{"Link a powercard to card", "on the left"});
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.energyBar, allNone, allInput, allOutput, label, this.stats});
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.action(RFToolsPowerMessages.INSTANCE, "allnone", (GenericTileEntity)((DimensionalCellTileEntity)this.tileEntity), DimensionalCellTileEntity.ACTION_SETNONE);
        this.window.action(RFToolsPowerMessages.INSTANCE, "allinput", (GenericTileEntity)((DimensionalCellTileEntity)this.tileEntity), DimensionalCellTileEntity.ACTION_SETINPUT);
        this.window.action(RFToolsPowerMessages.INSTANCE, "alloutput", (GenericTileEntity)((DimensionalCellTileEntity)this.tileEntity), DimensionalCellTileEntity.ACTION_SETOUTPUT);
        this.window.action(RFToolsPowerMessages.INSTANCE, "clearstats", (GenericTileEntity)((DimensionalCellTileEntity)this.tileEntity), DimensionalCellTileEntity.ACTION_CLEARSTATS);
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            ((DimensionalCellTileEntity)this.tileEntity).requestDataFromServer(RFToolsPowerMessages.INSTANCE, (ICommand)DimensionalCellTileEntity.CMD_GET_INFO, TypedMap.EMPTY);
        }
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float v, int i, int i2) {
        this.drawWindow(matrixStack);
        this.requestRF();
        this.stats.tooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + ((DimensionalCellTileEntity)this.tileEntity).tooltipInserted, "Extracted: " + ((DimensionalCellTileEntity)this.tileEntity).tooltipExtracted});
        int maxValue = (((DimensionalCellTileEntity)this.tileEntity).tooltipBlocks - ((DimensionalCellTileEntity)this.tileEntity).tooltipAdvancedBlocks - ((DimensionalCellTileEntity)this.tileEntity).tooltipSimpleBlocks) * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get();
        maxValue += ((DimensionalCellTileEntity)this.tileEntity).tooltipAdvancedBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * (Integer)DimensionalCellConfiguration.advancedFactor.get();
        this.energyBar.maxValue((long)(maxValue += ((DimensionalCellTileEntity)this.tileEntity).tooltipSimpleBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() / (Integer)DimensionalCellConfiguration.simpleFactor.get()));
        this.energyBar.value((long)((DimensionalCellTileEntity)this.tileEntity).tooltipEnergy);
    }
}

