/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class WorkbenchTileEntity
extends GenericTileEntity {
    public static final int SLOT_CRAFTINPUT = 0;
    public static final int SLOT_CRAFTOUTPUT = 9;
    public static final int SLOT_BUFFER = 10;
    public static final int BUFFER_SIZE = 27;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(37).box(SlotDefinition.generic(), 0, 42, 27, 3, 3).box(SlotDefinition.craftResult().onCraft((tileEntity, playerEntity, stack) -> ((WorkbenchTileEntity)((Object)((Object)tileEntity))).craftItem()), 9, 114, 45, 1, 1).box(SlotDefinition.generic(), 10, 6, 99, 9, 3).playerSlots(6, 157));
    private final GenericItemHandler items = this.createItemHandler();
    private final LazyOptional<WorkbenchItemHandler> automationItemHandlerUp = LazyOptional.of(() -> new WorkbenchItemHandler(this.items, Direction.UP));
    private final LazyOptional<WorkbenchItemHandler> automationItemHandlerDown = LazyOptional.of(() -> new WorkbenchItemHandler(this.items, Direction.DOWN));
    private final LazyOptional<WorkbenchItemHandler> automationItemHandlerSide = LazyOptional.of(() -> new WorkbenchItemHandler(this.items, null));
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Workbench").containerSupplier((windowId, player) -> new WorkbenchContainer((int)windowId, (ContainerFactory)CONTAINER_FACTORY.get(), this.m_58899_(), this, (Player)player)).itemHandler(() -> this.items));
    private int realItems = 0;

    public WorkbenchTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VariousModule.TYPE_WORKBENCH.get(), pos, state);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.realItems = info.m_128451_("realItems");
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("realItems", this.realItems);
    }

    private boolean isCraftInputSlot(int slot) {
        return slot >= 0 && slot < 9;
    }

    private boolean isBufferSlot(int slot) {
        return slot >= 10 && slot < 37;
    }

    private boolean isCraftOutput(int slot) {
        return slot == 9;
    }

    @Nullable
    private Recipe findRecipe(CraftingContainer workInventory) {
        RecipeManager manager = this.f_58857_.m_7465_();
        for (Recipe r : manager.m_44051_()) {
            if (r == null || !RecipeType.f_44107_.equals(r.m_6671_()) || !r.m_5818_((Container)workInventory, this.f_58857_)) continue;
            return r;
        }
        return null;
    }

    private void updateRecipe() {
        if (this.items.getStackInSlot(9).m_41619_() || this.realItems == 0) {
            CraftingContainer workInventory = this.makeWorkInventory();
            Recipe recipe = this.findRecipe(workInventory);
            if (recipe != null) {
                ItemStack stack = BaseRecipe.assemble((Recipe)recipe, (CraftingContainer)workInventory, (Level)this.f_58857_);
                this.items.setStackInSlot(9, stack);
            } else {
                this.items.setStackInSlot(9, ItemStack.f_41583_);
            }
        }
    }

    private CraftingContainer makeWorkInventory() {
        CraftingContainer workInventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean m_6875_(Player var1) {
                return false;
            }

            public ItemStack m_7648_(Player player, int slot) {
                return ItemStack.f_41583_;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            workInventory.m_6836_(i, this.items.getStackInSlot(i + 0));
        }
        return workInventory;
    }

    public void craftItem() {
    }

    private GenericItemHandler createItemHandler() {
        return new GenericItemHandler(this, (ContainerFactory)CONTAINER_FACTORY.get()){
            private int crafting;
            {
                this.crafting = 0;
            }

            protected void onUpdate(int index, ItemStack stack) {
                if (WorkbenchTileEntity.this.isCraftInputSlot(index) && this.crafting <= 0) {
                    WorkbenchTileEntity.this.updateRecipe();
                }
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                CraftingContainer workInventory;
                Recipe recipe;
                if (simulate) {
                    return super.extractItem(slot, amount, simulate);
                }
                if (WorkbenchTileEntity.this.isCraftOutput(slot) && WorkbenchTileEntity.this.realItems == 0 && (recipe = WorkbenchTileEntity.this.findRecipe(workInventory = WorkbenchTileEntity.this.makeWorkInventory())) != null) {
                    ++this.crafting;
                    NonNullList remainingItems = recipe.m_7457_((Container)workInventory);
                    for (int i = 0; i < 9; ++i) {
                        ItemStack s = WorkbenchTileEntity.this.items.getStackInSlot(i + 0);
                        if (!s.m_41619_()) {
                            super.extractItem(i + 0, 1, false);
                            s = WorkbenchTileEntity.this.items.getStackInSlot(i + 0);
                        }
                        if (((ItemStack)remainingItems.get(i)).m_41619_()) continue;
                        if (s.m_41619_()) {
                            WorkbenchTileEntity.this.items.setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                            continue;
                        }
                        if (!ItemStack.m_41746_((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i))) || !ItemStack.m_41658_((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i)))) continue;
                        ItemStack stack = (ItemStack)remainingItems.get(i);
                        stack.m_41769_(s.m_41613_());
                        WorkbenchTileEntity.this.items.setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                    }
                    --this.crafting;
                }
                ItemStack rc = super.extractItem(slot, amount, false);
                if (WorkbenchTileEntity.this.isCraftOutput(slot)) {
                    ItemStack stack = WorkbenchTileEntity.this.items.getStackInSlot(slot);
                    WorkbenchTileEntity.this.realItems = !stack.m_41619_() ? stack.m_41613_() : 0;
                }
                if (WorkbenchTileEntity.this.isCraftInputSlot(slot) || WorkbenchTileEntity.this.isCraftOutput(slot)) {
                    WorkbenchTileEntity.this.updateRecipe();
                }
                return rc;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.automationItemHandlerDown.cast();
            }
            if (facing == Direction.UP) {
                return this.automationItemHandlerUp.cast();
            }
            return this.automationItemHandlerSide.cast();
        }
        return super.getCapability(cap, facing);
    }

    public class WorkbenchItemHandler
    extends AutomationFilterItemHander {
        private final Direction direction;

        public WorkbenchItemHandler(@Nullable GenericItemHandler wrapped, Direction direction) {
            super(wrapped);
            this.direction = direction;
        }

        public boolean canAutomationInsert(int index) {
            if (this.direction == null) {
                return !WorkbenchTileEntity.this.isCraftOutput(index);
            }
            if (this.direction == Direction.DOWN) {
                return false;
            }
            if (this.direction == Direction.UP) {
                return WorkbenchTileEntity.this.isCraftInputSlot(index);
            }
            return WorkbenchTileEntity.this.isBufferSlot(index);
        }

        public boolean canAutomationExtract(int index) {
            if (this.direction == null) {
                return true;
            }
            if (this.direction == Direction.DOWN) {
                return WorkbenchTileEntity.this.isCraftOutput(index);
            }
            if (this.direction == Direction.UP) {
                return WorkbenchTileEntity.this.isCraftInputSlot(index);
            }
            return WorkbenchTileEntity.this.isBufferSlot(index);
        }
    }
}

