/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class GfxOpLine
extends GfxOp {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int color;

    public GfxOpLine() {
    }

    public GfxOpLine(int x1, int y1, int x2, int y2, int color) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer) {
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.OVERLAY_LINES);
        RenderHelper.line((VertexConsumer)builder, (PoseStack)matrixStack, (float)this.x1, (float)this.y1, (float)0.0f, (float)this.x2, (float)this.y2, (float)0.0f, (float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public GfxOpType getType() {
        return GfxOpType.OP_LINE;
    }

    @Override
    protected void readFromNBTInternal(CompoundTag tag) {
        this.x1 = tag.m_128445_("x1");
        this.y1 = tag.m_128445_("y1");
        this.x2 = tag.m_128445_("x2");
        this.y2 = tag.m_128445_("y2");
        this.color = tag.m_128451_("color");
    }

    @Override
    protected void writeToNBTInternal(CompoundTag tag) {
        tag.m_128344_("x1", (byte)this.x1);
        tag.m_128344_("y1", (byte)this.y1);
        tag.m_128344_("x2", (byte)this.x2);
        tag.m_128344_("y2", (byte)this.y2);
        tag.m_128405_("color", this.color);
    }

    @Override
    protected void readFromBufInternal(FriendlyByteBuf buf) {
        this.x1 = buf.readByte();
        this.y1 = buf.readByte();
        this.x2 = buf.readByte();
        this.y2 = buf.readByte();
        this.color = buf.readInt();
    }

    @Override
    protected void writeToBufInternal(FriendlyByteBuf buf) {
        buf.writeByte(this.x1);
        buf.writeByte(this.y1);
        buf.writeByte(this.x2);
        buf.writeByte(this.y2);
        buf.writeInt(this.color);
    }
}

