/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketFluidsReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetFluids {
    private final BlockPos pos;
    private final ResourceKey<Level> type;
    private final TypedMap params;
    private final boolean fromTablet;

    public PacketGetFluids(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.type = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.params = TypedMapTools.readArguments((FriendlyByteBuf)buf);
        this.fromTablet = buf.readBoolean();
    }

    public PacketGetFluids(BlockPos pos, ResourceKey<Level> type, boolean fromTablet) {
        this.pos = pos;
        this.type = type;
        this.params = TypedMap.EMPTY;
        this.fromTablet = fromTablet;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.type.m_135782_());
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.params);
        buf.writeBoolean(this.fromTablet);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)ctx.getSender().m_20193_(), this.type);
            if (world.m_46805_(this.pos) && (te = world.m_7702_(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETFLUIDS.name(), (Player)ctx.getSender(), this.params, FluidEntry.class);
                RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketFluidsReady(this.fromTablet ? null : this.pos, ProcessorTileEntity.CMD_GETFLUIDS.name(), list), ctx.getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static class FluidEntry {
        private final FluidStack fluidStack;
        private final boolean allocated;

        public FluidEntry(FluidStack fluidStack, boolean allocated) {
            this.fluidStack = fluidStack;
            this.allocated = allocated;
        }

        public static FluidEntry fromPacket(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                FluidStack fluidStack = null;
                if (buf.readBoolean()) {
                    fluidStack = NetworkTools.readFluidStack((ByteBuf)buf);
                }
                boolean allocated = buf.readBoolean();
                return new FluidEntry(fluidStack, allocated);
            }
            return null;
        }

        public static void toPacket(FriendlyByteBuf buf, FluidEntry item) {
            if (item == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                if (item.getFluidStack() != null) {
                    buf.writeBoolean(true);
                    NetworkTools.writeFluidStack((ByteBuf)buf, (FluidStack)item.getFluidStack());
                } else {
                    buf.writeBoolean(false);
                }
                buf.writeBoolean(item.isAllocated());
            }
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }

        public boolean isAllocated() {
            return this.allocated;
        }

        public static class Serializer
        implements ISerializer<FluidEntry> {
            public Function<FriendlyByteBuf, FluidEntry> getDeserializer() {
                return FluidEntry::fromPacket;
            }

            public BiConsumer<FriendlyByteBuf, FluidEntry> getSerializer() {
                return FluidEntry::toPacket;
            }
        }
    }
}

