/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Functions;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ParameterTypeTools {
    public static String stringRepresentation(ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            return "V:" + value.getVariableIndex();
        }
        if (value.isFunction()) {
            return "F:" + value.getFunction().getName();
        }
        if (value.getValue() == null) {
            return "";
        }
        return ParameterTypeTools.stringRepresentationInternal(type, value.getValue());
    }

    private static String stringRepresentationInternal(ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                return (String)value;
            }
            case PAR_INTEGER: {
                return Integer.toString((Integer)value);
            }
            case PAR_LONG: {
                return Long.toString((Long)value);
            }
            case PAR_FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case PAR_NUMBER: {
                String s = TypeConverters.castNumberToString(value);
                return s + " (" + TypeConverters.getNumberType(value) + ")";
            }
            case PAR_SIDE: {
                return ((BlockSide)value).getStringRepresentation();
            }
            case PAR_BOOLEAN: {
                return (Boolean)value != false ? "true" : "false";
            }
            case PAR_INVENTORY: {
                return ((Inventory)value).getStringRepresentation();
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                return StringUtils.left((String)itemStack.m_41786_().getString(), (int)10);
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                return StringUtils.left((String)fluidStack.getDisplayName().getString(), (int)10);
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                return exception.getCode();
            }
            case PAR_TUPLE: {
                return value.toString();
            }
            case PAR_VECTOR: {
                return "[" + ((List)value).size() + "]";
            }
        }
        return "?";
    }

    public static JsonElement writeToJson(ParameterType type, ParameterValue value) {
        JsonObject jsonObject = new JsonObject();
        if (value.isVariable()) {
            jsonObject.add("var", (JsonElement)new JsonPrimitive((Number)value.getVariableIndex()));
        } else if (value.isFunction()) {
            jsonObject.add("fun", (JsonElement)new JsonPrimitive(value.getFunction().getId()));
        } else if (value.getValue() == null) {
            jsonObject.add("null", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        } else {
            ParameterTypeTools.writeToJsonInternal(jsonObject, type, value.getValue());
        }
        return jsonObject;
    }

    public static ParameterValue readFromJson(ParameterType type, JsonObject object) {
        if (object.has("var")) {
            return ParameterValue.variable((int)object.get("var").getAsInt());
        }
        if (object.has("fun")) {
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(object.get("fun").getAsString()));
        }
        if (object.has("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromJsonInternal(object, type);
    }

    public static void writeToNBT(CompoundTag tag, ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            tag.m_128405_("varIdx", value.getVariableIndex());
        } else if (value.isFunction()) {
            tag.m_128359_("funId", value.getFunction().getId());
        } else if (value.getValue() == null) {
            tag.m_128379_("null", true);
        } else {
            ParameterTypeTools.writeToNBTInternal(tag, type, value.getValue());
        }
    }

    public static ParameterValue readFromNBT(CompoundTag tag, ParameterType type) {
        if (tag.m_128441_("varIdx")) {
            return ParameterValue.variable((int)tag.m_128451_("varIdx"));
        }
        if (tag.m_128441_("funId")) {
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(tag.m_128461_("funId")));
        }
        if (tag.m_128441_("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromNBTInternal(tag, type);
    }

    private static ParameterValue readFromNBTInternal(CompoundTag tag, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant((Object)tag.m_128461_("v"));
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Object)tag.m_128451_("v"));
            }
            case PAR_LONG: {
                return ParameterValue.constant((Object)tag.m_128454_("v"));
            }
            case PAR_FLOAT: {
                return ParameterValue.constant((Object)Float.valueOf(tag.m_128457_("v")));
            }
            case PAR_NUMBER: {
                if (tag.m_128441_("v")) {
                    return ParameterValue.constant((Object)tag.m_128451_("v"));
                }
                if (tag.m_128441_("l")) {
                    return ParameterValue.constant((Object)tag.m_128454_("l"));
                }
                if (tag.m_128441_("f")) {
                    return ParameterValue.constant((Object)Float.valueOf(tag.m_128457_("f")));
                }
                if (!tag.m_128441_("d")) break;
                return ParameterValue.constant((Object)tag.m_128459_("d"));
            }
            case PAR_SIDE: {
                int v = tag.m_128451_("v");
                Direction facing = v == -1 ? null : Direction.values()[v];
                String node = tag.m_128461_("node");
                return ParameterValue.constant((Object)new BlockSide(node, facing));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Object)tag.m_128471_("v"));
            }
            case PAR_INVENTORY: {
                Direction side = Direction.values()[tag.m_128451_("side")];
                String name = null;
                Direction intSide = null;
                if (tag.m_128441_("nodeName")) {
                    name = tag.m_128461_("nodeName");
                }
                if (tag.m_128441_("intSide")) {
                    intSide = Direction.values()[tag.m_128451_("intSide")];
                }
                return ParameterValue.constant((Object)new Inventory(name, side, intSide));
            }
            case PAR_ITEM: {
                if (tag.m_128441_("item")) {
                    CompoundTag tc = tag.m_128469_("item");
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)tc);
                    if (stack.m_41613_() == 0) {
                        stack.m_41764_(1);
                    }
                    return ParameterValue.constant((Object)stack);
                }
                return ParameterValue.constant((Object)ItemStack.f_41583_);
            }
            case PAR_FLUID: {
                if (tag.m_128441_("fluid")) {
                    CompoundTag tc = tag.m_128469_("fluid");
                    FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)tc);
                    return ParameterValue.constant((Object)stack);
                }
                return ParameterValue.constant(null);
            }
            case PAR_EXCEPTION: {
                String code = tag.m_128461_("code");
                return ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(code)));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant((Object)new Tuple(tag.m_128451_("x"), tag.m_128451_("y")));
            }
            case PAR_VECTOR: {
                ListTag array = tag.m_128437_("vector", 10);
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (int i = 0; i < array.size(); ++i) {
                    vector.add(ParameterTools.readFromNBT(array.m_128728_(i)));
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return ParameterValue.constant(null);
    }

    private static void writeToNBTInternal(CompoundTag tag, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                tag.m_128359_("v", (String)value);
                break;
            }
            case PAR_INTEGER: {
                tag.m_128405_("v", ((Integer)value).intValue());
                break;
            }
            case PAR_LONG: {
                tag.m_128356_("v", ((Long)value).longValue());
                break;
            }
            case PAR_FLOAT: {
                tag.m_128350_("v", ((Float)value).floatValue());
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    tag.m_128405_("v", ((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    tag.m_128356_("l", ((Long)value).longValue());
                    break;
                }
                if (value instanceof Float) {
                    tag.m_128350_("f", ((Float)value).floatValue());
                    break;
                }
                if (!(value instanceof Double)) break;
                tag.m_128347_("d", ((Double)value).doubleValue());
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                tag.m_128405_("v", side.getSide() == null ? -1 : side.getSide().ordinal());
                tag.m_128359_("node", side.getNodeName() == null ? "" : side.getNodeName());
                break;
            }
            case PAR_BOOLEAN: {
                tag.m_128379_("v", ((Boolean)value).booleanValue());
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                if (inv.getNodeName() != null) {
                    tag.m_128359_("nodeName", inv.getNodeName());
                }
                tag.m_128405_("side", inv.getSide().ordinal());
                if (inv.getIntSide() == null) break;
                tag.m_128405_("intSide", inv.getIntSide().ordinal());
                break;
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                CompoundTag tc = new CompoundTag();
                itemStack.m_41739_(tc);
                tag.m_128365_("item", (Tag)tc);
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                CompoundTag fluidTc = new CompoundTag();
                fluidStack.writeToNBT(fluidTc);
                tag.m_128365_("fluid", (Tag)fluidTc);
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                tag.m_128359_("code", exception.getCode());
                break;
            }
            case PAR_TUPLE: {
                tag.m_128405_("x", ((Tuple)value).getX());
                tag.m_128405_("y", ((Tuple)value).getY());
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                ListTag list = new ListTag();
                for (Parameter p : vector) {
                    list.add((Object)ParameterTools.writeToNBT(p));
                }
                tag.m_128365_("vector", (Tag)list);
            }
        }
    }

    private static void writeToJsonInternal(JsonObject object, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                object.add("v", (JsonElement)new JsonPrimitive((String)value));
                break;
            }
            case PAR_INTEGER: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                break;
            }
            case PAR_LONG: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                break;
            }
            case PAR_FLOAT: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                    break;
                }
                if (value instanceof Long) {
                    object.add("l", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                    break;
                }
                if (value instanceof Float) {
                    object.add("f", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                    break;
                }
                if (!(value instanceof Double)) break;
                object.add("d", (JsonElement)new JsonPrimitive((Number)((Double)value)));
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                if (side.getSide() != null) {
                    object.add("side", (JsonElement)new JsonPrimitive(side.getSide().m_7912_()));
                }
                if (side.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(side.getNodeName()));
                break;
            }
            case PAR_BOOLEAN: {
                object.add("v", (JsonElement)new JsonPrimitive((Boolean)value));
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                object.add("side", (JsonElement)new JsonPrimitive(inv.getSide().m_7912_()));
                if (inv.getIntSide() != null) {
                    object.add("intside", (JsonElement)new JsonPrimitive(inv.getIntSide().m_7912_()));
                }
                if (inv.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(inv.getNodeName()));
                break;
            }
            case PAR_ITEM: {
                ItemStack item = (ItemStack)value;
                object.add("item", (JsonElement)new JsonPrimitive(Tools.getId((ItemStack)item).toString()));
                if (item.m_41613_() != 1) {
                    object.add("amount", (JsonElement)new JsonPrimitive((Number)item.m_41613_()));
                }
                if (!item.m_41782_()) break;
                String string = item.m_41783_().toString();
                object.add("nbt", (JsonElement)new JsonPrimitive(string));
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                object.add("fluid", (JsonElement)new JsonPrimitive(Tools.getId((FluidStack)fluidStack).toString()));
                object.add("amount", (JsonElement)new JsonPrimitive((Number)fluidStack.getAmount()));
                if (!fluidStack.hasTag()) break;
                object.add("nbt", (JsonElement)new JsonPrimitive(fluidStack.getTag().toString()));
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                object.add("code", (JsonElement)new JsonPrimitive(exception.getCode()));
                break;
            }
            case PAR_TUPLE: {
                object.add("x", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getX()));
                object.add("y", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getY()));
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                JsonArray array = new JsonArray();
                for (Parameter p : vector) {
                    array.add(ParameterTools.getJsonElement(p));
                }
                object.add("vector", (JsonElement)array);
            }
        }
    }

    private static ParameterValue readFromJsonInternal(JsonObject object, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant((Object)object.get("v").getAsString());
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Object)object.get("v").getAsInt());
            }
            case PAR_LONG: {
                return ParameterValue.constant((Object)object.get("v").getAsLong());
            }
            case PAR_FLOAT: {
                return ParameterValue.constant((Object)Float.valueOf(object.get("v").getAsFloat()));
            }
            case PAR_NUMBER: {
                if (object.has("v")) {
                    return ParameterValue.constant((Object)object.get("v").getAsInt());
                }
                if (object.has("l")) {
                    return ParameterValue.constant((Object)object.get("l").getAsLong());
                }
                if (object.has("f")) {
                    return ParameterValue.constant((Object)Float.valueOf(object.get("f").getAsFloat()));
                }
                if (!object.has("d")) break;
                return ParameterValue.constant((Object)object.get("d").getAsDouble());
            }
            case PAR_SIDE: {
                Direction side = object.has("side") ? Direction.m_122402_((String)object.get("side").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant((Object)new BlockSide(node, side));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Object)object.get("v").getAsBoolean());
            }
            case PAR_INVENTORY: {
                Direction side = Direction.m_122402_((String)object.get("side").getAsString());
                Direction intSide = object.has("intside") ? Direction.m_122402_((String)object.get("intside").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant((Object)new Inventory(node, side, intSide));
            }
            case PAR_ITEM: {
                String itemReg = object.get("item").getAsString();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemReg));
                int amount = object.has("amount") ? object.get("amount").getAsInt() : 1;
                ItemStack stack = new ItemStack((ItemLike)item, amount);
                if (object.has("nbt")) {
                    String nbt2 = object.get("nbt").getAsString();
                    CompoundTag tagCompound = null;
                    try {
                        tagCompound = TagParser.m_129359_((String)nbt2);
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                    stack.m_41751_(tagCompound);
                }
                return ParameterValue.constant((Object)stack);
            }
            case PAR_FLUID: {
                String fluidName = object.get("fluid").getAsString();
                int amount = object.get("amount").getAsInt();
                FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName)), amount);
                if (object.has("nbt")) {
                    String nbt = object.get("nbt").getAsString();
                    try {
                        fluidStack.setTag(TagParser.m_129359_((String)nbt));
                    }
                    catch (CommandSyntaxException nbt2) {
                        // empty catch block
                    }
                }
                return ParameterValue.constant((Object)fluidStack);
            }
            case PAR_EXCEPTION: {
                String code = object.get("code").getAsString();
                return ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(code)));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant((Object)new Tuple(object.get("x").getAsInt(), object.get("y").getAsInt()));
            }
            case PAR_VECTOR: {
                JsonArray array = object.get("vector").getAsJsonArray();
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (JsonElement element : array) {
                    JsonObject job = element.getAsJsonObject();
                    ParameterType t = ParameterType.getByName((String)job.get("type").getAsString());
                    vector.add(Parameter.builder().type(t).value(ParameterTypeTools.readFromJson(t, job)).build());
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return null;
    }
}

