/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolscontrol.modules.craftingstation.CraftingStationModule;
import mcjty.rftoolscontrol.modules.craftingstation.client.GuiCraftingStation;
import mcjty.rftoolscontrol.modules.craftingstation.util.CraftingRequest;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationTileEntity
extends GenericTileEntity {
    public static final int SLOT_OUTPUT = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(9).box(SlotDefinition.generic(), 0, 6, 157, 3, 3).playerSlots(66, 157));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.basic((GenericTileEntity)this, CONTAINER_FACTORY);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier(DefaultContainerProvider.container(CraftingStationModule.CRAFTING_STATION_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private final List<BlockPos> processorList = new ArrayList<BlockPos>();
    private int currentTicket = 0;
    private List<CraftingRequest> activeCraftingRequests = new ArrayList<CraftingRequest>();
    private int cleanupCounter = 50;
    public static final Key<String> PARAM_ITEMNAME = new Key("itemname", Type.STRING);
    public static final Key<String> PARAM_NBT = new Key("nbt", Type.STRING);
    public static final Key<Integer> PARAM_AMOUNT = new Key("amount", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_REQUEST = Command.create((String)"station.request", (te, player, params) -> {
        String nbtString;
        String itemName = (String)params.get(PARAM_ITEMNAME);
        int index = te.findItem(itemName, nbtString = (String)params.get(PARAM_NBT));
        if (index == -1) {
            return;
        }
        te.startCraft(index, (Integer)params.get(PARAM_AMOUNT));
    });
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_CANCEL = Command.create((String)"station.cancel", (te, player, params) -> te.cancelCraft((Integer)params.get(PARAM_INDEX)));
    @ServerCommand(type=ItemStack.class)
    public static final ListCommand<?, ?> CMD_GETCRAFTABLE = ListCommand.create((String)"rftoolscontrol.station.getCraftable", (te, player, params) -> te.getCraftableItems(), (te, player, params, list) -> GuiCraftingStation.storeCraftableForClient(list));
    @ServerCommand(type=CraftingRequest.class, serializer=CraftingRequest.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETREQUESTS = ListCommand.create((String)"rftoolscontrol.station.getRequests", (te, player, params) -> te.getRequests(), (te, player, params, list) -> GuiCraftingStation.storeRequestsForClient(list));

    public CraftingStationTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CraftingStationModule.TYPE_CRAFTING_STATION.get(), pos, state);
    }

    public void registerProcessor(BlockPos pos) {
        if (!this.processorList.contains(pos)) {
            this.processorList.add(pos);
        }
        this.m_6596_();
    }

    public ItemStack getCraftResult(String craftId) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!craftId.equals(request.getTicket())) continue;
            return request.getStack();
        }
        return ItemStack.f_41583_;
    }

    private Pair<ProcessorTileEntity, ItemStack> findCraftableItem(int index) {
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (index == 0) {
                    return Pair.of((Object)((Object)processor), (Object)item);
                }
                --index;
            }
        }
        return null;
    }

    public ItemStack craftOk(ProcessorTileEntity processor, String ticket, ItemStack stack) {
        CraftingRequest foundRequest = null;
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            foundRequest = request;
            break;
        }
        if (foundRequest != null) {
            this.m_6596_();
            foundRequest.decrTodo();
            if (foundRequest.getTodo() <= 0) {
                foundRequest.setOk(System.currentTimeMillis() + 1000L);
            } else {
                processor.fireCraftEvent(ticket, foundRequest.getStack());
            }
            if (!stack.m_41619_()) {
                Inventory inventory = this.getInventoryFromTicket(ticket);
                if (inventory != null) {
                    ItemStack finalStack = stack;
                    return (ItemStack)processor.getItemHandlerAt(inventory).map(handlerAt -> ItemHandlerHelper.insertItem((IItemHandler)handlerAt, (ItemStack)finalStack, (boolean)false)).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY));
                }
                stack = ItemHandlerHelper.insertItem((IItemHandler)this.items, (ItemStack)stack, (boolean)false);
            }
        }
        return stack;
    }

    public void craftFail(String ticket) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            request.setFailed(System.currentTimeMillis() + 2000L);
            this.m_6596_();
        }
    }

    private void cancelCraft(int index) {
        try {
            this.activeCraftingRequests.remove(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startCraft(int index, int amount) {
        Pair<ProcessorTileEntity, ItemStack> pair = this.findCraftableItem(index);
        if (pair == null) {
            System.out.println("What? Can't happen");
            return;
        }
        String ticket = this.getNewTicket(null);
        ItemStack stack = (ItemStack)pair.getValue();
        int count = (amount + stack.m_41613_() - 1) / stack.m_41613_();
        CraftingRequest request = new CraftingRequest(ticket, stack, count);
        if (!this.checkRequestAmount()) {
            return;
        }
        this.activeCraftingRequests.add(request);
        ((ProcessorTileEntity)((Object)pair.getKey())).fireCraftEvent(ticket, stack);
        --this.cleanupCounter;
        if (this.cleanupCounter <= 0) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
        }
    }

    private boolean checkRequestAmount() {
        if (this.activeCraftingRequests.size() >= (Integer)Config.maxCraftRequests.get()) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
            if (this.activeCraftingRequests.size() >= (Integer)Config.maxCraftRequests.get()) {
                return false;
            }
        }
        return true;
    }

    public boolean isRequested(Ingredient item) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L || ok != -1L || !item.test(request.getStack())) continue;
            return true;
        }
        return false;
    }

    public boolean request(@Nonnull Ingredient item, @Nullable Inventory destination) {
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack i : items) {
                if (!item.test(i)) continue;
                String ticket = this.getNewTicket(destination);
                if (!this.checkRequestAmount()) {
                    return false;
                }
                this.activeCraftingRequests.add(new CraftingRequest(ticket, i, 1));
                processor.fireCraftEvent(ticket, i);
                return true;
            }
        }
        return false;
    }

    private String getNewTicket(@Nullable Inventory destInv) {
        ++this.currentTicket;
        this.m_6596_();
        if (destInv != null) {
            return destInv.serialize() + "#" + this.currentTicket;
        }
        return BlockPosTools.toString((BlockPos)this.f_58858_) + ":" + this.currentTicket;
    }

    @Nullable
    private Inventory getInventoryFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return Inventory.deserialize((String)ticket);
        }
        return null;
    }

    @Nullable
    private BlockPos getPositionFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return null;
        }
        String[] splitted = StringUtils.split((String)ticket, (char)';');
        String[] poss = StringUtils.split((String)splitted[0], (char)',');
        return new BlockPos(Integer.parseInt(poss[0]), Integer.parseInt(poss[1]), Integer.parseInt(poss[2]));
    }

    public ItemStackList getCraftableItems() {
        ItemStackList items = ItemStackList.create();
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.getCraftableItems((List<ItemStack>)items);
        }
        return items;
    }

    private void cleanupStaleRequests() {
        long time = System.currentTimeMillis();
        List<CraftingRequest> oldRequests = this.activeCraftingRequests;
        this.activeCraftingRequests = new ArrayList<CraftingRequest>();
        for (CraftingRequest request : oldRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L && time > failed || ok != -1L && time > ok) continue;
            this.activeCraftingRequests.add(request);
        }
    }

    public List<CraftingRequest> getRequests() {
        this.cleanupStaleRequests();
        return new ArrayList<CraftingRequest>(this.activeCraftingRequests);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.readProcessorList(tagCompound);
        this.readRequests(tagCompound);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.currentTicket = info.m_128451_("craftId");
    }

    private void readRequests(CompoundTag tagCompound) {
        ListTag list = tagCompound.m_128437_("requests", 10);
        this.activeCraftingRequests.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag requestTag = list.m_128728_(i);
            String craftId = requestTag.m_128461_("craftId");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)requestTag.m_128469_("stack"));
            int count = requestTag.m_128451_("count");
            CraftingRequest request = new CraftingRequest(craftId, stack, count);
            request.setFailed(requestTag.m_128454_("failed"));
            request.setOk(requestTag.m_128454_("ok"));
            this.activeCraftingRequests.add(request);
        }
    }

    private void readProcessorList(CompoundTag tagCompound) {
        ListTag list = tagCompound.m_128437_("processors", 10);
        this.processorList.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            this.processorList.add(new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")));
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        this.writeProcessorList(tagCompound);
        this.writeRequests(tagCompound);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("craftId", this.currentTicket);
    }

    private void writeRequests(CompoundTag tagCompound) {
        ListTag list = new ListTag();
        for (CraftingRequest request : this.activeCraftingRequests) {
            CompoundTag requestTag = new CompoundTag();
            requestTag.m_128359_("craftId", request.getTicket());
            CompoundTag stackNbt = new CompoundTag();
            request.getStack().m_41739_(stackNbt);
            requestTag.m_128365_("stack", (Tag)stackNbt);
            requestTag.m_128405_("count", request.getTodo());
            requestTag.m_128356_("failed", request.getFailed());
            requestTag.m_128356_("ok", request.getOk());
            list.add((Object)requestTag);
        }
        tagCompound.m_128365_("requests", (Tag)list);
    }

    private void writeProcessorList(CompoundTag tagCompound) {
        ListTag list = new ListTag();
        for (BlockPos p : this.processorList) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", p.m_123341_());
            tag.m_128405_("y", p.m_123342_());
            tag.m_128405_("z", p.m_123343_());
            list.add((Object)tag);
        }
        tagCompound.m_128365_("processors", (Tag)list);
    }

    private int findItem(String itemName, String nbtString) {
        int index = 0;
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (itemName.equals(Tools.getId((ItemStack)item).toString())) {
                    if (item.m_41782_()) {
                        if (nbtString.equalsIgnoreCase(item.serializeNBT().toString())) {
                            return index;
                        }
                    } else {
                        return index;
                    }
                }
                ++index;
            }
        }
        return -1;
    }
}

