/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.codecs.predicates.NbtPredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record RestrictedBlockPredicate(@NotNull Block block, @NotNull NbtPredicate nbt, @NotNull LocationPredicate location, @NotNull StatePropertiesPredicate properties) {
    public static final Codec<RestrictedBlockPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("id").forGetter(RestrictedBlockPredicate::block), (App)NbtPredicate.CODEC.fieldOf("nbt").orElse((Object)NbtPredicate.ANY).forGetter(RestrictedBlockPredicate::nbt), (App)CodecExtras.passthrough(LocationPredicate::m_52616_, LocationPredicate::m_52629_).fieldOf("location").orElse((Object)LocationPredicate.f_52592_).forGetter(RestrictedBlockPredicate::location), (App)CodecExtras.passthrough(StatePropertiesPredicate::m_67666_, StatePropertiesPredicate::m_67679_).fieldOf("properties").orElse((Object)StatePropertiesPredicate.f_67658_).forGetter(RestrictedBlockPredicate::properties)).apply((Applicative)instance, RestrictedBlockPredicate::new));

    public Optional<CompoundTag> getTag() {
        return Optional.ofNullable(this.nbt().tag());
    }

    public boolean matches(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(this.block)) {
            return false;
        }
        if (!this.properties.m_67667_(state)) {
            return false;
        }
        if (!this.location.m_52617_(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) {
            return false;
        }
        if (this.nbt != NbtPredicate.ANY) {
            BlockEntity blockEntity = level.m_7702_(pos);
            return blockEntity != null && this.nbt.matches((Tag)blockEntity.m_187480_());
        }
        return true;
    }
}

