/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;

public class MobHelper {
    private static final Set<MemoryModuleType<?>> TARGET_MEMORIES = ImmutableSet.of((Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26334_, (Object)MemoryModuleType.f_26335_, (Object)MemoryModuleType.f_26345_, (Object)MemoryModuleType.f_148206_);

    private MobHelper() {
    }

    public static void resetTarget(Mob entity) {
        MobHelper.resetTarget(entity, false);
    }

    public static void resetTarget(Mob entity, boolean resetRevengeTarget) {
        Brain brain = entity.m_6274_();
        for (MemoryModuleType<?> memory : TARGET_MEMORIES) {
            if (!brain.m_21874_(memory)) continue;
            MobHelper.emptyMemory(brain, memory);
        }
        entity.m_6710_(null);
        if (resetRevengeTarget) {
            entity.m_6703_(null);
        }
    }

    private static <T> void emptyMemory(Brain<?> brain, MemoryModuleType<T> memory) {
        brain.m_21886_(memory, Optional.empty());
    }

    public static Optional<Player> getTargetedPlayerFromMemory(Mob entity) {
        Brain brain = entity.m_6274_();
        for (MemoryModuleType<?> memory : TARGET_MEMORIES) {
            Optional value;
            if (!brain.m_21874_(memory) || !(value = brain.m_21952_(memory)).isPresent() || !(value.get() instanceof Player)) continue;
            return Optional.of((Player)value.get());
        }
        return Optional.empty();
    }
}

