/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class BlazeShotEntity
extends ShotEntityBase {
    public BlazeShotEntity(EntityType<BlazeShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public BlazeShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.BLAZE_SHOT.get(), world, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0 && this.ticksInAir < 9) {
            Vec3 motion = this.m_20184_();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.lowGauss(motion.m_7096_()), this.lowGauss(motion.m_7098_()), this.lowGauss(motion.m_7094_()));
        }
    }

    @Override
    void doFiringEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    protected DamageSource getDamageSource() {
        return super.getDamageSource().m_19383_();
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entityHit = ((EntityHitResult)result).m_82443_();
            if (entityHit == this.m_37282_() || !(entityHit instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entityHit);
        } else if (result.m_6662_() == HitResult.Type.BLOCK) {
            if (!(this.m_37282_() instanceof Player)) {
                return;
            }
            BlockHitResult blockResult = (BlockHitResult)result;
            this.groundImpact(blockResult.m_82434_());
            BlockPos fireSpawnPos = blockResult.m_82425_().m_121945_(blockResult.m_82434_());
            if (this.f_19853_.m_46859_(fireSpawnPos)) {
                this.f_19853_.m_46597_(fireSpawnPos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)fireSpawnPos));
            }
        }
    }

    @Override
    protected void onImpact(LivingEntity entityLiving) {
        entityLiving.m_20254_(40);
        super.onImpact(entityLiving);
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
        }
    }

    @Override
    protected void groundImpact(Direction sideHit) {
        this.m_146870_();
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return mop.m_5825_() ? 2 : 10 + this.d12();
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        Vec3 motion = this.m_20184_();
        double motionX = motion.m_7096_();
        double motionY = motion.m_7098_();
        double motionZ = motion.m_7094_();
        block8: for (int particles = 0; particles < 40; ++particles) {
            switch (sideHit) {
                case DOWN: {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.smallGauss(0.1) + motionX / 4.0, -this.posGauss(0.2), this.smallGauss(0.2) + motionZ / 4.0);
                    continue block8;
                }
                case UP: {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.smallGauss(0.1) + motionX / 4.0, this.posGauss(0.2), this.smallGauss(0.2) + motionZ / 4.0);
                    continue block8;
                }
                case NORTH: {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.smallGauss(0.1) + motionX / 4.0, this.smallGauss(0.1) + motionY / 4.0, -this.posGauss(0.2));
                    continue block8;
                }
                case SOUTH: {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.smallGauss(0.1) + motionX / 4.0, this.smallGauss(0.1) + motionY / 4.0, this.posGauss(0.2));
                    continue block8;
                }
                case WEST: {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), -this.posGauss(0.2), this.smallGauss(0.1) + motionY / 4.0, this.smallGauss(0.1) + motionZ / 4.0);
                    continue block8;
                }
                case EAST: {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.posGauss(0.2), this.smallGauss(0.1) + motionY / 4.0, this.smallGauss(0.1) + motionZ / 4.0);
                    continue block8;
                }
            }
        }
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.BLAZE;
    }
}

