/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorageaddons.item;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.blockentity.grid.WirelessGrid;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorageaddons.RSAddons;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class WirelessCraftingGrid
extends WirelessGrid {
    @Nullable
    private final MinecraftServer server;
    private final Level level;
    private Set<ICraftingGridListener> listeners = new HashSet<ICraftingGridListener>();
    private boolean queuedSave;
    private AbstractContainerMenu craftingMenu = new AbstractContainerMenu(null, 0){

        public boolean m_6875_(Player player) {
            return false;
        }

        public ItemStack m_7648_(Player p_38941_, int p_38942_) {
            return ItemStack.f_41583_;
        }

        public void m_6199_(Container container) {
            if (WirelessCraftingGrid.this.server != null) {
                WirelessCraftingGrid.this.onCraftingMatrixChanged();
            }
        }
    };
    private CraftingRecipe currentRecipe;
    private CraftingContainer craftingContainer = new CraftingContainer(this.craftingMenu, 3, 3){

        public void m_6596_() {
            super.m_6596_();
            if (!WirelessCraftingGrid.this.queuedSave && WirelessCraftingGrid.this.server != null) {
                WirelessCraftingGrid.this.queuedSave = true;
                WirelessCraftingGrid.this.server.m_6367_(new TickTask(0, () -> {
                    if (!WirelessCraftingGrid.this.getStack().m_41782_()) {
                        WirelessCraftingGrid.this.getStack().m_41751_(new CompoundTag());
                    }
                    StackUtils.writeItems((Container)WirelessCraftingGrid.this.craftingContainer, (int)1, (CompoundTag)WirelessCraftingGrid.this.getStack().m_41783_());
                    WirelessCraftingGrid.this.queuedSave = false;
                }));
            }
        }
    };
    private ResultContainer craftingResultContainer = new ResultContainer();

    public WirelessCraftingGrid(ItemStack stack, Level level, @Nullable MinecraftServer server, PlayerSlot slot) {
        super(stack, server, slot);
        this.server = server;
        this.level = level;
        if (stack.m_41782_()) {
            StackUtils.readItems((Container)this.craftingContainer, (int)1, (CompoundTag)stack.m_41783_());
        }
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.refinedstorage.crafting_grid");
    }

    public GridType getGridType() {
        return GridType.CRAFTING;
    }

    public CraftingContainer getCraftingMatrix() {
        return this.craftingContainer;
    }

    public ResultContainer getCraftingResult() {
        return this.craftingResultContainer;
    }

    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)this.craftingContainer, this.level)) {
            this.currentRecipe = this.level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftingContainer, this.level).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.craftingResultContainer.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.craftingResultContainer.m_6836_(0, this.currentRecipe.m_5874_((Container)this.craftingContainer));
        }
        this.listeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.getStack().m_41782_()) {
            this.getStack().m_41751_(new CompoundTag());
        }
        StackUtils.writeItems((Container)this.craftingContainer, (int)1, (CompoundTag)this.getStack().m_41783_());
    }

    public void onCrafted(Player player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        RSAddons.RSAPI.getCraftingGridBehavior().onCrafted((INetworkAwareGrid)this, this.currentRecipe, player, availableItems, usedItems);
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().drainEnergy(player, RSAddons.SERVER_CONFIG.getWirelessCraftingGrid().getCraftUsage());
        }
    }

    public void onClear(Player player) {
        INetwork network = this.getNetwork();
        if (network != null && network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            for (int i = 0; i < this.craftingContainer.m_6643_(); ++i) {
                ItemStack slot = this.craftingContainer.m_8020_(i);
                if (slot.m_41619_()) continue;
                this.craftingContainer.m_6836_(i, network.insertItem(slot, slot.m_41613_(), Action.PERFORM));
                network.getItemStorageTracker().changed(player, (Object)slot.m_41777_());
            }
            network.getNetworkItemManager().drainEnergy(player, RSAddons.SERVER_CONFIG.getWirelessCraftingGrid().getClearUsage());
        }
    }

    public void onCraftedShift(Player player) {
        RSAddons.RSAPI.getCraftingGridBehavior().onCraftedShift((INetworkAwareGrid)this, player);
    }

    public void onRecipeTransfer(Player player, ItemStack[][] recipe) {
        RSAddons.RSAPI.getCraftingGridBehavior().onRecipeTransfer((INetworkAwareGrid)this, player, recipe);
    }

    public void addCraftingListener(ICraftingGridListener listener) {
        this.listeners.add(listener);
    }

    public void removeCraftingListener(ICraftingGridListener listener) {
        this.listeners.remove(listener);
    }
}

