/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class CubeBuilder {
    private Vector3f from;
    private Vector3f to;
    private final Map<Direction, Face> faces = new HashMap<Direction, Face>();
    private int color = -1;

    public CubeBuilder from(float x, float y, float z) {
        this.from = new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f);
        return this;
    }

    public CubeBuilder to(float x, float y, float z) {
        this.to = new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f);
        return this;
    }

    public CubeBuilder color(int color) {
        this.color = color;
        return this;
    }

    public CubeBuilder addFaces(Function<Direction, Face> faceSupplier) {
        for (Direction facing : Direction.values()) {
            this.addFace(faceSupplier.apply(facing));
        }
        return this;
    }

    public CubeBuilder addFace(Face face) {
        this.faces.put(face.face, face);
        return this;
    }

    public List<BakedQuad> bake() {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry<Direction, Face> entry : this.faces.entrySet()) {
            quads.add(this.bakeFace(entry.getKey(), entry.getValue()));
        }
        return quads;
    }

    private BakedQuad bakeFace(Direction facing, Face cubeFace) {
        ArrayList quad = new ArrayList();
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(quad::add);
        builder.setSprite(cubeFace.sprite);
        builder.setDirection(facing);
        builder.setTintIndex(-1);
        builder.setShade(true);
        Uv uv = this.getDefaultUv(facing, cubeFace.sprite, this.from.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), this.to.m_122239_(), this.to.m_122260_(), this.to.m_122269_());
        switch (facing) {
            case DOWN: {
                this.addVertexTopRight(builder, cubeFace, this.to.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.m_122239_(), this.from.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.m_122239_(), this.from.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), uv);
                break;
            }
            case UP: {
                this.addVertexTopLeft(builder, cubeFace, this.from.m_122239_(), this.to.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.m_122239_(), this.to.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.m_122239_(), this.to.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.m_122239_(), this.to.m_122260_(), this.from.m_122269_(), uv);
                break;
            }
            case NORTH: {
                this.addVertexBottomRight(builder, cubeFace, this.to.m_122239_(), this.to.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.m_122239_(), this.to.m_122260_(), this.from.m_122269_(), uv);
                break;
            }
            case SOUTH: {
                this.addVertexBottomLeft(builder, cubeFace, this.from.m_122239_(), this.to.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.m_122239_(), this.from.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.m_122239_(), this.from.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.m_122239_(), this.to.m_122260_(), this.to.m_122269_(), uv);
                break;
            }
            case WEST: {
                this.addVertexTopLeft(builder, cubeFace, this.from.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexTopRight(builder, cubeFace, this.from.m_122239_(), this.from.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.from.m_122239_(), this.to.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.m_122239_(), this.to.m_122260_(), this.from.m_122269_(), uv);
                break;
            }
            case EAST: {
                this.addVertexBottomRight(builder, cubeFace, this.to.m_122239_(), this.to.m_122260_(), this.from.m_122269_(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.to.m_122239_(), this.to.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.to.m_122239_(), this.from.m_122260_(), this.to.m_122269_(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.m_122239_(), this.from.m_122260_(), this.from.m_122269_(), uv);
            }
        }
        return (BakedQuad)quad.get(0);
    }

    private Uv getDefaultUv(Direction face, TextureAtlasSprite texture, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        Uv uv = new Uv();
        switch (face) {
            case DOWN: {
                uv.xFrom = texture.m_118367_((double)(fromX * 16.0f));
                uv.yFrom = texture.m_118393_((double)(16.0f - fromZ * 16.0f));
                uv.xTo = texture.m_118367_((double)(toX * 16.0f));
                uv.yTo = texture.m_118393_((double)(16.0f - toZ * 16.0f));
                break;
            }
            case UP: {
                uv.xFrom = texture.m_118367_((double)(fromX * 16.0f));
                uv.yFrom = texture.m_118393_((double)(fromZ * 16.0f));
                uv.xTo = texture.m_118367_((double)(toX * 16.0f));
                uv.yTo = texture.m_118393_((double)(toZ * 16.0f));
                break;
            }
            case NORTH: {
                uv.xFrom = texture.m_118367_((double)(16.0f - fromX * 16.0f));
                uv.yFrom = texture.m_118393_((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.m_118367_((double)(16.0f - toX * 16.0f));
                uv.yTo = texture.m_118393_((double)(16.0f - toY * 16.0f));
                break;
            }
            case SOUTH: {
                uv.xFrom = texture.m_118367_((double)(fromX * 16.0f));
                uv.yFrom = texture.m_118393_((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.m_118367_((double)(toX * 16.0f));
                uv.yTo = texture.m_118393_((double)(16.0f - toY * 16.0f));
                break;
            }
            case WEST: {
                uv.xFrom = texture.m_118367_((double)(fromZ * 16.0f));
                uv.yFrom = texture.m_118393_((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.m_118367_((double)(toZ * 16.0f));
                uv.yTo = texture.m_118393_((double)(16.0f - toY * 16.0f));
                break;
            }
            case EAST: {
                uv.xFrom = texture.m_118367_((double)(16.0f - toZ * 16.0f));
                uv.yFrom = texture.m_118393_((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.m_118367_((double)(16.0f - fromZ * 16.0f));
                uv.yTo = texture.m_118393_((double)(16.0f - toY * 16.0f));
            }
        }
        return uv;
    }

    private void addVertexTopLeft(QuadBakingVertexConsumer builder, Face face, float x, float y, float z, Uv uv) {
        float u;
        this.addVertex(builder, face, x, y, z, u, switch (face.uvRotation) {
            default -> {
                u = uv.xFrom;
                yield uv.yFrom;
            }
            case UvRotation.CLOCKWISE_90 -> {
                u = uv.xFrom;
                yield uv.yTo;
            }
            case UvRotation.CLOCKWISE_180 -> {
                u = uv.xTo;
                yield uv.yTo;
            }
            case UvRotation.CLOCKWISE_270 -> {
                u = uv.xTo;
                yield uv.yFrom;
            }
        });
    }

    private void addVertexTopRight(QuadBakingVertexConsumer builder, Face face, float x, float y, float z, Uv uv) {
        float u;
        this.addVertex(builder, face, x, y, z, u, switch (face.uvRotation) {
            default -> {
                u = uv.xTo;
                yield uv.yFrom;
            }
            case UvRotation.CLOCKWISE_90 -> {
                u = uv.xFrom;
                yield uv.yFrom;
            }
            case UvRotation.CLOCKWISE_180 -> {
                u = uv.xFrom;
                yield uv.yTo;
            }
            case UvRotation.CLOCKWISE_270 -> {
                u = uv.xTo;
                yield uv.yTo;
            }
        });
    }

    private void addVertexBottomRight(QuadBakingVertexConsumer builder, Face face, float x, float y, float z, Uv uv) {
        float u;
        this.addVertex(builder, face, x, y, z, u, switch (face.uvRotation) {
            default -> {
                u = uv.xTo;
                yield uv.yTo;
            }
            case UvRotation.CLOCKWISE_90 -> {
                u = uv.xTo;
                yield uv.yFrom;
            }
            case UvRotation.CLOCKWISE_180 -> {
                u = uv.xFrom;
                yield uv.yFrom;
            }
            case UvRotation.CLOCKWISE_270 -> {
                u = uv.xFrom;
                yield uv.yTo;
            }
        });
    }

    private void addVertexBottomLeft(QuadBakingVertexConsumer builder, Face face, float x, float y, float z, Uv uv) {
        float u;
        this.addVertex(builder, face, x, y, z, u, switch (face.uvRotation) {
            default -> {
                u = uv.xFrom;
                yield uv.yTo;
            }
            case UvRotation.CLOCKWISE_90 -> {
                u = uv.xTo;
                yield uv.yTo;
            }
            case UvRotation.CLOCKWISE_180 -> {
                u = uv.xTo;
                yield uv.yFrom;
            }
            case UvRotation.CLOCKWISE_270 -> {
                u = uv.xFrom;
                yield uv.yFrom;
            }
        });
    }

    private void addVertex(QuadBakingVertexConsumer builder, Face face, float x, float y, float z, float u, float v) {
        builder.m_5483_((double)x, (double)y, (double)z);
        builder.m_5601_((float)face.face.m_122429_(), (float)face.face.m_122430_(), (float)face.face.m_122431_());
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
        builder.m_7421_(u, v);
        builder.m_85950_(r, g, b, a);
        builder.m_5752_();
    }

    public static class Face {
        private final Direction face;
        private final TextureAtlasSprite sprite;
        private final UvRotation uvRotation = UvRotation.CLOCKWISE_0;

        public Face(Direction face, TextureAtlasSprite sprite) {
            this.face = face;
            this.sprite = sprite;
        }
    }

    private static class Uv {
        private float xFrom;
        private float xTo;
        private float yFrom;
        private float yTo;

        private Uv() {
        }
    }

    public static enum UvRotation {
        CLOCKWISE_0,
        CLOCKWISE_90,
        CLOCKWISE_180,
        CLOCKWISE_270;

    }
}

