/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.packet;

import com.refinedmods.refinedstorage.integration.curios.CuriosIntegration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Supplier;
import net.gigabit101.rebornstorage.init.ModItems;
import net.gigabit101.rebornstorage.items.ItemWirelessGrid;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class PacketChangeMode {
    public static void encode(PacketChangeMode packetGui, FriendlyByteBuf buf) {
    }

    public static PacketChangeMode decode(FriendlyByteBuf buf) {
        return new PacketChangeMode();
    }

    public static void updateStack(ItemStack stack, Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof ItemWirelessGrid) {
            ItemWirelessGrid itemWirelessGrid = (ItemWirelessGrid)item;
            ItemWirelessGrid.MODE current = itemWirelessGrid.getMode(stack);
            switch (current) {
                case CRAFTING: {
                    itemWirelessGrid.setMode(stack, ItemWirelessGrid.MODE.FLUID);
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + ItemWirelessGrid.MODE.FLUID.name())), false);
                    break;
                }
                case FLUID: {
                    itemWirelessGrid.setMode(stack, ItemWirelessGrid.MODE.MONITOR);
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + ItemWirelessGrid.MODE.MONITOR.name())), false);
                    break;
                }
                case MONITOR: {
                    itemWirelessGrid.setMode(stack, ItemWirelessGrid.MODE.CRAFTING);
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + ItemWirelessGrid.MODE.CRAFTING.name())), false);
                }
            }
        }
    }

    public static class Handler {
        public static void handle(PacketChangeMode message, Supplier<NetworkEvent.Context> ctx) {
            HashSet<Item> validItems = new HashSet<Item>(Arrays.asList((Item)ModItems.WIRELESS_GRID.get(), (Item)ModItems.CREATIVE_WIRELESS_GRID.get()));
            ctx.get().enqueueWork(() -> {
                Optional curio;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                Inventory inv = player.m_150109_();
                int slotFound = -1;
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    ItemStack slot = inv.m_8020_(i);
                    if (!validItems.contains(slot.m_41720_())) continue;
                    if (slotFound != -1) {
                        return;
                    }
                    slotFound = i;
                }
                if (CuriosIntegration.isLoaded() && slotFound == -1 && (curio = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> validItems.contains(stack.m_41720_()), (LivingEntity)player)).isPresent()) {
                    PacketChangeMode.updateStack((ItemStack)((ImmutableTriple)curio.get()).getRight(), (Player)player);
                    return;
                }
                if (slotFound != -1) {
                    PacketChangeMode.updateStack(player.m_150109_().m_8020_(slotFound), (Player)player);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

