/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.core.multiblock.rectangular;

import net.gigabit101.rebornstorage.core.multiblock.MultiblockBlockEntityBase;
import net.gigabit101.rebornstorage.core.multiblock.MultiblockControllerBase;
import net.gigabit101.rebornstorage.core.multiblock.MultiblockValidationException;
import net.gigabit101.rebornstorage.core.multiblock.rectangular.PartPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockBlockEntityBase {
    PartPosition position = PartPosition.Unknown;
    Direction outwards = null;

    public RectangularMultiblockTileEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public Direction getOutwardsDir() {
        return this.outwards;
    }

    public PartPosition getPartPosition() {
        return this.position;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        BlockPos maxCoord = controller.getMaximumCoord();
        BlockPos minCoord = controller.getMinimumCoord();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwards = null;
    }

    public void recalculateOutwardsDirection(BlockPos minCoord, BlockPos maxCoord) {
        this.outwards = null;
        this.position = PartPosition.Unknown;
        int facesMatching = 0;
        if (maxCoord.m_123341_() == this.m_58899_().m_123341_() || minCoord.m_123341_() == this.m_58899_().m_123341_()) {
            ++facesMatching;
        }
        if (maxCoord.m_123342_() == this.m_58899_().m_123342_() || minCoord.m_123342_() == this.m_58899_().m_123342_()) {
            ++facesMatching;
        }
        if (maxCoord.m_123343_() == this.m_58899_().m_123343_() || minCoord.m_123343_() == this.m_58899_().m_123343_()) {
            ++facesMatching;
        }
        if (facesMatching <= 0) {
            this.position = PartPosition.Interior;
        } else if (facesMatching >= 3) {
            this.position = PartPosition.FrameCorner;
        } else if (facesMatching == 2) {
            this.position = PartPosition.Frame;
        } else if (maxCoord.m_123341_() == this.m_58899_().m_123341_()) {
            this.position = PartPosition.EastFace;
            this.outwards = Direction.EAST;
        } else if (minCoord.m_123341_() == this.m_58899_().m_123341_()) {
            this.position = PartPosition.WestFace;
            this.outwards = Direction.WEST;
        } else if (maxCoord.m_123343_() == this.m_58899_().m_123343_()) {
            this.position = PartPosition.SouthFace;
            this.outwards = Direction.SOUTH;
        } else if (minCoord.m_123343_() == this.m_58899_().m_123343_()) {
            this.position = PartPosition.NorthFace;
            this.outwards = Direction.NORTH;
        } else if (maxCoord.m_123342_() == this.m_58899_().m_123342_()) {
            this.position = PartPosition.TopFace;
            this.outwards = Direction.UP;
        } else {
            this.position = PartPosition.BottomFace;
            this.outwards = Direction.DOWN;
        }
    }

    public abstract void isGoodForFrame() throws MultiblockValidationException;

    public abstract void isGoodForSides() throws MultiblockValidationException;

    public abstract void isGoodForTop() throws MultiblockValidationException;

    public abstract void isGoodForBottom() throws MultiblockValidationException;

    public abstract void isGoodForInterior() throws MultiblockValidationException;
}

