/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.mixinhelpers;

import java.util.EnumSet;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.roguelogix.quartz.QuartzConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OpenGLSelector {
    private static final Logger LOGGER = LogManager.getLogger((String)"Quartz/OpenGLSelector");

    public static LongSupplier fallback(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
        return () -> OpenGLSelector.createWindow(width.getAsInt(), height.getAsInt(), (String)title.get(), monitor.getAsLong(), 0L);
    }

    private static long createWindow(int width, int height, String title, long monitor, long share) {
        if (!QuartzConfig.INIT_COMPLETED) {
            return GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
        }
        LOGGER.error("Quartz OpenGL version search enabled, this may potentially cause issues with some graphics cards, please report issues");
        GLFWErrorCallback errorCallback = GLFW.glfwSetErrorCallback(null);
        int allowedVersions = Integer.parseInt(System.getProperty("quartz.glversions", "0000"));
        long window = 0L;
        LOGGER.info("Searching for latest OpenGL version");
        for (GLVersion value : GLVersion.allowedFromVersionInt(allowedVersions)) {
            LOGGER.info(String.format("Attempting version %d.%d ", value.major, value.minor));
            GLFW.glfwWindowHint((int)139266, (int)value.major);
            GLFW.glfwWindowHint((int)139267, (int)value.minor);
            window = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
            if (window != 0L) {
                LOGGER.info("SUCCESS");
                long previousContext = GLFW.glfwGetCurrentContext();
                GLFW.glfwMakeContextCurrent((long)window);
                GL.createCapabilities();
                LOGGER.info(String.format("Reported OpenGL version %d.%d", GL32C.glGetInteger((int)33307), GL32C.glGetInteger((int)33308)));
                GLFW.glfwMakeContextCurrent((long)previousContext);
                break;
            }
            LOGGER.info("FAILED");
        }
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallback);
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            long stringAddr;
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            int GLFWError = GLFW.glfwGetError((PointerBuffer)pointerBuffer);
            if ((long)GLFWError != 0L && (window == 0L || GLFWError != 65543) && (stringAddr = pointerBuffer.get(0)) != 0L) {
                if (errorCallback != null) {
                    errorCallback.invoke(GLFWError, stringAddr);
                } else {
                    LOGGER.error("GLFW error: " + GLFWError + ": " + MemoryUtil.memUTF8((long)stringAddr));
                }
            }
        }
        return window;
    }

    private static enum GLVersion {
        GL46(4, 6),
        GL45(4, 5),
        GL44(4, 4),
        GL43(4, 3),
        GL42(4, 2),
        GL41(4, 1),
        GL40(4, 0),
        GL33(3, 3),
        ANY(0, 0);

        final int major;
        final int minor;

        private GLVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        static GLVersion fromInt(int version) {
            return switch (version) {
                case 46 -> GL46;
                case 45 -> GL45;
                case 44 -> GL44;
                case 43 -> GL43;
                case 42 -> GL42;
                case 41 -> GL41;
                case 40 -> GL40;
                case 33 -> GL33;
                default -> ANY;
            };
        }

        static Iterable<GLVersion> allowedFromVersionInt(int versionInt) {
            GLVersion lowerBound = GLVersion.fromInt(versionInt / 100 % 100);
            GLVersion upperBound = GLVersion.fromInt(versionInt % 100);
            if (upperBound == ANY) {
                return EnumSet.range(GL46, GL33);
            }
            if (lowerBound == ANY) {
                return EnumSet.of(upperBound);
            }
            return EnumSet.range(upperBound, lowerBound);
        }
    }
}

