/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModItems;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModList;

public class FarmerBee
extends ProductiveBee {
    public static final UUID FARMER_BEE_UUID = UUID.nameUUIDFromBytes("pb_farmer_bee".getBytes(StandardCharsets.UTF_8));
    private BlockPos targetHarvestPos = null;
    private LocateCropGoal locateCropGoal;

    public FarmerBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_21345_.m_25352_(4, (Goal)new HarvestCropGoal());
        this.locateCropGoal = new LocateCropGoal();
        this.f_21345_.m_25352_(6, (Goal)this.locateCropGoal);
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        return source.equals(DamageSource.f_19314_) || super.m_6673_(source);
    }

    public List<BlockPos> findHarvestablesNearby(BlockPos pos, double distance) {
        List<BlockPos> list = BlockPos.m_121990_((BlockPos)pos.m_7637_(-distance, -distance + 2.0, -distance), (BlockPos)pos.m_7637_(distance, distance - 2.0, distance)).map(BlockPos::m_7949_).collect(Collectors.toList());
        list.removeIf(blockPos -> !this.isCropValid((BlockPos)blockPos));
        return list;
    }

    private boolean isCropValid(BlockPos blockPos) {
        if (blockPos == null) {
            return false;
        }
        BlockState state = this.f_19853_.m_8055_(blockPos);
        Block block = state.m_60734_();
        if (block instanceof CocoaBlock && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) == 2) {
            return true;
        }
        if (block instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) == 3) {
            return true;
        }
        if (block instanceof StemGrownBlock) {
            return true;
        }
        if (block instanceof CactusBlock || block instanceof SugarCaneBlock) {
            return this.f_19853_.m_8055_(blockPos.m_7495_()).m_60734_().equals(state.m_60734_());
        }
        return block instanceof CropBlock && !((CropBlock)block).m_7370_((BlockGetter)this.f_19853_, blockPos, state, false);
    }

    public class HarvestCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            if (FarmerBee.this.targetHarvestPos != null && !this.positionIsHarvestable(FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.m_21660_() && !FarmerBee.this.m_27816_(FarmerBee.this.targetHarvestPos, 2);
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8037_() {
            if (FarmerBee.this.targetHarvestPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    FarmerBee.this.locateCropGoal.cooldown = 120;
                    FarmerBee.this.targetHarvestPos = null;
                } else if (!FarmerBee.this.f_21344_.m_26571_()) {
                    BlockPos blockPos = FarmerBee.this.targetHarvestPos;
                    FarmerBee.this.f_21344_.m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
                }
            }
        }

        private boolean positionIsHarvestable(BlockPos pos) {
            return !FarmerBee.this.findHarvestablesNearby(pos, 0.0).isEmpty();
        }
    }

    public class LocateCropGoal
    extends Goal {
        private int ticks = 0;
        private int cooldown = 0;

        public boolean m_8036_() {
            if (--this.cooldown <= 0 && !FarmerBee.this.m_21660_()) {
                FarmerBee.this.targetHarvestPos = this.findNearestHarvestableTarget();
                if (FarmerBee.this.targetHarvestPos == null) {
                    this.cooldown = 70;
                }
            }
            return FarmerBee.this.targetHarvestPos != null;
        }

        public boolean m_8045_() {
            if (FarmerBee.this.f_19797_ % 20 == 0 && !FarmerBee.this.isCropValid(FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.m_21660_();
        }

        private BlockPos findNearestHarvestableTarget() {
            AdvancedBeehiveBlockEntity beehiveBlockEntity;
            int radius;
            List<BlockPos> harvestablesNearby;
            BlockEntity hive;
            if (FarmerBee.this.f_27698_ != null && (hive = FarmerBee.this.f_19853_.m_7702_(FarmerBee.this.f_27698_)) instanceof AdvancedBeehiveBlockEntity && !(harvestablesNearby = FarmerBee.this.findHarvestablesNearby(FarmerBee.this.f_27698_, radius = 5 + (beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hive).getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get()))).isEmpty()) {
                BlockPos nearest = null;
                double nearestDistance = 0.0;
                for (BlockPos pos : harvestablesNearby) {
                    double distance = pos.m_123331_((Vec3i)FarmerBee.this.m_20183_());
                    if (nearestDistance != 0.0 && !(distance <= nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = pos;
                }
                return nearest;
            }
            return null;
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8037_() {
            ++this.ticks;
            if (FarmerBee.this.targetHarvestPos != null) {
                if (this.ticks > 600) {
                    FarmerBee.this.targetHarvestPos = null;
                } else {
                    Vec3 vec3d = Vec3.m_82512_((Vec3i)FarmerBee.this.targetHarvestPos).m_82520_(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.m_82554_(FarmerBee.this.m_20182_());
                    if (distanceToTarget > 1.5) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        FarmerBee.this.locateCropGoal.cooldown = 120;
                        FarmerBee.this.targetHarvestPos = null;
                    } else {
                        BlockPos pos = FarmerBee.this.targetHarvestPos;
                        if (FarmerBee.this.isCropValid(pos)) {
                            BlockState cropBlockState = FarmerBee.this.f_19853_.m_8055_(pos);
                            Block cropBlock = cropBlockState.m_60734_();
                            if (cropBlock instanceof AttachedStemBlock) {
                                BlockState fruitBlock = FarmerBee.this.f_19853_.m_8055_(pos.m_121945_((Direction)cropBlockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
                                if (fruitBlock.m_60734_() instanceof StemGrownBlock) {
                                    FarmerBee.this.f_19853_.m_46961_(pos.m_121945_((Direction)cropBlockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), true);
                                }
                            } else if (cropBlock instanceof SugarCaneBlock || cropBlock instanceof CactusBlock) {
                                int i = 0;
                                while (i++ < 5 && FarmerBee.this.f_19853_.m_8055_(pos.m_7495_()).m_60734_().equals(cropBlock)) {
                                    pos = pos.m_7495_();
                                }
                                FarmerBee.this.f_19853_.m_46961_(pos.m_7494_(), true);
                            } else if (cropBlock instanceof SweetBerryBushBlock) {
                                int i = (Integer)cropBlockState.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                                if (i > 1) {
                                    int j = 1 + FarmerBee.this.f_19853_.f_46441_.m_188503_(2);
                                    Block.m_49840_((Level)FarmerBee.this.f_19853_, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j + (i == 3 ? 1 : 0)));
                                    FarmerBee.this.f_19853_.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + FarmerBee.this.f_19853_.f_46441_.m_188501_() * 0.4f);
                                    FarmerBee.this.f_19853_.m_7731_(pos, (BlockState)cropBlockState.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
                                }
                            } else if (((Boolean)ProductiveBeesConfig.GENERAL.forceEnableFarmerBeeRightClickHarvest.get()).booleanValue() || ModList.get().isLoaded("right_click_get_crops") || ModList.get().isLoaded("croptopia") || ModList.get().isLoaded("quark") || ModList.get().isLoaded("harvest") || ModList.get().isLoaded("simplefarming") || ModList.get().isLoaded("reap")) {
                                FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)FarmerBee.this.f_19853_), (GameProfile)new GameProfile(FARMER_BEE_UUID, "farmer_bee"));
                                ForgeHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)new BlockHitResult(FarmerBee.this.m_146892_(), FarmerBee.this.m_6374_(), pos, true));
                            } else {
                                FarmerBee.this.f_19853_.m_46961_(pos, true);
                            }
                        }
                        FarmerBee.this.targetHarvestPos = null;
                        FarmerBee.this.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 nextTarget) {
            FarmerBee.this.m_21566_().m_6849_(nextTarget.f_82479_, nextTarget.f_82480_, nextTarget.f_82481_, 1.0);
        }
    }
}

