/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.loot.CustomDungeonLootProvider;
import me.desht.pneumaticcraft.common.loot.LootFunc;
import me.desht.pneumaticcraft.common.loot.MechanicVillagerChestLootProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModLootTablesProvider
extends LootTableProvider {
    public ModLootTablesProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(BlockLootTablePNC::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(MechanicVillagerChestLootProvider::new, (Object)LootContextParamSets.f_81411_), (Object)Pair.of(CustomDungeonLootProvider::new, (Object)LootContextParamSets.f_81411_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationresults) {
    }

    public String m_6055_() {
        return "PneumaticCraft Loot Tables";
    }

    private static class BlockLootTablePNC
    extends BlockLoot {
        private BlockLootTablePNC() {
        }

        protected void addTables() {
            for (RegistryObject ro : ModBlocks.BLOCKS.getEntries()) {
                Block b = (Block)ro.get();
                if (b instanceof PneumaticCraftEntityBlock && ForgeRegistries.ITEMS.containsKey(ro.getId())) {
                    this.addStandardSerializedDrop(b, ro.getId());
                    continue;
                }
                if (b instanceof SlabBlock) {
                    this.m_124175_(b, x$0 -> BlockLoot.m_124290_((Block)x$0));
                    continue;
                }
                if (b.m_5456_() == Items.f_41852_) continue;
                this.m_124288_(b);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> l = new ArrayList<Block>();
            for (RegistryObject ro : ModBlocks.BLOCKS.getEntries()) {
                if (!ForgeRegistries.ITEMS.containsKey(ro.getId())) continue;
                l.add((Block)ro.get());
            }
            return l;
        }

        private void addStandardSerializedDrop(Block block, ResourceLocation blockId) {
            LootPool.Builder builder = LootPool.m_79043_().name(blockId.m_135815_()).m_79080_(ExplosionCondition.m_81661_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(LootFunc.BlockEntitySerializerFunction.builder()));
            this.m_124165_(block, LootTable.m_79147_().m_79161_(builder));
        }
    }
}

