/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.fakeplayer;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemStackHandler;

public class DroneItemHandler
extends ItemStackHandler {
    private final IDrone holder;
    private int useableSlots;
    private ItemStack prevHeldStack = ItemStack.f_41583_;
    private boolean fakePlayerReady = false;

    public DroneItemHandler(IDrone holder, int useableSlots) {
        super(36);
        this.holder = holder;
        this.useableSlots = useableSlots;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.useableSlots) {
            return stack;
        }
        ItemStack res = super.insertItem(slot, stack, simulate);
        if (res.m_41613_() != stack.m_41613_() && !simulate) {
            this.copyItemToFakePlayer(slot);
        }
        return res;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.useableSlots) {
            return ItemStack.f_41583_;
        }
        ItemStack res = super.extractItem(slot, amount, simulate);
        if (!res.m_41619_() && !simulate) {
            this.copyItemToFakePlayer(slot);
        }
        return res;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= this.useableSlots) {
            return;
        }
        super.setStackInSlot(slot, stack);
        this.copyItemToFakePlayer(slot);
    }

    public int getSlots() {
        return Math.min(this.useableSlots, super.getSlots());
    }

    public void setUseableSlots(int useableSlots) {
        this.useableSlots = useableSlots;
    }

    protected boolean isFakePlayerReady() {
        return this.fakePlayerReady;
    }

    public void setFakePlayerReady() {
        if (!this.fakePlayerReady && !this.holder.world().f_46443_) {
            this.fakePlayerReady = true;
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                this.copyItemToFakePlayer(slot);
            }
        }
    }

    public void copyFromFakePlayer() {
        if (!this.fakePlayerReady) {
            return;
        }
        Inventory fakeInv = this.holder.getFakePlayer().m_150109_();
        for (int slot = 1; slot < fakeInv.m_6643_(); ++slot) {
            ItemStack stack = fakeInv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (slot < this.useableSlots) {
                super.setStackInSlot(slot, stack);
            } else {
                PneumaticCraftUtils.dropItemOnGround(stack, this.holder.world(), new BlockPos(this.holder.getDronePos()));
            }
            fakeInv.m_6836_(slot, ItemStack.f_41583_);
        }
    }

    public void copyItemToFakePlayer(int slot) {
        if (!this.fakePlayerReady) {
            return;
        }
        FakePlayer fakePlayer = this.holder.getFakePlayer();
        if (slot >= fakePlayer.m_150109_().f_35974_.size()) {
            return;
        }
        ItemStack newStack = this.getStackInSlot(slot);
        fakePlayer.m_150109_().f_35974_.set(slot, (Object)newStack);
        if (slot == fakePlayer.m_150109_().f_35977_) {
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, newStack);
            if (!this.prevHeldStack.m_41619_()) {
                fakePlayer.m_21204_().m_22161_(this.prevHeldStack.m_41638_(EquipmentSlot.MAINHAND));
            }
            if (!newStack.m_41619_()) {
                fakePlayer.m_21204_().m_22178_(newStack.m_41638_(EquipmentSlot.MAINHAND));
            }
            this.prevHeldStack = newStack.m_41777_();
        }
    }
}

