/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.PatchouliAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class Patchouli
implements IThirdParty,
IDocsProvider {
    static final ResourceLocation PNC_BOOK = PneumaticRegistry.RL("book");
    private static Screen prevGui;

    @Override
    public void clientInit() {
        MinecraftForge.EVENT_BUS.register(ScreenListener.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(ConfigListener.class);
        PatchouliAccess.setup();
    }

    @Override
    public void showWidgetDocs(String path) {
        Screen prev = Minecraft.m_91087_().f_91080_;
        if (PatchouliAccess.openBookEntry(PneumaticRegistry.RL("programming/" + path))) {
            prevGui = prev;
        }
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public ThirdPartyManager.ModType modType() {
        return ThirdPartyManager.ModType.DOCUMENTATION;
    }

    private static class ScreenListener {
        private ScreenListener() {
        }

        @SubscribeEvent
        public void onGuiOpen(ScreenEvent.Opening event) {
            if (prevGui != null) {
                event.setNewScreen(prevGui);
                prevGui = null;
            }
        }
    }

    private static class ConfigListener {
        private ConfigListener() {
        }

        @SubscribeEvent
        public static void onConfigChange(ModConfigEvent.Reloading event) {
            if (event.getConfig().getModId().equals("pneumaticcraft")) {
                PatchouliAccess.setConfigFlags();
            }
        }
    }
}

