/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.Log;

public class CompressorUpgradeCrafting
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public static final Supplier<List<Item>> COMPRESSORS = Suppliers.memoize(() -> List.of(CompressorUpgradeCrafting.getItem("advanced_air_compressor"), CompressorUpgradeCrafting.getItem("advanced_liquid_compressor"), CompressorUpgradeCrafting.getItem("air_compressor"), CompressorUpgradeCrafting.getItem("liquid_compressor")));

    public CompressorUpgradeCrafting(ResourceLocation pId, String pGroup, int pWidth, int pHeight, NonNullList<Ingredient> pRecipeItems, ItemStack pResult) {
        super(pId, pGroup, pWidth, pHeight, pRecipeItems, pResult);
    }

    private static Item getItem(String id) {
        return (Item)ForgeRegistries.ITEMS.getValue(PneumaticRegistry.RL(id));
    }

    @NotNull
    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack result = super.m_5874_(inv);
        int index = this.getMainItem(inv);
        if (index == -1) {
            Log.warn((Object[])new Object[]{"Just crafted a PNC Compressor upgrade recipe but couldn't find a compressor in the input!"});
            return result;
        }
        ItemStack input = inv.m_8020_(index);
        CompoundTag tag = input.m_41783_();
        if (tag == null) {
            return result;
        }
        Tag blockEntityTag = tag.m_128423_("BlockEntityTag");
        if (blockEntityTag == null) {
            return result;
        }
        result.m_41784_().m_128365_("BlockEntityTag", blockEntityTag);
        return result;
    }

    private int getMainItem(CraftingContainer container) {
        int i;
        boolean matchFound = false;
        for (i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (!COMPRESSORS.get().contains(item.m_41720_())) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            return -1;
        }
        return i;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    static class Serializer
    extends ShapedRecipe.Serializer {
        Serializer() {
        }

        public ShapedRecipe m_6729_(ResourceLocation pRecipeId, JsonObject pJson) {
            ShapedRecipe r = super.m_6729_(pRecipeId, pJson);
            return new CompressorUpgradeCrafting(r.m_6423_(), r.m_6076_(), r.getRecipeWidth(), r.getRecipeHeight(), (NonNullList<Ingredient>)r.m_7527_(), r.m_8043_());
        }

        public ShapedRecipe m_8005_(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ShapedRecipe r = super.m_8005_(pRecipeId, pBuffer);
            return new CompressorUpgradeCrafting(r.m_6423_(), r.m_6076_(), r.getRecipeWidth(), r.getRecipeHeight(), (NonNullList<Ingredient>)r.m_7527_(), r.m_8043_());
        }
    }
}

