/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.ArrayList;
import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.entity.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramLaser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ProgramDrillLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(AssemblyControllerBlockEntity.AssemblySystem system) {
        boolean useAir = true;
        Level world = system.getPlatform().m_58904_();
        if (!system.getPlatform().getHeldStack().m_41619_()) {
            if (this.canItemBeDrilled(world, system.getPlatform().getHeldStack())) {
                system.getDrill().goDrilling();
            } else if (system.getDrill().isIdle() && this.canItemBeLasered(world, system.getPlatform().getHeldStack())) {
                system.getLaser().startLasering();
            } else if (system.getDrill().isIdle() && system.getLaser().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else if (!system.getExportUnit().isIdle()) {
            useAir = system.getExportUnit().pickupItem(null);
        } else {
            ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
            recipes.addAll(this.getRecipeList(world));
            recipes.addAll(new ProgramDrill().getRecipeList(world));
            recipes.addAll(new ProgramLaser().getRecipeList(world));
            useAir = system.getImportUnit().pickupItem(recipes);
        }
        return useAir;
    }

    private boolean canItemBeLasered(Level world, ItemStack item) {
        return ((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_LASER.get()).stream(world).anyMatch(recipe -> recipe.matches(item));
    }

    private boolean canItemBeDrilled(Level world, ItemStack item) {
        return ((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL.get()).stream(world).anyMatch(recipe -> recipe.matches(item));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
    }

    @Override
    public Collection<AssemblyRecipe> getRecipeList(Level world) {
        return ((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL_LASER.get()).getRecipes(world).values();
    }

    @Override
    public AssemblyProgramItem getItem() {
        return (AssemblyProgramItem)((Object)ModItems.ASSEMBLY_PROGRAM_DRILL_LASER.get());
    }
}

