/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CommonArmorHandler
implements ICommonArmorHandler {
    private static final CommonArmorHandler clientHandler = new CommonArmorHandler(null);
    private static final CommonArmorHandler serverHandler = new CommonArmorHandler(null);
    private static final Vec3 FORWARD = new Vec3(0.0, 0.0, 1.0);
    public static final float CRITICAL_PRESSURE = 0.1f;
    public static final float LOW_PRESSURE = 0.5f;
    private final HashMap<UUID, CommonArmorHandler> playerHandlers = new HashMap();
    private Player player;
    private final boolean[][] upgradeRenderersInserted = new boolean[4][];
    private final boolean[][] upgradeRenderersEnabled = new boolean[4][];
    private final int[] ticksSinceEquip = new int[4];
    private final List<LazyOptional<IAirHandlerItem>> airHandlers = new ArrayList<LazyOptional<IAirHandlerItem>>();
    private final List<Map<PNCUpgrade, Integer>> upgradeMatrix = new ArrayList<Map<PNCUpgrade, Integer>>();
    private final int[] startupTimes = new int[4];
    private final IArmorExtensionData[][] extensionData = new IArmorExtensionData[4][];
    private boolean isValid;

    private CommonArmorHandler(Player player) {
        this.player = player;
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
            this.upgradeRenderersInserted[slot.m_20749_()] = new boolean[upgradeHandlers.size()];
            this.upgradeRenderersEnabled[slot.m_20749_()] = new boolean[upgradeHandlers.size()];
            this.upgradeMatrix.add(new HashMap());
            this.airHandlers.add((LazyOptional<IAirHandlerItem>)LazyOptional.empty());
            this.extensionData[slot.m_20749_()] = new IArmorExtensionData[upgradeHandlers.size()];
            for (IArmorUpgradeHandler<?> handler : upgradeHandlers) {
                this.extensionData[slot.m_20749_()][handler.getIndex()] = (IArmorExtensionData)handler.extensionData().get();
            }
        }
        Arrays.fill(this.startupTimes, 200);
        this.isValid = true;
    }

    private static CommonArmorHandler getManagerInstance(Player player) {
        return player.f_19853_.f_46443_ ? clientHandler : serverHandler;
    }

    public static CommonArmorHandler getHandlerForPlayer(Player player) {
        return CommonArmorHandler.getManagerInstance((Player)player).playerHandlers.computeIfAbsent(player.m_20148_(), v -> new CommonArmorHandler(player));
    }

    public static CommonArmorHandler getHandlerForPlayer() {
        return CommonArmorHandler.getHandlerForPlayer(ClientUtils.getClientPlayer());
    }

    @Override
    public <T extends IArmorExtensionData> T getExtensionData(IArmorUpgradeHandler<T> handler) {
        return (T)this.extensionData[handler.getEquipmentSlot().m_20749_()][handler.getIndex()];
    }

    private static void clearHandlerForPlayer(Player player) {
        CommonArmorHandler h = CommonArmorHandler.getManagerInstance(player);
        h.playerHandlers.computeIfPresent(player.m_20148_(), (name, val) -> {
            val.invalidate();
            return null;
        });
    }

    public void tickArmorPiece(EquipmentSlot slot) {
        ItemStack armorStack = this.player.m_6844_(slot);
        boolean armorActive = false;
        if (armorStack.m_41720_() instanceof PneumaticArmorItem) {
            this.airHandlers.set(slot.m_20749_(), (LazyOptional<IAirHandlerItem>)armorStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY));
            if (this.ticksSinceEquip[slot.m_20749_()] == 0) {
                this.initArmorInventory(slot);
            }
            int n = slot.m_20749_();
            this.ticksSinceEquip[n] = this.ticksSinceEquip[n] + 1;
            if (this.isArmorEnabled() && this.getArmorPressure(slot) > 0.0f) {
                float airUsage;
                armorActive = true;
                if (!this.player.f_19853_.f_46443_ && this.isArmorReady(slot) && !this.player.m_7500_() && (airUsage = this.getIdleAirUsage(slot, false)) != 0.0f) {
                    this.addAir(slot, (int)(-airUsage));
                }
                this.doArmorActions(slot);
            }
        } else {
            this.airHandlers.set(slot.m_20749_(), (LazyOptional<IAirHandlerItem>)LazyOptional.empty());
        }
        if (!armorActive) {
            if (this.ticksSinceEquip[slot.m_20749_()] > 0) {
                this.onArmorRemoved(slot);
            }
            this.ticksSinceEquip[slot.m_20749_()] = 0;
        }
    }

    public float getIdleAirUsage(EquipmentSlot slot, boolean countDisabled) {
        float totalUsage = 0.0f;
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i) || !countDisabled && !this.isUpgradeEnabled(slot, i)) continue;
            totalUsage += handlers.get(i).getIdleAirUsage(this);
        }
        return totalUsage;
    }

    private void onArmorRemoved(EquipmentSlot slot) {
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i)) continue;
            handlers.get(i).onShutdown(this);
        }
    }

    @Override
    public float addAir(EquipmentSlot slot, int airAmount) {
        float oldPressure = this.getArmorPressure(slot);
        if (!(this.player.m_7500_() && airAmount <= 0 || this.getUpgradeCount(slot, (PNCUpgrade)ModUpgrades.CREATIVE.get()) != 0)) {
            this.airHandlers.get(slot.m_20749_()).ifPresent(h -> h.addAir(airAmount));
        }
        return oldPressure;
    }

    private void doArmorActions(EquipmentSlot slot) {
        if (!this.isArmorReady(slot)) {
            return;
        }
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i)) continue;
            handlers.get(i).tick(this, this.isUpgradeEnabled(slot, i));
        }
        if (slot == EquipmentSlot.FEET && this.player.f_19853_.f_46443_ && this.player.m_20069_() && this.player.f_20902_ > 0.0f && this.isArmorReady(EquipmentSlot.FEET) && this.getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)ModUpgrades.FLIPPERS.get()) > 0) {
            this.player.m_19920_(this.player.m_20096_() ? ((Double)ConfigHelper.common().armor.flippersSpeedBoostGround.get()).floatValue() : ((Double)ConfigHelper.common().armor.flippersSpeedBoostFloating.get()).floatValue(), FORWARD);
        }
        if (!this.player.f_19853_.f_46443_ && this.getUpgradeCount(slot, (PNCUpgrade)ModUpgrades.ITEM_LIFE.get()) > 0) {
            this.tryRepairArmor(slot);
        }
    }

    private void tryRepairArmor(EquipmentSlot slot) {
        int upgrades = this.getUpgradeCount(slot, (PNCUpgrade)ModUpgrades.ITEM_LIFE.get(), 5);
        int interval = 120 - 20 * upgrades;
        int airUsage = (Integer)ConfigHelper.common().armor.repairAirUsage.get() * upgrades;
        ItemStack armorStack = this.player.m_6844_(slot);
        if (armorStack.m_41773_() > 0 && this.hasMinPressure(slot) && this.ticksSinceEquip[slot.m_20749_()] % interval == 0) {
            this.addAir(slot, -airUsage);
            armorStack.m_41721_(armorStack.m_41773_() - 1);
        }
    }

    public void initArmorInventory(EquipmentSlot slot) {
        ItemStack armorStack = this.player.m_6844_(slot);
        Map<PNCUpgrade, Integer> upgrades = UpgradableItemUtils.getUpgrades(armorStack);
        Arrays.fill(this.upgradeRenderersInserted[slot.m_20749_()], false);
        for (int i = 0; i < this.upgradeRenderersInserted[slot.m_20749_()].length; ++i) {
            this.upgradeRenderersInserted[slot.m_20749_()][i] = this.isModuleEnabled(upgrades.keySet(), ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).get(i));
        }
        this.upgradeMatrix.get(slot.m_20749_()).clear();
        upgrades.forEach((upgrade, count) -> this.upgradeMatrix.get(slot.m_20749_()).put((PNCUpgrade)upgrade, (Integer)count));
        this.startupTimes[slot.m_20749_()] = (int)((double)((Integer)ConfigHelper.common().armor.armorStartupTime.get()).intValue() * Math.pow(0.8, this.getSpeedFromUpgrades(slot) - 1));
        ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).forEach(handler -> {
            if (this.isUpgradeInserted(slot, handler.getIndex())) {
                handler.onInit(this);
            }
        });
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getUpgradeCount(EquipmentSlot slot, PNCUpgrade upgrade) {
        return this.upgradeMatrix.get(slot.m_20749_()).getOrDefault(upgrade, 0);
    }

    public int getUpgradeCount(EquipmentSlot slot, PNCUpgrade upgrade, int max) {
        return Math.min(max, this.getUpgradeCount(slot, upgrade));
    }

    public boolean isUpgradeInserted(EquipmentSlot slot, int featureIndex) {
        return this.upgradeRenderersInserted[slot.m_20749_()][featureIndex];
    }

    public boolean isUpgradeEnabled(EquipmentSlot slot, int featureIndex) {
        return this.upgradeRenderersEnabled[slot.m_20749_()][featureIndex];
    }

    public void setUpgradeEnabled(EquipmentSlot slot, byte featureIndex, boolean state) {
        this.upgradeRenderersEnabled[slot.m_20749_()][featureIndex] = state;
        IArmorUpgradeHandler<?> handler = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).get(featureIndex);
        handler.onToggle(this, state);
    }

    public int getTicksSinceEquipped(EquipmentSlot slot) {
        return this.ticksSinceEquip[slot.m_20749_()];
    }

    private boolean isModuleEnabled(Set<PNCUpgrade> upgrades, IArmorUpgradeHandler<?> handler) {
        return Arrays.stream(handler.getRequiredUpgrades()).allMatch(upgrades::contains);
    }

    @Override
    public int getSpeedFromUpgrades(EquipmentSlot slot) {
        return 1 + this.getUpgradeCount(slot, (PNCUpgrade)ModUpgrades.SPEED.get());
    }

    public int getStartupTime(EquipmentSlot slot) {
        return this.startupTimes[slot.m_20749_()];
    }

    public boolean isArmorReady(EquipmentSlot slot) {
        return this.getTicksSinceEquipped(slot) > this.getStartupTime(slot);
    }

    @Override
    public float getArmorPressure(EquipmentSlot slot) {
        return this.airHandlers.get(slot.m_20749_()).map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getAir(EquipmentSlot slot) {
        return this.airHandlers.get(slot.m_20749_()).map(IAirHandler::getAir).orElse(0);
    }

    @Override
    public boolean isArmorEnabled() {
        return this.isUpgradeEnabled(EquipmentSlot.HEAD, CommonUpgradeHandlers.coreComponentsHandler.getIndex());
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public boolean hasMinPressure(EquipmentSlot slot) {
        return this.getArmorPressure(slot) >= 0.1f;
    }

    @Override
    public boolean upgradeUsable(IArmorUpgradeHandler<?> upgrade, boolean mustBeActive) {
        EquipmentSlot slot = upgrade.getEquipmentSlot();
        int idx = upgrade.getIndex();
        return this.isArmorEnabled() && this.isArmorReady(slot) && this.hasMinPressure(slot) && this.isUpgradeInserted(slot, idx) && (!mustBeActive || this.isUpgradeEnabled(slot, idx));
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientListeners {
        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            ClientUtils.getOptionalClientPlayer().ifPresent(CommonArmorHandler::clearHandlerForPlayer);
        }

        @SubscribeEvent
        public static void tickEnd(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && ClientUtils.getOptionalClientPlayer().isEmpty() && ArmorUpgradeRegistry.getInstance().isFrozen()) {
                for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    ClientArmorRegistry.getInstance().getHandlersForSlot(slot).forEach(IArmorUpgradeClientHandler::reset);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Listeners {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(event.player);
                for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    handler.tickArmorPiece(slot);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            CommonArmorHandler.clearHandlerForPlayer(event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
            Player player;
            CommonArmorHandler handler;
            Entity entity = event.getEntity();
            if (entity instanceof Player && (handler = CommonArmorHandler.getManagerInstance((Player)player).playerHandlers.get((player = (Player)entity).m_20148_())) != null) {
                handler.player = player;
            }
        }
    }
}

