/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketSpawnIndicatorParticles {
    private final BlockPos pos0;
    private final DyeColor dyeColor;
    private final List<ByteOffset> offsets = new ArrayList<ByteOffset>();

    public PacketSpawnIndicatorParticles(List<BlockPos> posList, DyeColor dyeColor) {
        this.pos0 = posList.get(0);
        this.dyeColor = dyeColor;
        for (int i = 1; i < posList.size(); ++i) {
            BlockPos off = posList.get(i).m_121996_((Vec3i)this.pos0);
            if (off.m_123341_() < -128 || off.m_123341_() > 127 || off.m_123342_() < -128 || off.m_123342_() > 127 || off.m_123343_() < -128 || off.m_123343_() > 127) continue;
            this.offsets.add(new ByteOffset(off.m_123341_(), off.m_123342_(), off.m_123343_()));
        }
    }

    public PacketSpawnIndicatorParticles(FriendlyByteBuf buffer) {
        this.pos0 = buffer.m_130135_();
        int nOffsets = buffer.m_130242_();
        for (int i = 0; i < nOffsets; ++i) {
            this.offsets.add(new ByteOffset(buffer.readByte(), buffer.readByte(), buffer.readByte()));
        }
        this.dyeColor = DyeColor.m_41053_((int)buffer.m_130242_());
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos0);
        buffer.m_130130_(this.offsets.size());
        for (ByteOffset offset : this.offsets) {
            buffer.writeByte((int)offset.x);
            buffer.writeByte((int)offset.y);
            buffer.writeByte((int)offset.z);
        }
        buffer.m_130130_(this.dyeColor.m_41060_());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ClientUtils.getClientLevel();
            float[] cols = this.dyeColor.m_41068_();
            DustParticleOptions particle = new DustParticleOptions(new Vector3f(cols[0], cols[1], cols[2]), 1.0f);
            world.m_7106_((ParticleOptions)particle, (double)this.pos0.m_123341_() + 0.5, (double)this.pos0.m_123342_() + 0.5, (double)this.pos0.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            for (ByteOffset offset : this.offsets) {
                world.m_7106_((ParticleOptions)particle, (double)(this.pos0.m_123341_() + offset.x) + 0.5, (double)(this.pos0.m_123342_() + offset.y) + 0.5, (double)(this.pos0.m_123343_() + offset.z) + 0.5, 0.0, 0.0, 0.0);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static class ByteOffset {
        private final byte x;
        private final byte y;
        private final byte z;

        private ByteOffset(int x, int y, int z) {
            this.x = (byte)x;
            this.y = (byte)y;
            this.z = (byte)z;
        }
    }
}

