/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.capabilities.FluidItemWrapper;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ILeftClickableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.curios.CuriosUtils;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;

public class MemoryStickItem
extends Item
implements ColorHandlers.ITintableItem,
ILeftClickableItem {
    private static final String TANK_NAME = "Tank";
    private static final String NBT_ABSORB_ORBS = "AbsorbXPOrbs";
    private static final int XP_FLUID_CAPACITY = 512000;
    private static final int[] TINT_COLORS = new int[]{0xF7FFBF, 0xF2FF99, 15597427, 15269709, 14941990, 14614272};

    public MemoryStickItem() {
        super(ModItems.defaultProps().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (stack.m_41613_() != 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!worldIn.f_46443_) {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
                int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
                int playerXp = EnchantmentUtils.getPlayerXP(playerIn);
                if (playerIn.m_6144_()) {
                    int xpToGive = EnchantmentUtils.getExperienceForLevel(playerIn.f_36078_ + 1) - playerXp;
                    int fluidAmount = xpToGive * ratio;
                    FluidStack toDrain = handler.drain(fluidAmount, IFluidHandler.FluidAction.SIMULATE);
                    if (!toDrain.isEmpty()) {
                        EnchantmentUtils.addPlayerXP(playerIn, toDrain.getAmount() / ratio);
                        handler.drain(toDrain.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        playerIn.m_21008_(handIn, handler.getContainer());
                    }
                } else if (playerXp > 0) {
                    int xpToTake = playerXp - EnchantmentUtils.getExperienceForLevel(playerIn.f_36078_);
                    if (xpToTake == 0) {
                        xpToTake = playerXp - EnchantmentUtils.getExperienceForLevel(playerIn.f_36078_ - 1);
                    }
                    int fluidAmount = xpToTake * ratio;
                    FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
                    int filled = handler.fill(toFill, IFluidHandler.FluidAction.SIMULATE);
                    if (filled >= ratio) {
                        EnchantmentUtils.addPlayerXP(playerIn, -(filled / ratio));
                        handler.fill(new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), filled), IFluidHandler.FluidAction.EXECUTE);
                        playerIn.m_21008_(handIn, handler.getContainer());
                    }
                }
            });
        } else {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
                int amount = handler.getFluidInTank(0).getAmount();
                if (EnchantmentUtils.getPlayerXP(playerIn) > 0 && amount < handler.getTankCapacity(0) && !playerIn.m_6144_() || handler.getFluidInTank(0).getAmount() > 0 && playerIn.m_6144_()) {
                    playerIn.m_5496_(SoundEvents.f_11871_, 0.1f, (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.35f + 0.9f);
                }
            });
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (worldIn != null) {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
                int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
                if (ratio > 0) {
                    FluidStack fluidStack = handler.getFluidInTank(0);
                    int amount = fluidStack.getAmount();
                    int levels = EnchantmentUtils.getLevelForExperience(amount / ratio);
                    tooltip.add((Component)Component.m_237110_((String)"pneumaticcraft.gui.tooltip.memory_stick.xp_stored", (Object[])new Object[]{amount / ratio, levels}).m_130940_(ChatFormatting.GREEN));
                }
            });
            boolean absorb = MemoryStickItem.shouldAbsorbXPOrbs(stack);
            tooltip.add((Component)Component.m_237115_((String)("pneumaticcraft.message.memory_stick.absorb." + absorb)).m_130940_(ChatFormatting.YELLOW));
        }
    }

    public int m_142158_(ItemStack pStack) {
        return pStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            return Math.round((float)fluidStack.getAmount() / (float)handler.getTankCapacity(0) * 13.0f);
        }).orElse(0);
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidItemWrapper(stack, TANK_NAME, 512000, fluid -> fluid == ModFluids.MEMORY_ESSENCE.get());
    }

    public static boolean shouldAbsorbXPOrbs(ItemStack stack) {
        return stack.m_41720_() == ModItems.MEMORY_STICK.get() && stack.m_41613_() == 1 && stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128471_(NBT_ABSORB_ORBS);
    }

    public static void setAbsorbXPOrbs(ItemStack stack, boolean absorb) {
        if (stack.m_41720_() == ModItems.MEMORY_STICK.get()) {
            stack.m_41784_().m_128379_(NBT_ABSORB_ORBS, absorb);
        }
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return switch (tintIndex) {
            case 1 -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
                FluidStack fluidStack = handler.getFluidInTank(0);
                if (fluidStack.isEmpty()) {
                    return 0xFFFFFF;
                }
                float f = (float)fluidStack.getAmount() / (float)handler.getTankCapacity(0);
                return TINT_COLORS[(int)(f * 5.0f)];
            }).orElse(-1);
            case 2 -> {
                if (MemoryStickItem.shouldAbsorbXPOrbs(stack)) {
                    yield -16711936;
                }
                yield -8355712;
            }
            default -> -1;
        };
    }

    @Override
    public void onLeftClickEmpty(ServerPlayer sender) {
        MemoryStickItem.toggleXPAbsorption((Player)sender, sender.m_21205_());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (MemoryStickItem.shouldAbsorbXPOrbs(stack) && entityIn instanceof Player && itemSlot >= 0) {
            MemoryStickItem.cacheMemoryStickLocation((Player)entityIn, MemoryStickLocator.playerInv(itemSlot));
        }
    }

    public static boolean isRoomInStick(ItemStack stick) {
        return stick.m_41720_() instanceof MemoryStickItem && (Boolean)stick.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> h.getFluidInTank(0).getAmount() < h.getTankCapacity(0)).orElseThrow(RuntimeException::new) != false;
    }

    private static void toggleXPAbsorption(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof MemoryStickItem) {
            boolean absorb = MemoryStickItem.shouldAbsorbXPOrbs(stack);
            MemoryStickItem.setAbsorbXPOrbs(stack, !absorb);
            player.m_5661_((Component)Component.m_237115_((String)("pneumaticcraft.message.memory_stick.absorb." + !absorb)).m_130940_(ChatFormatting.YELLOW), true);
            player.m_20193_().m_5594_(null, player.m_20183_(), SoundEvents.f_12211_, SoundSource.PLAYERS, 1.0f, absorb ? 1.5f : 2.0f);
        }
    }

    public static void cacheMemoryStickLocation(Player entityIn, MemoryStickLocator locator) {
        Listener.memoryStickCache.computeIfAbsent(entityIn.m_20148_(), k -> new HashSet()).add(locator);
    }

    public static class MemoryStickLocator {
        final String invName;
        final int slot;

        private MemoryStickLocator(@Nonnull String invName, int slot) {
            Validate.notNull((Object)invName);
            Validate.isTrue((slot >= 0 ? 1 : 0) != 0);
            this.invName = invName;
            this.slot = slot;
        }

        public static MemoryStickLocator playerInv(int slot) {
            return new MemoryStickLocator("", slot);
        }

        public static MemoryStickLocator namedInv(String name, int slot) {
            return new MemoryStickLocator(name, slot);
        }

        public ItemStack getMemoryStick(Player player) {
            if (this.invName.isEmpty()) {
                return player.m_150109_().m_8020_(this.slot);
            }
            if (Curios.available) {
                return CuriosUtils.getStack(player, this.invName, this.slot);
            }
            return ItemStack.f_41583_;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MemoryStickLocator)) {
                return false;
            }
            MemoryStickLocator that = (MemoryStickLocator)o;
            return this.slot == that.slot && this.invName.equals(that.invName);
        }

        public int hashCode() {
            return Objects.hash(this.invName, this.slot);
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        private static final Map<UUID, Long> lastEvent = new HashMap<UUID, Long>();
        private static final Map<UUID, Set<MemoryStickLocator>> memoryStickCache = new HashMap<UUID, Set<MemoryStickLocator>>();

        @SubscribeEvent
        public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().m_41720_() instanceof MemoryStickItem) {
                long last;
                long now;
                if (!event.getLevel().f_46443_ && (now = event.getLevel().m_46467_()) - (last = lastEvent.getOrDefault(event.getEntity().m_20148_(), 0L).longValue()) > 5L) {
                    MemoryStickItem.toggleXPAbsorption(event.getEntity(), event.getItemStack());
                    lastEvent.put(event.getEntity().m_20148_(), now);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getLevel().f_46443_ && event.getItemStack().m_41720_() instanceof MemoryStickItem) {
                NetworkHandler.sendToServer(new PacketLeftClickEmpty());
            }
        }

        @SubscribeEvent
        public static void onXpOrbPickup(PlayerXpEvent.PickupXp event) {
            ItemStack stack = Listener.findMemoryStick(event.getEntity());
            if (!stack.m_41619_()) {
                stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
                    if (PneumaticCraftUtils.fillTankWithOrb((IFluidHandler)handler, event.getOrb(), IFluidHandler.FluidAction.EXECUTE)) {
                        stack.m_41751_(handler.getContainer().m_41783_());
                        event.getOrb().m_146870_();
                        event.setCanceled(true);
                    }
                });
            }
        }

        private static ItemStack findMemoryStick(Player player) {
            Set<MemoryStickLocator> locators = memoryStickCache.get(player.m_20148_());
            if (locators == null || locators.isEmpty()) {
                return ItemStack.f_41583_;
            }
            locators.removeIf(loc -> !MemoryStickItem.shouldAbsorbXPOrbs(loc.getMemoryStick(player)));
            return locators.stream().map(loc -> loc.getMemoryStick(player)).filter(MemoryStickItem::isRoomInStick).findFirst().orElse(ItemStack.f_41583_);
        }
    }
}

