/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.Locale;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TransferGadgetEntity
extends AbstractSemiblockEntity
implements IDirectionalSemiblock {
    private static final int TRANSFER_INTERVAL = 40;
    private static final double INDENT = 0.0625;
    private static final double THICKNESS = 0.03125;
    private static final double ANTI_Z_FIGHT = 0.001;
    private static final EntityDataAccessor<Integer> IO_MODE = SynchedEntityData.m_135353_(TransferGadgetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIDE = SynchedEntityData.m_135353_(TransferGadgetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int counter;

    public TransferGadgetEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IO_MODE, (Object)IOMode.OUTPUT.ordinal());
        this.m_20088_().m_135372_(SIDE, (Object)Direction.UP.m_122411_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && ++this.counter >= 40) {
            this.counter = 0;
            this.doTransfer();
        }
    }

    @Override
    public void onPlaced(Player player, ItemStack stack, Direction facing) {
        super.onPlaced(player, stack, facing);
        this.setIOMode(IOMode.OUTPUT);
        this.setSide(facing);
    }

    @Override
    public boolean onRightClickWithConfigurator(Player player, Direction side) {
        if (this.getSide() == side) {
            this.toggle(player);
            return true;
        }
        return super.onRightClickWithConfigurator(player, side);
    }

    @Override
    public InteractionResult m_7111_(Player player, Vec3 hitVec, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_()) {
            this.toggle(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, hitVec, hand);
    }

    private void toggle(Player player) {
        this.setIOMode(this.getIOMode().toggle());
        player.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
    }

    @Override
    public boolean canStay() {
        return this.canPlace(this.getSide());
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockEntity te = this.getCachedTileEntity();
        return te != null && (te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent() || te.getCapability(ForgeCapabilities.FLUID_HANDLER, facing).isPresent());
    }

    @Override
    public Direction getSide() {
        return Direction.values()[(Integer)this.m_20088_().m_135370_(SIDE)];
    }

    @Override
    public void setSide(Direction facing) {
        this.m_20088_().m_135381_(SIDE, (Object)facing.m_122411_());
    }

    public IOMode getIOMode() {
        return IOMode.values()[(Integer)this.m_20088_().m_135370_(IO_MODE)];
    }

    private void setIOMode(IOMode mode) {
        this.m_20088_().m_135381_(IO_MODE, (Object)mode.ordinal());
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.counter = compound.m_128451_("counter");
        this.setSide(Direction.m_122376_((int)compound.m_128445_("facing")));
        this.setIOMode(compound.m_128471_("input") ? IOMode.INPUT : IOMode.OUTPUT);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("counter", this.counter);
        compound.m_128344_("facing", (byte)this.getSide().m_122411_());
        compound.m_128379_("input", this.getIOMode() == IOMode.INPUT);
    }

    @Override
    public void addTooltip(Consumer<Component> curInfo, Player player, CompoundTag tag, boolean extended) {
        curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.facing", this.getSide()));
        curInfo.accept((Component)PneumaticCraftUtils.xlate(this.getIOMode().getTranslationKey(), new Object[0]));
    }

    @Override
    protected AABB calculateBlockBounds() {
        AABB b = super.calculateBlockBounds();
        return switch (this.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> new AABB(b.f_82288_ - 0.03125, b.f_82292_ - 0.0625, b.f_82290_ - 0.03125, b.f_82291_ + 0.03125, b.f_82292_ + 0.03125, b.f_82293_ + 0.03125);
            case Direction.DOWN -> new AABB(b.f_82288_ - 0.03125, -0.001, b.f_82290_ - 0.03125, b.f_82291_ + 0.03125, b.f_82289_ + 0.0625, b.f_82293_ + 0.03125);
            case Direction.NORTH -> new AABB(b.f_82288_ - 0.03125, b.f_82289_ - 0.03125, -0.001, b.f_82291_ + 0.03125, b.f_82292_ + 0.03125, b.f_82290_ + 0.0625);
            case Direction.SOUTH -> new AABB(b.f_82288_ - 0.03125, b.f_82289_ - 0.03125, b.f_82293_ - 0.0625, b.f_82291_ + 0.03125, b.f_82292_ + 0.03125, 1.001);
            case Direction.WEST -> new AABB(-0.001, b.f_82289_ - 0.03125, b.f_82290_ - 0.03125, b.f_82288_ + 0.0625, b.f_82292_ + 0.03125, b.f_82293_ + 0.03125);
            case Direction.EAST -> new AABB(b.f_82291_ - 0.0625, b.f_82289_ - 0.03125, b.f_82290_ - 0.03125, 1.001, b.f_82292_ + 0.03125, b.f_82293_ + 0.03125);
        };
    }

    private void doTransfer() {
        BlockEntity inputTE = this.getCachedTileEntity();
        Direction side = this.getSide();
        Direction otherSide = this.getSide().m_122424_();
        BlockEntity outputTE = this.f_19853_.m_7702_(this.getBlockPos().m_121945_(side));
        if (inputTE != null && outputTE != null) {
            if (this.getIOMode() == IOMode.OUTPUT) {
                this.tryTransferItem(inputTE, outputTE, side, otherSide);
                this.tryTransferFluid(inputTE, outputTE, side, otherSide);
            } else {
                this.tryTransferItem(outputTE, inputTE, otherSide, side);
                this.tryTransferFluid(outputTE, inputTE, otherSide, side);
            }
        }
    }

    private void tryTransferItem(BlockEntity inputTE, BlockEntity outputTE, Direction side, Direction otherSide) {
        inputTE.getCapability(ForgeCapabilities.ITEM_HANDLER, side).ifPresent(input -> outputTE.getCapability(ForgeCapabilities.ITEM_HANDLER, otherSide).ifPresent(output -> IOHelper.transferOneItem(input, output)));
    }

    private void tryTransferFluid(BlockEntity inputTE, BlockEntity outputTE, Direction side, Direction otherSide) {
        inputTE.getCapability(ForgeCapabilities.FLUID_HANDLER, side).ifPresent(input -> outputTE.getCapability(ForgeCapabilities.FLUID_HANDLER, otherSide).ifPresent(output -> FluidUtil.tryFluidTransfer((IFluidHandler)output, (IFluidHandler)input, (int)100, (boolean)true)));
    }

    public static enum IOMode implements ITranslatableEnum
    {
        INPUT(Textures.MODEL_TRANSFER_GADGET_IN),
        OUTPUT(Textures.MODEL_TRANSFER_GADGET_OUT);

        private final ResourceLocation texture;

        private IOMode(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        IOMode toggle() {
            return this == INPUT ? OUTPUT : INPUT;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.transfer_gadget.io_mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

