/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import java.util.List;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetHarvest;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryImport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetWait;
import me.desht.pneumaticcraft.common.entity.drone.AbstractBasicDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.util.DroneProgramBuilder;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HarvestingDroneEntity
extends AbstractBasicDroneEntity {
    public HarvestingDroneEntity(EntityType<HarvestingDroneEntity> type, Level world) {
        super((EntityType<? extends DroneEntity>)type, world);
    }

    public HarvestingDroneEntity(Level world, Player player) {
        super((EntityType<? extends DroneEntity>)((EntityType)ModEntityTypes.HARVESTING_DRONE.get()), world, player);
    }

    @Override
    public boolean addProgram(BlockPos clickPos, Direction facing, BlockPos pos, ItemStack droneStack, List<IProgWidget> widgets) {
        BlockEntity te = this.f_19853_.m_7702_(clickPos);
        ProgWidgetHarvest harvestPiece = new ProgWidgetHarvest();
        harvestPiece.setRequiresTool(IOHelper.getInventoryForTE(te, facing).isPresent());
        harvestPiece.setOrder(IBlockOrdered.Ordering.HIGH_TO_LOW);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        builder.add(new ProgWidgetInventoryImport(), ProgWidgetArea.fromPosition(clickPos));
        builder.add(harvestPiece, ProgWidgetArea.fromPosition(clickPos, 16, 16, 16));
        this.maybeAddStandbyInstruction(builder, droneStack);
        builder.add(new ProgWidgetWait(), ProgWidgetText.withText("10s"));
        widgets.addAll(builder.build());
        return true;
    }
}

