/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.IPathfindHandler;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.block.DroneRedstoneEmitterBlock;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.debug.DroneDebugger;
import me.desht.pneumaticcraft.common.drone.DroneMovementController;
import me.desht.pneumaticcraft.common.drone.DroneRegistry;
import me.desht.pneumaticcraft.common.drone.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.LogisticsManager;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.ai.DroneGoToChargingStation;
import me.desht.pneumaticcraft.common.drone.ai.DroneGoToOwner;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.drone.progwidgets.WidgetSerializer;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.thirdparty.RadiationSourceCheck;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.common.util.upgrade.IUpgradeHolder;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradeCache;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.mixin.accessors.EntityAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class DroneEntity
extends AbstractDroneEntity
implements IManoMeasurable,
IPneumaticWrenchable,
IEntityAdditionalSpawnData,
IHackableEntity<DroneEntity>,
IDroneBase,
FlyingAnimal,
IUpgradeHolder {
    private static final float LASER_EXTEND_SPEED = 0.05f;
    private static final EntityDataAccessor<Boolean> ACCELERATING = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PRESSURE = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> PROGRAM_KEY = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<BlockPos> DUG_POS = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOING_TO_OWNER = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DRONE_COLOR = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> MINIGUN_ACTIVE = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_MINIGUN = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> LABEL = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ACTIVE_WIDGET = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final MutableComponent DEF_DRONE_NAME = Component.m_237113_((String)"Drone");
    public static final String NBT_DRONE_COLOR = "color";
    private static final HashMap<Component, Integer> LASER_COLOR_MAP = new HashMap();
    private final EntityDroneItemHandler droneItemHandler = new EntityDroneItemHandler(this);
    private final LazyOptional<IItemHandlerModifiable> droneItemHandlerCap = LazyOptional.of(() -> this.droneItemHandler);
    private final FluidTank fluidTank = new FluidTank(Integer.MAX_VALUE);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidTank);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final ItemStackHandler upgradeInventory = new ItemStackHandler(9);
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    private BasicAirHandler airHandler;
    private final LazyOptional<IAirHandler> airCap = LazyOptional.of(this::getAirHandler);
    private final Map<Direction, Integer> emittingRedstoneValues = new EnumMap<Direction, Integer>(Direction.class);
    private float propSpeed;
    private ProgressingLine targetLine;
    private ProgressingLine oldTargetLine;
    public List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private DroneFakePlayer fakePlayer;
    public Component ownerName = DEF_DRONE_NAME;
    private UUID ownerUUID;
    private final DroneGoToChargingStation chargeAI;
    private DroneGoToOwner gotoOwnerAI;
    private final DroneAIManager aiManager = new DroneAIManager(this);
    private double droneSpeed;
    private int healingInterval;
    private int suffocationCounter = 40;
    private boolean isSuffocating;
    private boolean disabledByHacking;
    private boolean standby;
    private Minigun minigun;
    private int attackCount;
    private BlockPos deployPos;
    private final DroneDebugger debugger = new DroneDebugger(this);
    private int securityUpgradeCount;
    private final Map<BlockPos, BlockState> displacedLiquids = new HashMap<BlockPos, BlockState>();
    private LogisticsManager logisticsManager;
    private final Map<Enchantment, Integer> stackEnchants = new HashMap<Enchantment, Integer>();
    private boolean carriedEntityAIdisabled;
    private static final Set<Block> MC181565_BLOCKS;

    public DroneEntity(EntityType<? extends DroneEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new DroneMovementController(this);
        this.chargeAI = new DroneGoToChargingStation(this);
        this.f_21345_.m_25352_(1, (Goal)this.chargeAI);
    }

    DroneEntity(EntityType<? extends DroneEntity> type, Level world, Player player) {
        this(type, world);
        if (player != null) {
            this.ownerUUID = player.m_36316_().getId();
            this.ownerName = player.m_7755_();
        } else {
            this.ownerUUID = this.m_20148_();
            this.ownerName = DEF_DRONE_NAME;
        }
    }

    public DroneEntity(Level world, Player player) {
        this((EntityType<? extends DroneEntity>)((EntityType)ModEntityTypes.DRONE.get()), world, player);
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().f_46443_ && event.getWorld() == this.m_20193_() && event.getSemiblock() instanceof AbstractLogisticsFrameEntity) {
            this.logisticsManager = null;
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        EntityPathNavigateDrone nav = new EntityPathNavigateDrone(this, worldIn);
        nav.m_26440_(false);
        nav.m_7008_(true);
        nav.m_26443_(true);
        return nav;
    }

    public void readFromItemStack(ItemStack droneStack) {
        Validate.isTrue((boolean)(droneStack.m_41720_() instanceof DroneItem));
        CompoundTag stackTag = droneStack.m_41783_();
        if (stackTag != null) {
            this.upgradeInventory.deserializeNBT(stackTag.m_128469_("UpgradeInventory"));
            Map ench = EnchantmentHelper.m_44831_((ItemStack)droneStack);
            ench.keySet().removeIf(e -> !droneStack.m_41720_().canApplyAtEnchantingTable(droneStack, e));
            this.stackEnchants.putAll(ench);
            int air = ((IAirHandlerItem)droneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).getAir();
            this.getAirHandler().addAir(air);
            DroneItem droneItem = (DroneItem)droneStack.m_41720_();
            if (droneItem.canProgram(droneStack)) {
                this.progWidgets = WidgetSerializer.getWidgetsFromNBT(stackTag);
                ProgrammerBlockEntity.updatePuzzleConnections(this.progWidgets);
            }
            this.setDroneColor(droneItem.getDroneColor(droneStack).m_41060_());
            this.fluidTank.setCapacity(16000 * (1 + this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get())));
            this.droneItemHandler.setUseableSlots(1 + this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get()));
            if (stackTag.m_128441_("Tank")) {
                this.fluidTank.readFromNBT(stackTag.m_128469_("Tank"));
            }
        }
        if (droneStack.m_41788_()) {
            this.m_6593_(droneStack.m_41786_());
        }
    }

    private void writeToItemStack(ItemStack droneStack) {
        Validate.isTrue((boolean)(droneStack.m_41720_() instanceof DroneItem));
        CompoundTag tag = new CompoundTag();
        if (((DroneItem)droneStack.m_41720_()).canProgram(droneStack)) {
            WidgetSerializer.putWidgetsToNBT(this.progWidgets, tag);
        }
        tag.m_128405_(NBT_DRONE_COLOR, this.getDroneColor());
        if (!this.fluidTank.isEmpty()) {
            tag.m_128365_("Tank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        }
        droneStack.m_41751_(tag);
        UpgradableItemUtils.setUpgrades(droneStack, this.upgradeInventory);
        EnchantmentHelper.m_44865_(this.stackEnchants, (ItemStack)droneStack);
        ((IAirHandlerItem)droneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).addAir(this.getAirHandler().getAir());
        if (this.m_8077_()) {
            droneStack.m_41714_(this.m_7770_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PRESSURE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACCELERATING, (Object)false);
        this.f_19804_.m_135372_(PROGRAM_KEY, (Object)"");
        this.f_19804_.m_135372_(DUG_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOING_TO_OWNER, (Object)false);
        this.f_19804_.m_135372_(DRONE_COLOR, (Object)DyeColor.BLACK.m_41060_());
        this.f_19804_.m_135372_(MINIGUN_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(HAS_MINIGUN, (Object)false);
        this.f_19804_.m_135372_(AMMO, (Object)-256);
        this.f_19804_.m_135372_(LABEL, (Object)"");
        this.f_19804_.m_135372_(ACTIVE_WIDGET, (Object)0);
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(TARGET_ID, (Object)0);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 75.0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.droneItemHandlerCap.cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        if (capability == PNCCapabilities.AIR_HANDLER_CAPABILITY) {
            return this.airCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.ownerUUID);
        buffer.m_130083_(this.ownerName);
        buffer.m_130130_(this.getUpgrades((PNCUpgrade)ModUpgrades.SECURITY.get()));
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.ownerUUID = buffer.m_130259_();
        this.ownerName = buffer.m_130238_();
        this.securityUpgradeCount = buffer.m_130242_();
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSounds.DRONE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DRONE_DEATH.get();
    }

    public void m_8119_() {
        boolean enabled;
        if (this.f_19797_ == 1) {
            this.onFirstTick();
        }
        boolean bl = enabled = !this.disabledByHacking && this.getAirHandler().getPressure() > 0.01f;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(PRESSURE, (Object)Float.valueOf((float)((int)(this.getAirHandler().getPressure() * 10.0f)) / 10.0f));
            this.setAccelerating(!this.standby && enabled);
            if (this.isAccelerating()) {
                this.f_19789_ = 0.0f;
            }
            if (this.healingInterval != 0 && this.m_21223_() < this.m_21233_() && this.f_19797_ % this.healingInterval == 0) {
                this.m_5634_(1.0f);
                this.airHandler.addAir(-this.healingInterval);
            }
            if (!this.isSuffocating) {
                this.suffocationCounter = 40;
            }
            this.isSuffocating = false;
            Path path = this.m_21573_().m_26570_();
            if (path != null) {
                Node target = path.m_77395_();
                if (target != null) {
                    this.setTargetedBlock(new BlockPos(target.f_77271_, target.f_77272_, target.f_77273_));
                } else {
                    this.setTargetedBlock(null);
                }
            } else {
                this.setTargetedBlock(null);
            }
            if (this.f_19853_.m_46467_() % 20L == 0L) {
                this.debugger.updateDebuggingPlayers();
            }
            FakePlayer fp = this.getFakePlayer();
            fp.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            fp.m_8119_();
            if (this.m_6084_()) {
                for (int i = 0; i < 4; ++i) {
                    fp.f_8941_.m_7712_();
                }
            }
            if (this.securityUpgradeCount > 1 && this.m_21223_() > 0.0f) {
                this.handleFluidDisplacement();
            }
        } else {
            this.oldLaserExtension = this.laserExtension;
            this.laserExtension = this.getActiveProgramKey().m_135815_().equals("dig") ? Math.min(1.0f, this.laserExtension + 0.05f) : Math.max(0.0f, this.laserExtension - 0.05f);
            if (this.isAccelerating() && this.f_19853_.f_46441_.m_188499_()) {
                int x = (int)Math.floor(this.m_20185_());
                int y = (int)Math.floor(this.m_20186_() - 1.0);
                int z = (int)Math.floor(this.m_20189_());
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = null;
                int i = 0;
                while (i < 3 && (state = this.f_19853_.m_8055_(pos)).m_60767_() == Material.f_76296_) {
                    ++i;
                    --y;
                }
                if (state.m_60767_() != Material.f_76296_) {
                    Vec3 vec = new Vec3(this.m_20186_() - (double)y, 0.0, 0.0);
                    vec = vec.m_82524_((float)((double)this.f_19796_.m_188501_() * Math.PI * 2.0));
                    BlockParticleOption data = new BlockParticleOption(ParticleTypes.f_123794_, state);
                    this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_() + vec.f_82479_, (double)(y + 1), this.m_20189_() + vec.f_82481_, vec.f_82479_, 0.0, vec.f_82481_);
                }
            }
        }
        if (this.isAccelerating()) {
            this.m_20256_(this.m_20184_().m_82490_(0.3));
            this.propSpeed = Math.min(1.0f, this.propSpeed + 0.04f);
            this.getAirHandler().addAir(-1);
        } else {
            this.propSpeed = Math.max(0.0f, this.propSpeed - 0.04f);
        }
        this.oldPropRotation = this.propRotation;
        this.propRotation += this.propSpeed;
        super.m_8119_();
        if (this.hasMinigun()) {
            this.getMinigun().setAttackTarget(this.m_5448_()).tick(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (enabled) {
                DroneAIManager prevActive = this.getActiveAIManager();
                this.aiManager.onUpdateTasks();
                if (this.getActiveAIManager() != prevActive) {
                    this.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this), p));
                }
            }
            this.handleRedstoneEmission();
        }
    }

    private void onFirstTick() {
        if (!this.f_19853_.f_46443_) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            double newDroneSpeed = 0.15f + (float)Math.min(10, this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get())) * 0.015f;
            if (this.getUpgrades((PNCUpgrade)ModUpgrades.ARMOR.get()) > 6) {
                newDroneSpeed -= (double)(0.01f * (float)(this.getUpgrades((PNCUpgrade)ModUpgrades.ARMOR.get()) - 6));
            }
            this.setDroneSpeed(newDroneSpeed);
            this.healingInterval = this.getUpgrades((PNCUpgrade)ModUpgrades.ITEM_LIFE.get()) > 0 ? 100 / this.getUpgrades((PNCUpgrade)ModUpgrades.ITEM_LIFE.get()) : 0;
            this.securityUpgradeCount = this.getUpgrades((PNCUpgrade)ModUpgrades.SECURITY.get());
            this.m_21441_(BlockPathTypes.WATER, this.securityUpgradeCount > 0 ? 0.0f : -1.0f);
            this.energy.setCapacity(100000 + 100000 * this.getUpgrades((PNCUpgrade)ModUpgrades.VOLUME.get()));
            this.setHasMinigun(this.getUpgrades((PNCUpgrade)ModUpgrades.MINIGUN.get()) > 0);
            this.droneItemHandler.setFakePlayerReady();
            this.aiManager.setWidgets(this.progWidgets);
        }
    }

    private void handleRedstoneEmission() {
        for (Direction d : DirectionUtil.VALUES) {
            if (this.getEmittingRedstone(d) <= 0) continue;
            BlockPos emitterPos = new BlockPos((int)Math.floor(this.m_20185_() + (double)(this.m_20205_() / 2.0f)), (int)Math.floor(this.m_20186_()), (int)Math.floor(this.m_20189_() + (double)(this.m_20205_() / 2.0f)));
            if (!this.f_19853_.m_46859_(emitterPos)) break;
            this.f_19853_.m_46597_(emitterPos, ((DroneRedstoneEmitterBlock)((Object)ModBlocks.DRONE_REDSTONE_EMITTER.get())).m_49966_());
            break;
        }
    }

    private void handleFluidDisplacement() {
        this.restoreFluidBlocks(true);
        for (int x = (int)this.m_20185_() - 1; x <= (int)(this.m_20185_() + (double)this.m_20205_()); ++x) {
            for (int y = (int)this.m_20186_() - 1; y <= (int)(this.m_20186_() + (double)this.m_20206_() + 1.0); ++y) {
                for (int z = (int)this.m_20189_() - 2; z <= (int)(this.m_20189_() + (double)this.m_20205_()); ++z) {
                    if (!PneumaticCraftUtils.isBlockLiquid(this.f_19853_.m_8055_(new BlockPos(x, y, z)).m_60734_())) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.securityUpgradeCount == 2) {
                        this.displacedLiquids.put(pos, this.f_19853_.m_8055_(pos));
                    }
                    this.f_19853_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    public boolean m_20164_() {
        return this.m_20184_().m_7098_() < 0.0;
    }

    public boolean m_6040_() {
        return this.securityUpgradeCount > 0;
    }

    @Override
    public BlockPos getTargetedBlock() {
        BlockPos pos = (BlockPos)this.f_19804_.m_135370_(TARGET_POS);
        return pos.equals((Object)BlockPos.f_121853_) ? null : pos;
    }

    private void setTargetedBlock(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)(pos == null ? BlockPos.f_121853_ : pos));
    }

    @Override
    public int getLaserColor() {
        Component name = this.m_8077_() ? this.m_7770_() : this.ownerName;
        return LASER_COLOR_MAP.getOrDefault(name, super.getLaserColor());
    }

    @Override
    public BlockPos getDugBlock() {
        BlockPos pos = (BlockPos)this.f_19804_.m_135370_(DUG_POS);
        return pos.equals((Object)BlockPos.f_121853_) ? null : pos;
    }

    @Override
    public ItemStack getDroneHeldItem() {
        return (Boolean)ConfigHelper.common().drones.dronesRenderHeldItem.get() != false ? (ItemStack)this.f_19804_.m_135370_(HELD_ITEM) : ItemStack.f_41583_;
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        this.f_19804_.m_135381_(DUG_POS, (Object)(pos == null ? BlockPos.f_121853_ : pos));
    }

    public List<DroneAIManager.WrappedGoal> getRunningTasks() {
        return this.aiManager.getRunningTasks();
    }

    public Goal getRunningTargetAI() {
        return this.aiManager.getTargetAI();
    }

    public void setVariable(String varName, BlockPos pos) {
        this.aiManager.setCoordinate(varName, pos);
    }

    public Optional<BlockPos> getVariable(String varName) {
        return this.aiManager.getCoordinate(this.ownerUUID, varName);
    }

    private ResourceLocation getActiveProgramKey() {
        return new ResourceLocation((String)this.f_19804_.m_135370_(PROGRAM_KEY));
    }

    @Override
    public int getActiveWidgetIndex() {
        return (Integer)this.f_19804_.m_135370_(ACTIVE_WIDGET);
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.f_19804_.m_135381_(PROGRAM_KEY, (Object)widget.getTypeID().toString());
        this.f_19804_.m_135381_(ACTIVE_WIDGET, (Object)this.getActiveAIManager().widgets().indexOf(widget));
    }

    private void setAccelerating(boolean accelerating) {
        this.f_19804_.m_135381_(ACCELERATING, (Object)accelerating);
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.f_19804_.m_135370_(ACCELERATING);
    }

    private void setDroneColor(int color) {
        this.f_19804_.m_135381_(DRONE_COLOR, (Object)color);
    }

    @Override
    public int getDroneColor() {
        return (Integer)this.f_19804_.m_135370_(DRONE_COLOR);
    }

    private void setMinigunActivated(boolean activated) {
        this.f_19804_.m_135381_(MINIGUN_ACTIVE, (Object)activated);
    }

    private boolean isMinigunActivated() {
        return (Boolean)this.f_19804_.m_135370_(MINIGUN_ACTIVE);
    }

    private void setHasMinigun(boolean hasMinigun) {
        this.f_19804_.m_135381_(HAS_MINIGUN, (Object)hasMinigun);
    }

    @Override
    public boolean hasMinigun() {
        return (Boolean)this.f_19804_.m_135370_(HAS_MINIGUN);
    }

    public int getAmmoColor() {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    private void setAmmoColor(ItemStack ammoStack) {
        int n;
        Item item = ammoStack.m_41720_();
        if (item instanceof AbstractGunAmmoItem) {
            AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
            n = ammo.getAmmoColor(ammoStack);
        } else {
            n = -65536;
        }
        int color = n;
        this.f_19804_.m_135381_(AMMO, (Object)color);
    }

    @Override
    public BlockPos getDeployPos() {
        return this.deployPos;
    }

    public void setDeployPos(BlockPos deployPos) {
        if (this.deployPos != null) {
            throw new IllegalStateException("deployPos has already been set!");
        }
        this.deployPos = deployPos;
    }

    protected int m_7302_(int par1) {
        return -20;
    }

    public void m_7023_(Vec3 travelVec) {
        if (this.f_19853_.f_46443_) {
            LivingEntity targetEntity = this.m_5448_();
            if (targetEntity != null && !targetEntity.m_6084_()) {
                this.m_6710_(null);
                targetEntity = null;
            }
            if (targetEntity != null) {
                if (this.targetLine == null) {
                    this.targetLine = new ProgressingLine(0.0f, this.m_20206_() / 2.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (this.oldTargetLine == null) {
                    this.oldTargetLine = new ProgressingLine(0.0f, this.m_20206_() / 2.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                this.targetLine.endX = (float)(targetEntity.m_20185_() - this.m_20185_());
                this.targetLine.endY = (float)(targetEntity.m_20186_() + (double)(targetEntity.m_20206_() / 2.0f) - this.m_20186_());
                this.targetLine.endZ = (float)(targetEntity.m_20189_() - this.m_20189_());
                this.oldTargetLine.endX = (float)(targetEntity.f_19854_ - this.f_19854_);
                this.oldTargetLine.endY = (float)(targetEntity.f_19855_ + (double)(targetEntity.m_20206_() / 2.0f) - this.f_19855_);
                this.oldTargetLine.endZ = (float)(targetEntity.f_19856_ - this.f_19856_);
                this.oldTargetLine.setProgress(this.targetLine.getProgress());
                this.targetLine.incProgressByDistance(0.2);
                this.f_19811_ = true;
            } else {
                this.oldTargetLine = null;
                this.targetLine = null;
                this.f_19811_ = false;
            }
        }
        if (this.m_20202_() == null && this.isAccelerating()) {
            double d3 = this.m_20184_().f_82480_;
            super.m_7023_(travelVec);
            this.m_20334_(this.m_20184_().f_82479_, d3 * 0.6, this.m_20184_().f_82481_);
        } else {
            super.m_7023_(travelVec);
        }
        this.f_19861_ = true;
    }

    public ProgressingLine getTargetLine() {
        return this.targetLine;
    }

    public ProgressingLine getOldTargetLine() {
        return this.oldTargetLine;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.getOwnerUUID().equals(player.m_20148_())) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ModItems.GPS_TOOL.get()) {
            if (!this.f_19853_.f_46443_) {
                return GPSToolItem.getGPSLocation(player.m_20148_(), stack).map(gpsPos -> {
                    this.m_21573_().m_26519_((double)gpsPos.m_123341_(), (double)gpsPos.m_123342_(), (double)gpsPos.m_123343_(), 0.1);
                    return InteractionResult.SUCCESS;
                }).orElse(InteractionResult.PASS);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            if (player.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            return (InteractionResult)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
                if (handler.getFluidInTank(0).isEmpty()) {
                    boolean ok = player.f_19853_.f_46443_ || FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidTank);
                    return ok ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.PASS;
            }).orElseThrow(RuntimeException::new);
        }
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            if (!this.f_19853_.f_46443_) {
                this.setDroneColor(color.m_41060_());
                if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.m_7500_()) {
                    stack.m_41774_(1);
                    if (stack.m_41613_() <= 0) {
                        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean shouldDropAsItem() {
        return true;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (this.shouldDropAsItem()) {
            this.m_6469_(new PNCDamageSource.DamageSourceDroneOverload("wrenched", new Object[0]), 2000.0f);
            return true;
        }
        return false;
    }

    private void restoreFluidBlocks(boolean distCheck) {
        Iterator<Map.Entry<BlockPos, BlockState>> iter = this.displacedLiquids.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BlockPos, BlockState> entry = iter.next();
            BlockPos pos = entry.getKey();
            if (distCheck && !(pos.m_203198_(this.m_20185_(), this.m_20186_(), this.m_20189_()) > 1.0)) continue;
            if (this.f_19853_.m_46859_(pos) || PneumaticCraftUtils.isBlockLiquid(this.f_19853_.m_8055_(pos).m_60734_())) {
                this.f_19853_.m_7731_(pos, entry.getValue(), 3);
            }
            iter.remove();
        }
    }

    @Nullable
    public Entity changeDimension(ServerLevel p_241206_1_, ITeleporter teleporter) {
        Entity entity = super.changeDimension(p_241206_1_, teleporter);
        if (entity != null) {
            this.restoreFluidBlocks(false);
        }
        return entity;
    }

    protected void m_5907_() {
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            if (this.droneItemHandler.getStackInSlot(i).m_41619_()) continue;
            this.m_5552_(this.droneItemHandler.getStackInSlot(i), 0.0f);
            this.droneItemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        for (Entity e : this.m_20197_()) {
            if (!(e instanceof Mob)) continue;
            Mob mob = (Mob)e;
            mob.m_21557_(this.carriedEntityAIdisabled);
        }
        this.restoreFluidBlocks(false);
        if (this.shouldDropAsItem()) {
            ItemStack stack = new ItemStack((ItemLike)this.getDroneItem());
            this.writeToItemStack(stack);
            this.m_5552_(stack, 0.0f);
            if (!this.f_19853_.f_46443_) {
                this.reportDroneDeath(this.getOwner(), damageSource);
            }
        }
        if (!this.f_19853_.f_46443_ && this.getDugBlock() != null) {
            this.getFakePlayer().f_8941_.m_214168_(this.getDugBlock(), ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.UP, 0, 0);
        }
        this.m_6593_((Component)Component.m_237119_());
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private void reportDroneDeath(Player owner, DamageSource damageSource) {
        if (owner != null) {
            int x = (int)Math.floor(this.m_20185_());
            int y = (int)Math.floor(this.m_20186_());
            int z = (int)Math.floor(this.m_20189_());
            MutableComponent msg = this.m_8077_() ? Component.m_237110_((String)"pneumaticcraft.death.drone.named", (Object[])new Object[]{Objects.requireNonNull(this.m_7770_()).getString(), x, y, z}) : Component.m_237110_((String)"pneumaticcraft.death.drone", (Object[])new Object[]{x, y, z});
            msg = msg.m_6879_().m_130946_(" - ").m_7220_(damageSource.m_6157_((LivingEntity)this));
            owner.m_5661_((Component)msg, false);
        }
    }

    private Item getDroneItem() {
        return PneumaticCraftUtils.getRegistryName(ForgeRegistries.ENTITY_TYPES, this.m_6095_()).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).orElseThrow();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (this.f_19853_.f_46443_) {
            if (TARGET_ID.equals(key)) {
                Entity e;
                int id = (Integer)this.f_19804_.m_135370_(TARGET_ID);
                if (id > 0 && (e = this.m_20193_().m_6815_(id)) instanceof LivingEntity) {
                    this.m_6710_((LivingEntity)e);
                }
                if (this.targetLine != null && this.oldTargetLine != null) {
                    this.targetLine.setProgress(0.0f);
                    this.oldTargetLine.setProgress(0.0f);
                }
            } else if (PRESSURE.equals(key)) {
                int newAir = (int)(((Float)this.f_19804_.m_135370_(PRESSURE)).floatValue() * (float)this.getAirHandler().getVolume());
                this.getAirHandler().addAir(newAir - this.airHandler.getAir());
            }
        }
        super.m_7350_(key);
    }

    public void m_6710_(LivingEntity entity) {
        super.m_6710_(entity);
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(TARGET_ID, (Object)(entity == null ? 0 : entity.m_19879_()));
        }
    }

    public boolean m_7998_(Entity entity, boolean force) {
        return (Boolean)ConfigHelper.common().drones.dronesCanBePickedUp.get() != false && super.m_7998_(entity, force);
    }

    protected BasicAirHandler getAirHandler() {
        if (this.airHandler == null) {
            int vol = PressureHelper.getUpgradedVolume(12000, this.getUpgrades((PNCUpgrade)ModUpgrades.VOLUME.get()));
            ItemStack stack = new ItemStack((ItemLike)this.getDroneItem());
            EnchantmentHelper.m_44865_(this.stackEnchants, (ItemStack)stack);
            vol = ItemRegistry.getInstance().getModifiedVolume(stack, vol);
            this.airHandler = new BasicAirHandler(vol);
        }
        return this.airHandler;
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        if (this.m_8077_()) {
            curInfo.add((Component)this.getDroneName().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        } else {
            curInfo.add((Component)this.getDroneName().m_6881_().m_130940_(ChatFormatting.AQUA));
        }
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.tamed", this.getOwnerName().getString()));
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(this.getAirHandler().getPressure(), 2)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        WidgetSerializer.putWidgetsToNBT(this.progWidgets, tag);
        tag.m_128365_("airHandler", (Tag)this.getAirHandler().serializeNBT());
        tag.m_128350_("propSpeed", this.propSpeed);
        if (this.disabledByHacking) {
            tag.m_128379_("disabledByHacking", true);
        }
        if (this.gotoOwnerAI != null) {
            tag.m_128379_("hackedByOwner", true);
        }
        if (this.standby) {
            tag.m_128379_("standby", true);
        }
        if (this.carriedEntityAIdisabled) {
            tag.m_128379_("carriedEntityAIdisabled", true);
        }
        tag.m_128405_(NBT_DRONE_COLOR, this.getDroneColor());
        tag.m_128365_("variables", (Tag)this.aiManager.writeToNBT(new CompoundTag()));
        if (this.deployPos != null) {
            tag.m_128365_("deployPos", (Tag)NbtUtils.m_129224_((BlockPos)this.deployPos));
        }
        ItemStackHandler tmpHandler = new ItemStackHandler(this.droneItemHandler.getSlots());
        PneumaticCraftUtils.copyItemHandler((IItemHandler)this.droneItemHandler, tmpHandler, this.droneItemHandler.getSlots());
        tag.m_128365_("Inventory", (Tag)tmpHandler.serializeNBT());
        tag.m_128365_("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT());
        this.fluidTank.writeToNBT(tag);
        tag.m_128359_("owner", this.ownerName.getString());
        if (this.ownerUUID != null) {
            tag.m_128356_("ownerUUID_M", this.ownerUUID.getMostSignificantBits());
            tag.m_128356_("ownerUUID_L", this.ownerUUID.getLeastSignificantBits());
        }
        if (!this.stackEnchants.isEmpty()) {
            CompoundTag eTag = new CompoundTag();
            this.stackEnchants.forEach((ench, lvl) -> PneumaticCraftUtils.getRegistryName(ForgeRegistries.ENCHANTMENTS, ench).ifPresent(regName -> eTag.m_128405_(regName.toString(), lvl.intValue())));
            tag.m_128365_("stackEnchants", (Tag)eTag);
        }
        if (!this.displacedLiquids.isEmpty()) {
            ListTag disp = new ListTag();
            for (Map.Entry<BlockPos, BlockState> entry : this.displacedLiquids.entrySet()) {
                CompoundTag p = NbtUtils.m_129224_((BlockPos)entry.getKey());
                CompoundTag s = NbtUtils.m_129202_((BlockState)entry.getValue());
                ListTag l = new ListTag();
                l.add(0, (Tag)p);
                l.add(1, (Tag)s);
                disp.add(0, (Tag)l);
            }
            tag.m_128365_("displacedLiquids", (Tag)disp);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.progWidgets = WidgetSerializer.getWidgetsFromNBT(tag);
        ProgrammerBlockEntity.updatePuzzleConnections(this.progWidgets);
        this.propSpeed = tag.m_128457_("propSpeed");
        this.disabledByHacking = tag.m_128471_("disabledByHacking");
        this.setGoingToOwner(tag.m_128471_("hackedByOwner"));
        this.setDroneColor(tag.m_128451_(NBT_DRONE_COLOR));
        this.aiManager.readFromNBT(tag.m_128469_("variables"));
        this.standby = tag.m_128471_("standby");
        this.upgradeInventory.deserializeNBT(tag.m_128469_("UpgradeInventory"));
        this.upgradeCache.invalidateCache();
        this.getAirHandler().deserializeNBT(tag.m_128469_("airHandler"));
        this.carriedEntityAIdisabled = tag.m_128471_("carriedEntityAIdisabled");
        this.deployPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("deployPos"));
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(tag.m_128469_("Inventory"));
        PneumaticCraftUtils.copyItemHandler((IItemHandler)tmpInv, this.droneItemHandler);
        this.droneItemHandler.setUseableSlots(1 + this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get()));
        this.fluidTank.setCapacity(16000 * (1 + this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get())));
        this.fluidTank.readFromNBT(tag);
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades((PNCUpgrade)ModUpgrades.VOLUME.get()));
        if (tag.m_128441_("owner")) {
            this.ownerName = Component.m_237113_((String)tag.m_128461_("owner"));
        }
        if (tag.m_128441_("ownerUUID_M")) {
            this.ownerUUID = new UUID(tag.m_128454_("ownerUUID_M"), tag.m_128454_("ownerUUID_L"));
        }
        if (tag.m_128425_("stackEnchants", 10)) {
            CompoundTag eTag = tag.m_128469_("stackEnchants");
            for (String name : eTag.m_128431_()) {
                Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
                if (e == null) continue;
                this.stackEnchants.put(e, eTag.m_128451_(name));
            }
        }
        if (tag.m_128441_("displacedLiquids")) {
            for (Tag inbt : tag.m_128437_("displacedLiquids", 9)) {
                ListTag l = (ListTag)inbt;
                CompoundTag p = l.m_128728_(0);
                CompoundTag s = l.m_128728_(1);
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)p);
                BlockState state = NbtUtils.m_129241_((CompoundTag)s);
                this.displacedLiquids.put(pos, state);
            }
        }
    }

    @Override
    public Component getOwnerName() {
        return this.ownerName;
    }

    @Override
    public UUID getOwnerUUID() {
        if (this.ownerUUID == null) {
            Log.warning("Drone with owner '%s' has no UUID! Substituting the Drone's UUID (%s).", this.ownerName, this.m_20148_());
            Log.warning("If you use any protection mods, the drone might not be able to operate in protected areas.", new Object[0]);
            this.ownerUUID = this.m_20148_();
        }
        return this.ownerUUID;
    }

    @Override
    public int getUpgrades(PNCUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    @Override
    public FakePlayer getFakePlayer() {
        if (this.fakePlayer == null && !this.f_19853_.f_46443_) {
            this.fakePlayer = new DroneFakePlayer((ServerLevel)this.f_19853_, new GameProfile(this.getOwnerUUID(), this.ownerName.getString()), this);
        }
        return this.fakePlayer;
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunDrone(this.f_19853_.f_46443_ ? null : this.getFakePlayer()).setWorld(this.f_19853_).setAirHandler((LazyOptional<? extends IAirHandler>)this.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY), 200);
        }
        return this.minigun;
    }

    public boolean m_7327_(Entity entity) {
        LivingEntity livingEntity;
        this.getFakePlayer().m_5706_(entity);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_() && livingEntity.m_21188_() == this.getFakePlayer()) {
            livingEntity.m_6703_((LivingEntity)this);
        }
        this.getAirHandler().addAir(-200);
        return true;
    }

    public int m_21230_() {
        return this.getUpgrades((PNCUpgrade)ModUpgrades.ARMOR.get());
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (damageSource == DamageSource.f_19310_ && this.suffocationCounter > 0) {
            --this.suffocationCounter;
        }
        return super.m_6469_(damageSource, damage);
    }

    public boolean m_6673_(DamageSource source) {
        Entity e;
        if (source == DamageSource.f_19310_) {
            return this.suffocationCounter > 0 || (Boolean)ConfigHelper.common().drones.enableDroneSuffocation.get() == false;
        }
        if (RadiationSourceCheck.INSTANCE.isRadiation(source)) {
            return true;
        }
        if (source instanceof EntityDamageSource && (e = source.m_7639_()) != null && !this.f_19853_.f_46443_ && e.m_19879_() == this.getFakePlayer().m_19879_()) {
            return true;
        }
        return super.m_6673_(source);
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.droneItemHandler;
    }

    public int getEmittingRedstone(Direction side) {
        return this.emittingRedstoneValues.getOrDefault(side, 0);
    }

    @Override
    public void setEmittingRedstone(Direction side, int value) {
        if (this.emittingRedstoneValues.getOrDefault(side, 0) != value) {
            this.emittingRedstoneValues.put(side, value);
            BlockPos pos = new BlockPos((int)Math.floor(this.m_20185_() + (double)(this.m_20205_() / 2.0f)), (int)Math.floor(this.m_20186_()), (int)Math.floor(this.m_20189_() + (double)(this.m_20205_() / 2.0f)));
            BlockState state = this.f_19853_.m_8055_(pos);
            this.f_19853_.m_7260_(pos, state, state, 3);
        }
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        if (this.f_19853_.m_46859_(pos)) {
            return true;
        }
        BlockState state = this.f_19853_.m_8055_(pos);
        Block block = state.m_60734_();
        if (PneumaticCraftUtils.isBlockLiquid(block)) {
            return this.securityUpgradeCount > 0;
        }
        if (DroneEntity.checkMC181565kludge(block)) {
            return false;
        }
        if (state.m_60647_((BlockGetter)this.f_19853_, pos, PathComputationType.LAND)) {
            return true;
        }
        if (!state.m_60767_().m_76334_() && block != Blocks.f_50155_) {
            return true;
        }
        if (DroneRegistry.getInstance().pathfindableBlocks.containsKey(block)) {
            IPathfindHandler pathfindHandler = DroneRegistry.getInstance().pathfindableBlocks.get(block);
            return pathfindHandler == null || pathfindHandler.canPathfindThrough(this.f_19853_, pos);
        }
        return false;
    }

    private static boolean checkMC181565kludge(Block block) {
        return MC181565_BLOCKS.contains(block);
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
        NetworkHandler.sendToAllTracking((Object)new PacketShowWireframe(this, pos), (Entity)this);
    }

    @Override
    public ResourceLocation getHackableId() {
        return PneumaticRegistry.RL("drone");
    }

    @Override
    @NotNull
    public Class<DroneEntity> getHackableClass() {
        return DroneEntity.class;
    }

    @Override
    public boolean canHack(Entity entity, Player player) {
        if (!IHackableEntity.super.canHack(entity, player)) {
            return false;
        }
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.upgradeUsable(CommonUpgradeHandlers.hackHandler, false) && handler.getUpgradeCount(EquipmentSlot.HEAD, (PNCUpgrade)ModUpgrades.ENTITY_TRACKER.get()) >= 1;
    }

    @Override
    public void addHackInfo(DroneEntity entity, List<Component> curInfo, Player player) {
        if (this.ownerUUID.equals(player.m_20148_())) {
            if (this.isGoingToOwner()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.resumeTasks", new Object[0]));
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.callBack", new Object[0]));
            }
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.disable", new Object[0]));
        }
    }

    @Override
    public void addPostHackInfo(DroneEntity entity, List<Component> curInfo, Player player) {
        if (this.ownerUUID.equals(player.m_20148_())) {
            if (this.isGoingToOwner()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.calledBack", new Object[0]));
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.resumedTasks", new Object[0]));
            }
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.disabled", new Object[0]));
        }
    }

    @Override
    public int getHackTime(DroneEntity entity, Player player) {
        return this.ownerUUID.equals(player.m_20148_()) ? 20 : 100;
    }

    @Override
    public void onHackFinished(DroneEntity entity, Player player) {
        if (!this.f_19853_.f_46443_ && player.m_20148_().equals(this.ownerUUID)) {
            this.setGoingToOwner(this.gotoOwnerAI == null);
        } else {
            this.disabledByHacking = true;
        }
    }

    @Override
    public boolean afterHackTick(DroneEntity entity) {
        return false;
    }

    private void setGoingToOwner(boolean state) {
        if (!this.f_19853_.f_46443_) {
            if (state && this.gotoOwnerAI == null) {
                this.gotoOwnerAI = new DroneGoToOwner(this);
                this.f_21345_.m_25352_(2, (Goal)this.gotoOwnerAI);
                this.f_19804_.m_135381_(GOING_TO_OWNER, (Object)true);
                this.setActiveProgram(new ProgWidgetGoToLocation());
            } else if (!state && this.gotoOwnerAI != null) {
                this.f_21345_.m_25363_((Goal)this.gotoOwnerAI);
                this.gotoOwnerAI = null;
                this.f_19804_.m_135381_(GOING_TO_OWNER, (Object)false);
            }
        }
    }

    private boolean isGoingToOwner() {
        return (Boolean)this.f_19804_.m_135370_(GOING_TO_OWNER);
    }

    @Override
    public IFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public Player getOwner() {
        MinecraftServer server = this.f_19853_.m_7654_();
        return server != null ? server.m_6846_().m_11259_(this.ownerUUID) : null;
    }

    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    @Override
    public Level world() {
        return this.f_19853_;
    }

    @Override
    public Vec3 getDronePos() {
        return this.m_20182_();
    }

    @Override
    public BlockPos getControllerPos() {
        return BlockPos.f_121853_;
    }

    @Override
    public void dropItem(ItemStack stack) {
        this.m_5552_(stack, 0.0f);
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public GoalSelector getTargetAI() {
        return this.f_21346_;
    }

    @Override
    public boolean isProgramApplicable(ProgWidgetType<?> widgetType) {
        return true;
    }

    @Override
    public void setName(Component string) {
        this.m_6593_(string);
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        if (entity == null) {
            for (Entity e : this.getCarryingEntities()) {
                e.m_8127_();
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_21557_(this.carriedEntityAIdisabled);
                }
                this.checkForMinecartKludge(e);
            }
        } else if (entity.m_20329_((Entity)this) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.carriedEntityAIdisabled = mob.m_21525_();
            mob.m_21557_(true);
        }
    }

    private void checkForMinecartKludge(Entity e) {
        double y = e.m_20186_();
        if (((Boolean)ConfigHelper.common().drones.dronesCanBePickedUp.get()).booleanValue() && (e instanceof AbstractMinecart || e instanceof Boat)) {
            y -= 2.0;
            BlockPos pos = e.m_20183_();
            if (this.f_19853_.m_8055_(pos).m_60796_((BlockGetter)this.f_19853_, pos)) {
                y += 1.0;
            }
            if (e instanceof AbstractMinecart) {
                ((EntityAccess)e).setBoardingCooldown(0);
            }
        }
        if (y != e.m_20186_()) {
            e.m_6034_(e.m_20185_(), y, e.m_20189_());
        }
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return this.m_20197_();
    }

    @Override
    public boolean isAIOverridden() {
        return this.chargeAI.isExecuting || this.gotoOwnerAI != null;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
        this.m_7938_((Entity)curPickingUpEntity, stackSize);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return (IPathNavigator)this.m_21573_();
    }

    public void tryFireMinigun(LivingEntity target) {
        int slot = this.getSlotForAmmo();
        if (slot >= 0) {
            ItemStack ammo = this.droneItemHandler.getStackInSlot(slot);
            if (this.getMinigun().setAmmoStack(ammo).tryFireMinigun((Entity)target)) {
                this.droneItemHandler.setStackInSlot(slot, ItemStack.f_41583_);
            }
        }
    }

    public int getSlotForAmmo() {
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            if (!(this.droneItemHandler.getStackInSlot(i).m_41720_() instanceof AbstractGunAmmoItem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        this.m_6469_(new PNCDamageSource.DamageSourceDroneOverload(msgKey, params), 2000.0f);
    }

    @Override
    public DroneAIManager getAIManager() {
        return this.aiManager;
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void playSound(SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
        this.f_19853_.m_5594_(null, this.m_20183_(), soundEvent, category, volume, pitch);
    }

    @Override
    public void addAirToDrone(int air) {
        this.airHandler.addAir(air);
    }

    @Override
    public void updateLabel() {
        this.f_19804_.m_135381_(LABEL, (Object)(this.getAIManager() != null ? this.getAIManager().getLabel() : "Main"));
    }

    @Override
    public String getLabel() {
        return (String)this.f_19804_.m_135370_(LABEL);
    }

    @Override
    public boolean isTeleportRangeLimited() {
        return true;
    }

    @Override
    public Component getDroneName() {
        return this.m_7755_();
    }

    @Override
    public DroneDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public void storeTrackerData(ItemStack stack) {
        NBTUtils.setInteger(stack, "debuggingDrone", this.m_19879_());
        NBTUtils.removeTag(stack, "debuggingPC");
    }

    @Override
    public IItemHandler getUpgradeHandler() {
        return this.upgradeInventory;
    }

    @Override
    public void onUpgradesChanged() {
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades((PNCUpgrade)ModUpgrades.VOLUME.get()));
    }

    @Override
    public boolean isDroneStillValid() {
        return this.m_6084_();
    }

    @Override
    public boolean canMoveIntoFluid(Fluid fluid) {
        if (fluid.getFluidType().getTemperature() > 373) {
            return false;
        }
        return this.m_6040_();
    }

    @Override
    public DroneItemHandler getDroneItemHandler() {
        return this.droneItemHandler;
    }

    public boolean addProgram(BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack droneStack, List<IProgWidget> progWidgets) {
        return false;
    }

    public void incAttackCount() {
        ++this.attackCount;
    }

    public int getAttackCount() {
        return this.attackCount;
    }

    @Override
    public void resetAttackCount() {
        this.attackCount = 0;
    }

    @Override
    public float getDronePressure() {
        return ((IAirHandler)this.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).orElseThrow(RuntimeException::new)).getPressure();
    }

    public void setDroneSpeed(double droneSpeed) {
        this.droneSpeed = droneSpeed;
    }

    public double getDroneSpeed() {
        return this.droneSpeed;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    static {
        LASER_COLOR_MAP.put((Component)Component.m_237113_((String)"aureylian"), 16738740);
        LASER_COLOR_MAP.put((Component)Component.m_237113_((String)"loneztar"), 41120);
        LASER_COLOR_MAP.put((Component)Component.m_237113_((String)"jadedcat"), 10494192);
        LASER_COLOR_MAP.put((Component)Component.m_237113_((String)"desht"), 0xFF6000);
        MC181565_BLOCKS = Set.of(Blocks.f_152492_, Blocks.f_152482_, Blocks.f_50196_, Blocks.f_152545_, Blocks.f_152588_, Blocks.f_50578_, Blocks.f_152541_, Blocks.f_50719_);
    }

    private class EntityDroneItemHandler
    extends DroneItemHandler {
        EntityDroneItemHandler(IDrone holder) {
            super(holder, 1);
        }

        @Override
        public void copyItemToFakePlayer(int slot) {
            super.copyItemToFakePlayer(slot);
            if (this.isFakePlayerReady() && slot == DroneEntity.this.getFakePlayer().m_150109_().f_35977_ && ((Boolean)ConfigHelper.common().drones.dronesRenderHeldItem.get()).booleanValue()) {
                DroneEntity.this.f_19804_.m_135381_(HELD_ITEM, (Object)this.getStackInSlot(slot));
            }
        }
    }

    public class MinigunDrone
    extends Minigun {
        MinigunDrone(FakePlayer fakePlayer) {
            super((Player)fakePlayer, true);
        }

        @Override
        public PacketPlayMovingSound.MovingSoundFocus getSoundSource() {
            return PacketPlayMovingSound.MovingSoundFocus.of((Entity)DroneEntity.this);
        }

        @Override
        public boolean isMinigunActivated() {
            return DroneEntity.this.isMinigunActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            if (!this.world.f_46443_) {
                DroneEntity.this.setMinigunActivated(activated);
            }
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!this.world.f_46443_) {
                DroneEntity.this.setAmmoColor(ammo);
            }
        }

        @Override
        public int getAmmoColor() {
            return DroneEntity.this.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            this.world.m_5594_(null, DroneEntity.this.m_20183_(), soundName, SoundSource.NEUTRAL, volume, pitch);
        }

        @Override
        public Vec3 getMuzzlePosition() {
            Vec3 centre = DroneEntity.this.m_20182_();
            LivingEntity target = DroneEntity.this.minigun.getAttackTarget();
            if (target == null) {
                return null;
            }
            Vec3 offset = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(centre).m_82541_().m_82490_(0.6);
            return centre.m_82549_(offset);
        }

        @Override
        public Vec3 getLookAngle() {
            return Vec3.m_82498_((float)this.minigunPitch, (float)this.minigunYaw).m_82541_();
        }

        @Override
        public float getParticleScale() {
            return 1.0f;
        }

        @Override
        public boolean isValid() {
            return DroneEntity.this.m_6084_();
        }
    }
}

