/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeCylinder
extends AreaType {
    public static final String ID = "cylinder";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;
    private EnumCylinderType cylinderType = EnumCylinderType.FILLED;

    public AreaTypeCylinder() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.cylinderType + "/" + this.axis;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                double rad = PneumaticCraftUtils.distBetween(p1.m_123342_(), (double)p1.m_123343_(), (double)p2.m_123342_(), (double)p2.m_123343_());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minY = (int)((double)p1.m_123342_() - rad - 1.0);
                minZ = (int)((double)p1.m_123343_() - rad - 1.0);
                maxY = (int)((double)p1.m_123342_() + rad + 1.0);
                maxZ = (int)((double)p1.m_123343_() + rad + 1.0);
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.m_123342_(), (double)p1.m_123343_(), (double)y, (double)z);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int x = minX; x <= maxX; ++x) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != EnumCylinderType.FILLED && (this.cylinderType != EnumCylinderType.HOLLOW || x != minX && x != maxX)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case Y: {
                double rad = PneumaticCraftUtils.distBetween(p1.m_123341_(), (double)p1.m_123343_(), (double)p2.m_123341_(), (double)p2.m_123343_());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minX = (int)((double)p1.m_123341_() - rad - 1.0);
                minZ = (int)((double)p1.m_123343_() - rad - 1.0);
                maxX = (int)((double)p1.m_123341_() + rad + 1.0);
                maxZ = (int)((double)p1.m_123343_() + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.m_123341_(), (double)p1.m_123343_(), (double)x, (double)z);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int y = minY; y <= maxY; ++y) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != EnumCylinderType.FILLED && (this.cylinderType != EnumCylinderType.HOLLOW || y != minY && y != maxY)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case Z: {
                double rad = PneumaticCraftUtils.distBetween(p1.m_123341_(), (double)p1.m_123342_(), (double)p2.m_123341_(), (double)p2.m_123342_());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minX = (int)((double)p1.m_123341_() - rad - 1.0);
                minY = (int)((double)p1.m_123342_() - rad - 1.0);
                maxX = (int)((double)p1.m_123341_() + rad + 1.0);
                maxY = (int)((double)p1.m_123342_() + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.m_123341_(), (double)p1.m_123342_(), (double)x, (double)y);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != EnumCylinderType.FILLED && (this.cylinderType != EnumCylinderType.HOLLOW || z != minZ && z != maxZ)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumCylinderType>("pneumaticcraft.gui.progWidget.area.type.cylinder.cylinderType", EnumCylinderType.class, () -> this.cylinderType, cylinderType -> {
            this.cylinderType = cylinderType;
        }));
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("axis", (byte)this.axis.ordinal());
        tag.m_128344_("cylinderType", (byte)this.cylinderType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.m_128445_("axis")];
        this.cylinderType = EnumCylinderType.values()[tag.m_128445_("cylinderType")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.axis.ordinal());
        buffer.writeByte(this.cylinderType.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = AreaType.EnumAxis.values()[buf.readByte()];
        this.cylinderType = EnumCylinderType.values()[buf.readByte()];
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_CYLINDER: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_CYLINDER: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_CYLINDER: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static enum EnumCylinderType {
        FILLED("filled"),
        HOLLOW("hollow"),
        TUBE("tube");

        private final String name;

        private EnumCylinderType(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.cylinder.cylinderType." + name;
        }

        public String toString() {
            return I18n.m_118938_((String)this.name, (Object[])new Object[0]);
        }
    }
}

