/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.CompressedIronBlockBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;

public class HeatSinkBlockEntity
extends CompressedIronBlockBlockEntity {
    private final IHeatExchangerLogic airExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private double ambientTemp;

    public HeatSinkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.HEAT_SINK.get()), pos, state);
        this.heatExchanger.setThermalCapacity(5.0);
        this.airExchanger.addConnectedExchanger(this.heatExchanger);
        this.airExchanger.setThermalResistance(14.0);
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.nonNullLevel().f_46443_) {
            this.ambientTemp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)this.m_58904_(), this.m_58899_());
            this.airExchanger.setTemperature(this.ambientTemp);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("airExchanger", (Tag)this.airExchanger.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.airExchanger.deserializeNBT(tag.m_128469_("airExchanger"));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.airExchanger.tick();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    public void onFannedByAirGrate() {
        this.heatExchanger.tick();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return side == null || side == this.getRotation() ? super.getHeatCap(side) : LazyOptional.empty();
    }
}

