/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.block.OmnidirectionalHopperBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class AbstractHopperBlockEntity<T extends BlockEntity>
extends AbstractTickingBlockEntity
implements IRedstoneControl<T>,
IComparatorSupport,
MenuProvider {
    private static final int BASE_TICK_RATE = 8;
    private int lastComparatorValue = -1;
    private int cooldown;
    private int entityScanCooldown;
    @GuiSynced
    int leaveMaterialCount;
    @DescSynced
    public boolean isCreative;
    private boolean wasCreative = false;
    Direction inputDir = Direction.UP;
    AABB inputAABB;
    AABB outputAABB;
    final List<Entity> cachedInputEntities = new ArrayList<Entity>();
    final List<Entity> cachedOutputEntities = new ArrayList<Entity>();

    AbstractHopperBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 4);
    }

    public Direction getInputDirection() {
        return (Direction)this.m_58900_().m_61143_(OmnidirectionalHopperBlock.INPUT_FACING);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.nonNullLevel().f_46443_) {
            this.isCreative = this.getUpgrades((PNCUpgrade)ModUpgrades.CREATIVE.get()) > 0;
            this.setupInputOutputRegions();
        }
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.inputDir = this.getInputDirection();
        this.setupInputOutputRegions();
    }

    @Override
    public void tickServer() {
        this.inputDir = this.getInputDirection();
        super.tickServer();
        if (this.getRedstoneController().shouldRun()) {
            if (--this.entityScanCooldown <= 0) {
                this.cachedInputEntities.clear();
                if (this.shouldScanForEntities(this.inputDir)) {
                    this.cachedInputEntities.addAll(this.nonNullLevel().m_6443_(Entity.class, this.inputAABB, EntitySelector.f_20402_));
                }
                this.cachedOutputEntities.clear();
                if (this.shouldScanForEntities(this.getRotation())) {
                    this.cachedOutputEntities.addAll(this.nonNullLevel().m_6443_(Entity.class, this.outputAABB, EntitySelector.f_20402_));
                }
                this.entityScanCooldown = 8;
            }
            if (--this.cooldown <= 0) {
                int maxItems = this.getMaxItems();
                boolean success = this.doImport(maxItems);
                int n = this.cooldown = (success |= this.doExport(maxItems)) ? this.getItemTransferInterval() : 8;
                if (this.lastComparatorValue != this.getComparatorValueInternal()) {
                    this.lastComparatorValue = this.getComparatorValueInternal();
                }
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        boolean rerender = this.wasCreative != this.isCreative;
        this.wasCreative = this.isCreative;
        return rerender;
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get());
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get()));
    }

    protected abstract void setupInputOutputRegions();

    protected abstract boolean doExport(int var1);

    protected abstract boolean doImport(int var1);

    protected abstract int getComparatorValueInternal();

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("leaveMaterialCount", this.leaveMaterialCount);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.leaveMaterialCount = tag.m_128441_("leaveMaterial") ? (int)((byte)(tag.m_128471_("leaveMaterial") ? 1 : 0)) : tag.m_128451_("leaveMaterialCount");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.getRedstoneController().parseRedstoneMode(tag)) {
            return;
        }
        switch (tag) {
            case "empty": {
                this.leaveMaterialCount = 0;
                break;
            }
            case "leave": {
                this.leaveMaterialCount = 1;
            }
        }
        this.m_6596_();
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterialCount > 0;
    }

    @Override
    public int getComparatorValue() {
        return this.getComparatorValueInternal();
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.isCreative = this.getUpgrades((PNCUpgrade)ModUpgrades.CREATIVE.get()) > 0;
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    List<ItemEntity> getNeighborItems(AABB aabb) {
        return aabb == null ? Collections.emptyList() : this.f_58857_.m_6443_(ItemEntity.class, aabb, EntitySelector.f_20402_);
    }

    abstract boolean shouldScanForEntities(Direction var1);
}

