/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.PneumaticDoorBaseBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.PneumaticDoorBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PneumaticDoorBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    public static final BooleanProperty TOP_DOOR = BooleanProperty.m_61465_((String)"top_door");

    public PneumaticDoorBlock() {
        super(ModBlocks.defaultProps());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_DOOR, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TOP_DOOR, DoorBlock.f_52727_});
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static boolean isTopDoor(BlockState state) {
        return state.m_60734_() == ModBlocks.PNEUMATIC_DOOR.get() && (Boolean)state.m_61143_((Property)TOP_DOOR) != false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.calculateVoxelShape(state, world, pos, 13);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.calculateVoxelShape(state, world, pos, 15);
    }

    private VoxelShape calculateVoxelShape(BlockState state, BlockGetter world, BlockPos pos, int thickness) {
        float xMin = 0.001f;
        float zMin = 0.001f;
        float xMax = 0.999f;
        float zMax = 0.999f;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PneumaticDoorBlockEntity) {
            PneumaticDoorBlockEntity door = (PneumaticDoorBlockEntity)te;
            Direction rotation = this.getRotation(state);
            float t = (float)thickness / 16.0f;
            float rads = (float)Math.toRadians(door.rotationAngle);
            float cosinus = t - Mth.m_14031_((float)rads) * t;
            float sinus = t - Mth.m_14089_((float)rads) * t;
            if (door.rightGoing) {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case WEST: {
                        xMin = cosinus;
                        zMin = sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMin = sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMax = 1.0f - sinus;
                    }
                }
            } else {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMin = sinus;
                        break;
                    }
                    case WEST: {
                        xMin = 0.001f + cosinus;
                        zMax = 0.999f - sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMin = sinus;
                    }
                }
            }
        }
        boolean topDoor = (Boolean)state.m_61143_((Property)TOP_DOOR);
        return Shapes.m_83064_((AABB)new AABB((double)xMin, topDoor ? -1.0 : 0.0, (double)zMin, (double)xMax, topDoor ? 1.0 : 2.0, (double)zMax));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)TOP_DOOR)).booleanValue()) {
            return world.m_8055_(pos.m_7495_()).m_60734_() == this;
        }
        return world.m_46859_(pos.m_7494_());
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity par5EntityLiving, ItemStack par6ItemStack) {
        super.m_6402_(world, pos, state, par5EntityLiving, par6ItemStack);
        world.m_7731_(pos.m_121945_(Direction.UP), (BlockState)world.m_8055_(pos).m_61124_((Property)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        world.m_141902_(pos, (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR.get()).ifPresent(teDoor -> {
            BlockPos top = pos.m_7494_();
            if (world.m_8055_(top.m_121945_(this.getRotation(state).m_122428_())).m_60734_() == ModBlocks.PNEUMATIC_DOOR_BASE.get()) {
                teDoor.rightGoing = true;
            } else if (world.m_8055_(top.m_121945_(this.getRotation(state).m_122427_())).m_60734_() == ModBlocks.PNEUMATIC_DOOR_BASE.get()) {
                teDoor.rightGoing = false;
            }
            BlockEntity topHalf = world.m_7702_(top);
            if (topHalf instanceof PneumaticDoorBlockEntity) {
                PneumaticDoorBlockEntity door = (PneumaticDoorBlockEntity)topHalf;
                door.rightGoing = teDoor.rightGoing;
                door.color = teDoor.color;
            }
        });
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos posDown = pos.m_7495_();
        BlockPos posUp = pos.m_7494_();
        if (PneumaticDoorBlock.isTopDoor(state) && worldIn.m_8055_(posDown).m_60734_() == this) {
            worldIn.m_7471_(posDown, false);
        } else if (!PneumaticDoorBlock.isTopDoor(state) && worldIn.m_8055_(posUp).m_60734_() == this) {
            worldIn.m_7471_(posUp, false);
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        BlockState state = world.m_8055_(pos);
        if (PneumaticDoorBlock.isTopDoor(state)) {
            return this.onWrenched(world, player, pos.m_121945_(Direction.DOWN), face, hand);
        }
        if (player != null && player.m_6144_()) {
            if (!player.m_7500_()) {
                BlockEntity te = world.m_7702_(pos);
                Block.m_49892_((BlockState)world.m_8055_(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)te);
                PneumaticDoorBlock.removeBlockSneakWrenched(world, pos);
                PneumaticDoorBlock.removeBlockSneakWrenched(world, pos.m_7494_());
            }
        } else {
            super.onWrenched(world, player, pos, face, hand);
            BlockState newState = world.m_8055_(pos);
            world.m_7731_(pos.m_121945_(Direction.UP), (BlockState)newState.m_61124_((Property)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        PneumaticDoorBaseBlockEntity doorBase = this.getDoorBase((BlockGetter)world, pos);
        if (!world.f_46443_) {
            DyeColor dyeColor = DyeColor.getColor((ItemStack)player.m_21120_(hand));
            if (dyeColor != null) {
                PneumaticDoorBlockEntity teDoor;
                BlockEntity te = world.m_7702_(PneumaticDoorBlock.isTopDoor(state) ? pos.m_7495_() : pos);
                if (te instanceof PneumaticDoorBlockEntity && (teDoor = (PneumaticDoorBlockEntity)te).setColor(dyeColor) && ((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue()) {
                    player.m_21120_(hand).m_41774_(1);
                }
            } else if (doorBase != null && doorBase.getRedstoneController().getCurrentMode() == 2 && doorBase.getPressure() >= doorBase.getMinWorkingPressure() && hand == InteractionHand.MAIN_HAND) {
                doorBase.setOpening(!doorBase.isOpening());
                doorBase.setNeighborOpening(doorBase.isOpening());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        boolean bl = powered = world.m_46755_(pos) > 0;
        if (!powered) {
            powered = world.m_46755_(pos.m_121945_(PneumaticDoorBlock.isTopDoor(state) ? Direction.DOWN : Direction.UP)) > 0;
        }
        PneumaticDoorBaseBlockEntity doorBase = this.getDoorBase((BlockGetter)world, pos);
        if (!world.f_46443_ && doorBase != null && doorBase.getPressure() >= 2.0f && powered != doorBase.wasPowered) {
            doorBase.wasPowered = powered;
            doorBase.setOpening(powered);
            doorBase.setNeighborOpening(doorBase.isOpening());
        }
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
    }

    private PneumaticDoorBaseBlockEntity getDoorBase(BlockGetter world, BlockPos pos) {
        PneumaticDoorBaseBlockEntity doorBase;
        PneumaticDoorBaseBlockEntity doorBase2;
        if (world.m_8055_(pos).m_60734_() != this) {
            return null;
        }
        if (!PneumaticDoorBlock.isTopDoor(world.m_8055_(pos))) {
            return this.getDoorBase(world, pos.m_121945_(Direction.UP));
        }
        Direction dir = this.getRotation(world, pos);
        if (dir.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        BlockEntity te1 = world.m_7702_(pos.m_121945_(dir.m_122427_()));
        if (te1 instanceof PneumaticDoorBaseBlockEntity && (doorBase2 = (PneumaticDoorBaseBlockEntity)te1).getRotation() == dir.m_122428_()) {
            return doorBase2;
        }
        BlockEntity te2 = world.m_7702_(pos.m_121945_(dir.m_122428_()));
        if (te2 instanceof PneumaticDoorBaseBlockEntity && (doorBase = (PneumaticDoorBaseBlockEntity)te2).getRotation() == dir.m_122427_()) {
            return doorBase;
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PneumaticDoorBlockEntity(pPos, pState);
    }

    public static class ItemBlockPneumaticDoor
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockPneumaticDoor(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            CompoundTag tag;
            if (tintIndex == 0 && (tag = stack.m_41737_("BlockEntityTag")) != null && tag.m_128425_("color", 3)) {
                int color = tag.m_128451_("color");
                return PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.m_41053_((int)color));
            }
            return -1;
        }
    }
}

