/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberValveBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class PressureChamberRenderer
implements BlockEntityRenderer<PressureChamberValveBlockEntity> {
    public PressureChamberRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(PressureChamberValveBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.multiBlockSize == 0 || !te.hasGlass) {
            return;
        }
        List<ItemStack> stacks = te.renderedItems;
        if (!stacks.isEmpty()) {
            double x = (double)(te.multiBlockX - te.m_58899_().m_123341_()) + (double)te.multiBlockSize / 2.0;
            double y = (double)(te.multiBlockY - te.m_58899_().m_123342_()) + 1.1;
            double z = (double)(te.multiBlockZ - te.m_58899_().m_123343_()) + (double)te.multiBlockSize / 2.0;
            int light = ClientUtils.getLightAt(new BlockPos(te.multiBlockX + te.multiBlockSize / 2, te.multiBlockY + 1, te.multiBlockZ + te.multiBlockSize / 2));
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(x, y, z);
            float circleRadius = stacks.size() == 1 ? 0.0f : 0.33f * (float)(te.multiBlockSize - 2);
            float degreesPerStack = 360.0f / (float)stacks.size();
            double ticks = (float)te.nonNullLevel().m_46467_() + partialTicks;
            float yBob = Mth.m_14031_((float)((float)ticks / 10.0f % 360.0f)) * 0.01f;
            float yRot = (float)(ticks / 2.0) % 360.0f;
            for (int i = 0; i < stacks.size(); ++i) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)i * degreesPerStack));
                matrixStackIn.m_85837_((double)circleRadius, (double)yBob + 0.2, 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel bakedModel = itemRenderer.m_174264_(stacks.get(i), te.m_58904_(), null, 0);
                itemRenderer.m_115143_(stacks.get(i), ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, light, combinedOverlayIn, bakedModel);
                matrixStackIn.m_85849_();
            }
            matrixStackIn.m_85849_();
        }
    }
}

