/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.ChestplateLauncherOptions;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChestplateLauncherHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.HumanoidArm;

public class ChestplateLauncherClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<ChestplateLauncherHandler> {
    public static final int MAX_PROGRESS = 15;
    private int launcherProgress = 0;

    public ChestplateLauncherClientHandler() {
        super(CommonUpgradeHandlers.chestplateLauncherHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new ChestplateLauncherOptions(screen, this);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public Optional<KeyMapping> getTriggerKeyBinding() {
        return Optional.of(KeyHandler.getInstance().keybindLauncher);
    }

    @Override
    public void onTriggered(ICommonArmorHandler armorHandler) {
        if (!armorHandler.getPlayer().m_21206_().m_41619_() && this.launcherProgress == 0 && armorHandler.upgradeUsable((IArmorUpgradeHandler<?>)this.getCommonHandler(), false)) {
            this.launcherProgress = 1;
        }
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        if (this.launcherProgress > 0) {
            if (!KeyHandler.getInstance().keybindLauncher.m_90857_()) {
                NetworkHandler.sendToServer(new PacketChestplateLauncher((float)this.launcherProgress / 15.0f));
                this.launcherProgress = 0;
            } else {
                this.launcherProgress = Math.min(this.launcherProgress + 1, 15);
            }
        }
    }

    @Override
    public void render2D(PoseStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
        if (this.launcherProgress == 0) {
            return;
        }
        Window mw = Minecraft.m_91087_().m_91268_();
        matrixStack.m_85836_();
        RenderSystem.m_69472_();
        if (ClientUtils.getClientPlayer().m_5737_() == HumanoidArm.LEFT) {
            matrixStack.m_85837_((double)(mw.m_85445_() - 30), (double)(mw.m_85446_() - 30), -90.0);
            matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
        } else {
            matrixStack.m_85837_(30.0, (double)(mw.m_85446_() - 30), -90.0);
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-60.0f));
        float progress = Math.min(100.0f, ((float)this.launcherProgress + partialTicks) * 100.0f / 15.0f);
        ProgressBarRenderer.render2d(matrixStack, 0.0f, 0.0f, (float)mw.m_85445_() / 6.0f - 30.0f, 12.0f, 0.0f, progress, -1442840416, -1438605057);
        RenderSystem.m_69493_();
        matrixStack.m_85849_();
    }
}

