/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.block.entity.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.SmartChestMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SmartChestScreen
extends AbstractPneumaticCraftContainerScreen<SmartChestMenu, SmartChestBlockEntity> {
    private List<Pair<Integer, ItemStack>> filter;
    private IGuiAnimatedStat statusStat;
    private WidgetButtonExtended showRangeButton;

    public SmartChestScreen(SmartChestMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97726_ = 234;
        this.f_97727_ = 216;
        this.filter = ((SmartChestBlockEntity)this.te).getFilter();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.smart_chest.slots.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16740144, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.smart_chest.slots", new Object[0]));
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.SMART_CHEST.get()), -22016, false);
        this.addPushPullTab();
        this.showRangeButton = new WidgetButtonExtended(this.f_97735_ + 196, this.f_97736_ + 189, 12, 12, "A", b -> this.previewRange());
        this.m_142416_((GuiEventListener)this.showRangeButton);
    }

    private void previewRange() {
        if (AreaRenderManager.getInstance().isShowing(this.te)) {
            AreaRenderManager.getInstance().removeHandlers(this.te);
        } else if (((SmartChestBlockEntity)this.te).getUpgrades((PNCUpgrade)ModUpgrades.MAGNET.get()) > 0) {
            int range = ((SmartChestBlockEntity)this.te).getUpgrades((PNCUpgrade)ModUpgrades.RANGE.get()) + 1;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                if (((SmartChestBlockEntity)this.te).getPushPullMode(face) != SmartChestBlockEntity.PushPullMode.PULL) continue;
                Direction dir = ((SmartChestBlockEntity)this.te).getAbsoluteFacing(face, ((SmartChestBlockEntity)this.te).getRotation());
                BlockPos pos = ((SmartChestBlockEntity)this.te).m_58899_().m_5484_(dir, range + 1);
                posSet.addAll(RangeManager.getFrame(new AABB(pos, pos).m_82400_((double)range)));
            }
            AreaRenderManager.getInstance().showArea(posSet, 0x4000FFFF, this.te, false);
        }
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.smartChestStatus.header", new Object[0]));
        text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.smartChestStatus.itemsPerOperation", ((SmartChestBlockEntity)this.te).getMaxItems()));
        text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.smartChestStatus.tickInterval", ((SmartChestBlockEntity)this.te).getTickRate()));
        this.statusStat.setText(text);
        if (((SmartChestBlockEntity)this.te).getUpgrades((PNCUpgrade)ModUpgrades.MAGNET.get()) > 0) {
            this.showRangeButton.setVisible(true);
            if (AreaRenderManager.getInstance().isShowing(this.te)) {
                this.showRangeButton.m_93666_((Component)Component.m_237113_((String)"R").m_130940_(ChatFormatting.AQUA));
                this.showRangeButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.stopShowingArea", new Object[0]));
            } else {
                this.showRangeButton.m_93666_((Component)Component.m_237113_((String)"R").m_130940_(ChatFormatting.GRAY));
                this.showRangeButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showArea", new Object[0]));
            }
        } else {
            this.showRangeButton.setVisible(false);
        }
    }

    private void addPushPullTab() {
        WidgetAnimatedStat stat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.smart_chest.push_pull.title", new Object[0]), new ItemStack((ItemLike)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
        stat.setMinimumExpandedDimensions(80, 80);
        int yTop = 15;
        int xLeft = 25;
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
    }

    private WidgetButtonExtended makePushPullButton(SideConfigurator.RelativeFace face, int x, int y) {
        WidgetButtonExtended button = new WidgetButtonExtended(x, y, 20, 20, (Component)Component.m_237119_(), b -> {
            ((SmartChestBlockEntity)this.te).cycleMode(face, Screen.m_96638_());
            this.setupPushPullButton((WidgetButtonExtended)b, face);
        }).withTag("push_pull:" + face.toString());
        this.setupPushPullButton(button, face);
        return button;
    }

    private void setupPushPullButton(WidgetButtonExtended button, SideConfigurator.RelativeFace face) {
        SmartChestBlockEntity.PushPullMode mode = ((SmartChestBlockEntity)this.te).getPushPullMode(face);
        switch (mode) {
            case NONE: {
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
                break;
            }
            case PUSH: {
                button.setRenderStacks(new ItemStack((ItemLike)Blocks.f_50039_));
                break;
            }
            case PULL: {
                button.setRenderStacks(new ItemStack((ItemLike)Blocks.f_50032_));
            }
        }
        button.setTooltipText((List<Component>)ImmutableList.of((Object)Component.m_237113_((String)face.toString()).m_130940_(ChatFormatting.YELLOW), (Object)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0])));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SMART_CHEST;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return true;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTick) {
        super.m_6305_(matrixStack, x, y, partialTick);
        if (((SmartChestMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_7993_().m_41619_() && this.f_97734_.f_40219_ < 72 && !((SmartChestBlockEntity)this.te).getFilter(this.f_97734_.f_40219_).m_41619_()) {
            ItemStack stack = ((SmartChestBlockEntity)this.te).getFilter(this.f_97734_.f_40219_);
            List<FormattedCharSequence> l = GuiUtils.wrapTextComponentList(GuiUtils.xlateAndSplit("pneumaticcraft.gui.smart_chest.filter", stack.m_41786_().getString(), stack.m_41613_()), this.f_97726_, this.f_96547_);
            this.m_96617_(matrixStack, l, x, y);
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        super.m_7286_(matrixStack, partialTicks, x, y);
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Pair<Integer, ItemStack> p : this.filter) {
            int slot = (Integer)p.getLeft();
            if (slot >= ((SmartChestBlockEntity)this.te).getLastSlot() || !((Slot)((SmartChestMenu)this.f_97732_).f_38839_.get(slot)).m_6657_()) continue;
            int sx = this.f_97735_ + 8 + slot % 12 * 18;
            int sy = this.f_97736_ + 18 + slot / 12 * 18;
            SmartChestScreen.m_93172_((PoseStack)matrixStack, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)-2139041664);
        }
        for (int slot = ((SmartChestBlockEntity)this.te).getLastSlot(); slot < 72; ++slot) {
            int sx = this.f_97735_ + 8 + slot % 12 * 18;
            int sy = this.f_97736_ + 18 + slot / 12 * 18;
            SmartChestScreen.m_93172_((PoseStack)matrixStack, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)1090478176);
        }
        RenderSystem.m_69461_();
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Pair<Integer, ItemStack> p : this.filter) {
            int slot = (Integer)p.getLeft();
            if (slot >= ((SmartChestBlockEntity)this.te).getLastSlot()) continue;
            int sx = 8 + slot % 12 * 18;
            int sy = 18 + slot / 12 * 18;
            matrixStack.m_85836_();
            ItemStack stack = (ItemStack)p.getRight();
            Minecraft.m_91087_().m_91291_().m_115123_(stack, sx, sy);
            String label = "[" + stack.m_41613_() + "]";
            matrixStack.m_85837_(0.0, 0.0, 300.0);
            if (!((Slot)((SmartChestMenu)this.f_97732_).f_38839_.get(slot)).m_6657_()) {
                SmartChestScreen.m_93172_((PoseStack)matrixStack, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)1619054720);
            }
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.f_96547_.m_92750_(matrixStack, label, 2.0f * ((float)(sx + 16) - (float)this.f_96547_.m_92895_(label) / 2.0f), (float)(2 * (sy + 1)), -96);
            matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
            matrixStack.m_85849_();
        }
        RenderSystem.m_69461_();
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && slotId < 72 && mouseButton == 0 && Screen.m_96639_()) {
            ItemStack stack = slotIn.m_7993_();
            if (stack.m_41619_() && slotId > 0 && ((SmartChestBlockEntity)this.te).getFilter(slotId).m_41619_()) {
                if (((SmartChestMenu)this.f_97732_).m_142621_().m_41619_()) {
                    if (slotId == ((SmartChestBlockEntity)this.te).getLastSlot()) {
                        ((SmartChestBlockEntity)this.te).setLastSlot(72);
                    } else {
                        for (int i = slotId; i < 72; ++i) {
                            if (((Slot)((SmartChestMenu)this.f_97732_).f_38839_.get(i)).m_7993_().m_41619_()) continue;
                            return;
                        }
                        ((SmartChestBlockEntity)this.te).setLastSlot(slotId);
                    }
                } else {
                    ItemStack inHand = ((SmartChestMenu)this.f_97732_).m_142621_().m_41777_();
                    if (SmartChestScreen.m_96638_()) {
                        inHand.m_41764_(inHand.m_41741_());
                    }
                    ((SmartChestBlockEntity)this.te).setFilter(slotId, inHand);
                    if (((SmartChestBlockEntity)this.te).getLastSlot() <= slotId) {
                        ((SmartChestBlockEntity)this.te).setLastSlot(slotId + 1);
                    }
                    this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                }
                NetworkHandler.sendToServer(new PacketSyncSmartChest((SmartChestBlockEntity)this.te));
            } else {
                if (((SmartChestBlockEntity)this.te).getFilter(slotId).m_41619_()) {
                    ((SmartChestBlockEntity)this.te).setFilter(slotId, SmartChestScreen.m_96638_() ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41741_()) : stack);
                } else {
                    ((SmartChestBlockEntity)this.te).setFilter(slotId, ItemStack.f_41583_);
                }
                this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                NetworkHandler.sendToServer(new PacketSyncSmartChest((SmartChestBlockEntity)this.te));
            }
        } else {
            super.m_6597_(slotIn, slotId, mouseButton, type);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double dir) {
        Slot s = this.getSlotUnderMouse();
        if (Screen.m_96639_() && s != null && s.f_40219_ < 72) {
            ItemStack stack = ((SmartChestBlockEntity)this.te).getFilter(s.f_40219_);
            if (!stack.m_41619_()) {
                int newSize = SmartChestScreen.m_96638_() ? (dir > 0.0 ? stack.m_41613_() * 2 : stack.m_41613_() / 2) : stack.m_41613_() + (int)dir;
                newSize = Mth.m_14045_((int)newSize, (int)1, (int)stack.m_41741_());
                if (newSize != stack.m_41613_()) {
                    ((SmartChestBlockEntity)this.te).setFilter(s.f_40219_, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)newSize));
                    this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                    this.sendDelayed(5);
                }
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, dir);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        ItemStack stack;
        Slot s = this.getSlotUnderMouse();
        if (Screen.m_96639_() && s != null && s.f_40219_ < 72 && !(stack = ((SmartChestBlockEntity)this.te).getFilter(s.f_40219_)).m_41619_()) {
            int newCount = switch (keyCode) {
                case 265 -> {
                    if (Screen.m_96638_()) {
                        yield stack.m_41613_() * 2;
                    }
                    yield stack.m_41613_() + 1;
                }
                case 264 -> {
                    if (Screen.m_96638_()) {
                        yield stack.m_41613_() / 2;
                    }
                    yield stack.m_41613_() - 1;
                }
                default -> stack.m_41613_();
            };
            newCount = Mth.m_14045_((int)newCount, (int)1, (int)stack.m_41741_());
            if (newCount != stack.m_41613_()) {
                ((SmartChestBlockEntity)this.te).setFilter(s.f_40219_, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)newCount));
                this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                this.sendDelayed(5);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketSyncSmartChest((SmartChestBlockEntity)this.te));
    }
}

