/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.ITickableWidget;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractPneumaticCraftContainerScreen<C extends AbstractPneumaticCraftMenu<T>, T extends AbstractPneumaticCraftBlockEntity>
extends AbstractContainerScreen<C> {
    public final T te;
    private IGuiAnimatedStat lastLeftStat;
    private IGuiAnimatedStat lastRightStat;
    private WidgetAnimatedStat pressureStat;
    private WidgetAnimatedStat redstoneTab;
    WidgetAnimatedStat problemTab;
    private final List<WidgetButtonExtended> redstoneButtons = new ArrayList<WidgetButtonExtended>();
    boolean firstUpdate = true;
    private final List<IGuiAnimatedStat> statWidgets = new ArrayList<IGuiAnimatedStat>();
    private int sendDelay = -1;

    public AbstractPneumaticCraftContainerScreen(C container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.te = ((AbstractPneumaticCraftMenu)container).te;
    }

    public void m_7856_() {
        super.m_7856_();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        if (this.shouldAddPressureTab() && this.te instanceof AbstractAirHandlingBlockEntity) {
            this.pressureStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.pressure", new Object[0]), new ItemStack((ItemLike)ModBlocks.PRESSURE_TUBE.get()), -16733696, false);
            this.pressureStat.setForegroundColor(-16777216);
        }
        if (this.shouldAddProblemTab()) {
            this.problemTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems", new Object[0]), -6250336, false);
            this.problemTab.setForegroundColor(-16777216);
            this.problemTab.setMinimumExpandedDimensions(0, 16);
        }
        if (this.te != null) {
            T t;
            if (this.shouldAddInfoTab()) {
                this.addInfoTab(GuiUtils.xlateAndSplit(ICustomTooltipName.getTranslationKey(new ItemStack((ItemLike)this.te.m_58900_().m_60734_()), false), new Object[0]));
            }
            if (this.shouldAddRedstoneTab() && this.te instanceof IRedstoneControl) {
                this.addRedstoneTab(((IRedstoneControl)this.te).getRedstoneController());
            }
            if (this.te instanceof IHeatExchangingTE && ((IHeatExchangingTE)this.te).shouldShowGuiHeatTab()) {
                this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.heat.title", new Object[0]), new ItemStack((ItemLike)Items.f_42593_), -2075392, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.heat", new Object[0]));
            }
            if (this.shouldAddUpgradeTab()) {
                this.addUpgradeTab();
            }
            if (this.shouldAddSideConfigTabs()) {
                this.addSideConfiguratorTabs();
            }
            if ((t = this.te) instanceof AbstractAirHandlingBlockEntity) {
                AbstractAirHandlingBlockEntity airHandler = (AbstractAirHandlingBlockEntity)t;
                airHandler.initializeHullAirHandlers();
            }
        }
    }

    private WidgetAnimatedStat addAnimatedStat(Component title, WidgetAnimatedStat.StatIcon icon, int color, boolean leftSided) {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        WidgetAnimatedStat stat = new WidgetAnimatedStat((Screen)this, title, icon, xStart + (leftSided ? 0 : this.f_97726_ + 1), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : yStart + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        stat.setBeveled(true);
        this.m_142416_(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        this.statWidgets.add(stat);
        return stat;
    }

    protected WidgetAnimatedStat addAnimatedStat(Component title, @Nonnull ItemStack icon, int backgroundColor, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.of(icon), backgroundColor, leftSided);
    }

    protected WidgetAnimatedStat addAnimatedStat(Component title, ResourceLocation icon, int backgroundColor, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.of(icon), backgroundColor, leftSided);
    }

    protected WidgetAnimatedStat addAnimatedStat(Component title, int backgroundColor, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.NONE, backgroundColor, leftSided);
    }

    protected WidgetLabel addLabel(Component text, int x, int y) {
        return (WidgetLabel)this.m_142416_((GuiEventListener)new WidgetLabel(x, y, text));
    }

    protected WidgetLabel addLabel(Component text, int x, int y, int color) {
        return (WidgetLabel)this.m_142416_((GuiEventListener)new WidgetLabel(x, y, text, color));
    }

    void removeWidget(AbstractWidget widget) {
        super.m_169411_((GuiEventListener)widget);
        if (widget instanceof IGuiAnimatedStat) {
            this.statWidgets.remove(widget);
        }
    }

    public List<IGuiAnimatedStat> getStatWidgets() {
        return this.statWidgets;
    }

    private void addRedstoneTab(RedstoneController<?> redstoneController) {
        this.redstoneTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour", new Object[0]), new ItemStack((ItemLike)Items.f_42451_), -3407872, true);
        this.redstoneButtons.clear();
        int nModes = redstoneController.getModeCount();
        int bx = -23 * nModes;
        for (int i = 0; i < nModes; ++i) {
            this.redstoneButtons.add(this.createRedstoneModeButton(bx, i, redstoneController.getModeDetails(i)));
            bx += 23;
        }
        this.redstoneButtons.forEach(b -> this.redstoneTab.addSubWidget((AbstractWidget)b));
        this.redstoneTab.setText(redstoneController.getRedstoneTabTitle());
        this.redstoneTab.setMinimumExpandedDimensions(23 * nModes + 5, 46);
    }

    private WidgetButtonExtended createRedstoneModeButton(int x, int idx, RedstoneController.RedstoneMode<?> mode) {
        WidgetButtonExtended b = new WidgetButtonExtended(x, 24, 20, 20, (Component)Component.m_237119_()).withTag("redstone:" + idx);
        mode.getTexture().ifLeft(xva$0 -> b.setRenderStacks((ItemStack)xva$0)).ifRight(b::setRenderedIcon);
        b.setTooltipKey(mode.getTranslationKey(), new Object[0]);
        return b;
    }

    protected void addJeiFilterInfoTab() {
        if (ModList.get().isLoaded("jei")) {
            this.addAnimatedStat((Component)Component.m_237113_((String)"JEI"), Textures.GUI_JEI_LOGO, -3215922, true).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.filterDrag", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    protected String upgradeCategory() {
        ResourceLocation regName = PneumaticCraftUtils.getRegistryName(ForgeRegistries.BLOCK_ENTITY_TYPES, this.te.m_58903_()).orElseThrow();
        return PneumaticCraftUtils.modDefaultedString(regName);
    }

    private void addUpgradeTab() {
        ArrayList<Component> text = new ArrayList<Component>();
        ApplicableUpgradesDB.getInstance().getApplicableUpgrades((BlockEntity)this.te).keySet().stream().sorted(Comparator.comparing(o -> o.getItemStack().m_41786_().getString())).forEach(upgrade -> {
            if (this.isUpgradeAvailable((PNCUpgrade)upgrade)) {
                int max = ApplicableUpgradesDB.getInstance().getMaxUpgrades((BlockEntity)this.te, (PNCUpgrade)upgrade);
                text.add((Component)upgrade.getItemStack().m_41786_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE}));
                text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades.max", max).m_130940_(ChatFormatting.GRAY));
                ResourceLocation regName = PneumaticCraftUtils.getRegistryName(ModUpgrades.UPGRADES.get(), upgrade).orElseThrow();
                String upgradeName = PneumaticCraftUtils.modDefaultedString(regName);
                String k = "pneumaticcraft.gui.tab.upgrades." + this.upgradeCategory() + "." + upgradeName;
                text.addAll(I18n.m_118936_((String)k) ? GuiUtils.xlateAndSplit(k, new Object[0]) : GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.upgrades.generic." + upgradeName, new Object[0]));
                text.add((Component)Component.m_237119_());
            }
        });
        if (!text.isEmpty()) {
            this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades", new Object[0]), Textures.GUI_UPGRADES_LOCATION, -14920792, true).setText(text).setForegroundColor(-16777216);
        }
    }

    protected boolean isUpgradeAvailable(PNCUpgrade upgrade) {
        return true;
    }

    private void addSideConfiguratorTabs() {
        for (SideConfigurator<?> sc : ((ISideConfigurable)this.te).getSideConfigurators()) {
            WidgetAnimatedStat stat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate(sc.getTranslationKey(), new Object[0]), new ItemStack((ItemLike)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
            stat.setMinimumExpandedDimensions(80, 80);
            int yTop = 15;
            int xLeft = 25;
            stat.addSubWidget((AbstractWidget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
            stat.addSubWidget((AbstractWidget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
            stat.addSubWidget((AbstractWidget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
            stat.addSubWidget((AbstractWidget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
            stat.addSubWidget((AbstractWidget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
            stat.addSubWidget((AbstractWidget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
        }
    }

    private SideConfiguratorButton makeSideConfButton(SideConfigurator<?> sideConfigurator, SideConfigurator.RelativeFace relativeFace, int x, int y) {
        SideConfiguratorButton button = (SideConfiguratorButton)new SideConfiguratorButton(x, y, relativeFace, b -> {
            SideConfiguratorButton gbs = (SideConfiguratorButton)b;
            if (sideConfigurator.handleButtonPress(gbs.getTag(), Screen.m_96638_())) {
                this.setupSideConfiguratorButton(sideConfigurator, gbs);
            }
        }).withTag(sideConfigurator.getButtonTag(relativeFace));
        this.setupSideConfiguratorButton(sideConfigurator, button);
        return button;
    }

    private void setupSideConfiguratorButton(SideConfigurator<?> sc, SideConfiguratorButton button) {
        SideConfigurator.RelativeFace relativeFace = button.relativeFace;
        SideConfigurator.ConnectionEntry<?> c = sc.getEntry(relativeFace);
        if (c != null && c.getTexture() != null) {
            button.setTexture(c.getTexture());
        } else {
            button.setRenderedIcon(Textures.GUI_X_BUTTON);
        }
        button.setTooltipText((List<Component>)ImmutableList.of((Object)Component.m_237113_((String)relativeFace.toString()).m_130940_(ChatFormatting.YELLOW), (Object)sc.getFaceLabel(relativeFace)));
    }

    protected void addInfoTab(List<Component> info) {
        WidgetAnimatedStat stat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), Textures.GUI_INFO_LOCATION, -7829249, true);
        stat.setForegroundColor(-16777216);
        stat.setText(info);
        if (!ThirdPartyManager.instance().getDocsProvider().isInstalled()) {
            stat.appendText(Arrays.asList(Component.m_237119_(), PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.installDocsProvider", new Object[0])));
        }
    }

    protected void addInfoTab(Component info) {
        this.addInfoTab(Collections.singletonList(info));
    }

    protected boolean shouldAddRedstoneTab() {
        return true;
    }

    protected boolean shouldAddPressureTab() {
        return true;
    }

    protected boolean shouldAddUpgradeTab() {
        return true;
    }

    protected boolean shouldAddInfoTab() {
        return true;
    }

    protected boolean shouldAddProblemTab() {
        return true;
    }

    protected boolean shouldAddSideConfigTabs() {
        return this.te instanceof ISideConfigurable;
    }

    protected int getBackgroundTint() {
        return -1;
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int i, int j) {
        if (this.shouldDrawBackground()) {
            this.bindGuiTexture();
            int xStart = (this.f_96543_ - this.f_97726_) / 2;
            int yStart = (this.f_96544_ - this.f_97727_) / 2;
            this.m_93228_(matrixStack, xStart, yStart, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        PointXY gaugeLocation;
        if (this.getInvNameOffset() != null) {
            this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f + (float)this.getInvNameOffset().x(), (float)(5 + this.getInvNameOffset().y()), this.getTitleColor());
        }
        if (this.getInvTextOffset() != null) {
            this.f_96547_.m_92889_(matrixStack, (Component)PneumaticCraftUtils.xlate("container.inventory", new Object[0]), (float)(8 + this.getInvTextOffset().x()), (float)(this.f_97727_ - 94 + this.getInvTextOffset().y()), 0x404040);
        }
        if (this.pressureStat != null && (gaugeLocation = this.getGaugeLocation()) != null) {
            float f;
            AbstractAirHandlingBlockEntity pneu = (AbstractAirHandlingBlockEntity)this.te;
            T t = this.te;
            if (t instanceof IMinWorkingPressure) {
                IMinWorkingPressure min = (IMinWorkingPressure)t;
                f = min.getMinWorkingPressure();
            } else {
                f = -3.4028235E38f;
            }
            float minWorking = f;
            PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.f_96547_, -1.0f, pneu.getCriticalPressure(), pneu.getDangerPressure(), minWorking, pneu.getPressure(), gaugeLocation.x() - this.f_97735_, gaugeLocation.y() - this.f_97736_);
        }
    }

    void bindGuiTexture() {
        ResourceLocation guiTexture = this.getGuiTexture();
        if (guiTexture != null) {
            float[] c = RenderUtils.decomposeColorF(this.getBackgroundTint());
            GuiUtils.bindTexture(guiTexture, c[1], c[2], c[3], c[0]);
            RenderSystem.m_69493_();
        }
    }

    protected abstract ResourceLocation getGuiTexture();

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        for (IGuiAnimatedStat w : this.statWidgets) {
            if (!w.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTick) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTick);
        this.m_7025_(matrixStack, x, y);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (Widget widget : this.f_169369_) {
            ITooltipProvider provider;
            if (!(widget instanceof ITooltipProvider) || !(provider = (ITooltipProvider)widget).shouldProvide()) continue;
            provider.addTooltip(x, y, tooltip, Screen.m_96638_());
        }
        if (this.shouldParseVariablesInTooltips()) {
            for (int i = 0; i < tooltip.size(); ++i) {
                tooltip.set(i, (Component)Component.m_237113_((String)new TextVariableParser(((Component)tooltip.get(i)).getString(), ClientUtils.getClientPlayer().m_20148_()).parse()));
            }
        }
        if (!tooltip.isEmpty()) {
            int max = Math.min(this.getXSize(), 350);
            this.m_96617_(matrixStack, GuiUtils.wrapTextComponentList(tooltip, max, this.f_96547_), x, y);
        }
    }

    protected PointXY getGaugeLocation() {
        return new PointXY(this.getGuiLeft() + this.f_97726_ * 3 / 4, this.getGuiTop() + this.f_97727_ / 4 + 4);
    }

    protected int getTitleColor() {
        return 0x404040;
    }

    protected PointXY getInvNameOffset() {
        return PointXY.ZERO;
    }

    protected PointXY getInvTextOffset() {
        return PointXY.ZERO;
    }

    public void m_181908_() {
        Object w2;
        super.m_181908_();
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.doDelayedAction();
            this.sendDelay = -1;
        }
        for (Object w2 : this.f_169369_) {
            if (!(w2 instanceof ITickableWidget)) continue;
            ITickableWidget t = (ITickableWidget)w2;
            t.tickWidget();
        }
        if (this.pressureStat != null && this.pressureStat.isDoneExpanding()) {
            ArrayList<Component> pressureText = new ArrayList<Component>();
            this.addPressureStatInfo(pressureText);
            this.pressureStat.setText(pressureText);
        }
        if (this.problemTab != null && ((ClientUtils.getClientLevel().m_46467_() & 7L) == 0L || this.firstUpdate)) {
            this.handleProblemsTab();
        }
        if (this.redstoneTab != null && (w2 = this.te) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)w2;
            this.redstoneTab.setExtraTooltipText(Collections.singletonList(rc.getRedstoneController().getDescription()));
            for (int i = 0; i < this.redstoneButtons.size(); ++i) {
                this.redstoneButtons.get((int)i).f_93623_ = i != rc.getRedstoneMode();
            }
        }
        this.firstUpdate = false;
    }

    private void handleProblemsTab() {
        ArrayList<Component> problemText = new ArrayList<Component>();
        this.addProblems(problemText);
        int nProbs = problemText.size();
        this.addWarnings(problemText);
        int nWarnings = problemText.size() - nProbs;
        this.addInformation(problemText);
        if (nProbs > 0) {
            this.problemTab.setTexture(Textures.GUI_PROBLEMS_TEXTURE);
            this.problemTab.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems", new Object[0]));
            this.problemTab.setBackgroundColor(-65536);
        } else if (nWarnings > 0) {
            this.problemTab.setTexture(Textures.GUI_WARNING_TEXTURE);
            this.problemTab.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.warning", new Object[0]));
            this.problemTab.setBackgroundColor(-4145152);
        } else {
            this.problemTab.setTexture(Textures.GUI_NO_PROBLEMS_TEXTURE);
            this.problemTab.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.noProblems", new Object[0]));
            this.problemTab.setBackgroundColor(-8331136);
        }
        this.problemTab.setText(problemText);
    }

    protected void addPressureStatInfo(List<Component> pressureStatText) {
        this.te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
            float curPressure = airHandler.getPressure();
            int volume = airHandler.getVolume();
            int upgrades = ((AbstractPneumaticCraftBlockEntity)this.te).getUpgrades((PNCUpgrade)ModUpgrades.VOLUME.get());
            airHandler.setVolumeUpgrades(upgrades);
            this.addPressureInfo(pressureStatText, curPressure, volume, airHandler.getBaseVolume(), upgrades);
        });
    }

    public void addPressureInfo(List<Component> text, float curPressure, int volume, int baseVolume, int upgrades) {
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(curPressure, 2)));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.air", String.format("%,d", Math.round(curPressure * (float)volume))));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.baseVolume", String.format("%,d", baseVolume)));
        if (volume > baseVolume) {
            text.add((Component)Component.m_237113_((String)("\u25b6 " + upgrades + " x ")).m_7220_(((PNCUpgrade)ModUpgrades.VOLUME.get()).getItemStack().m_41786_()));
            this.addExtraVolumeModifierInfo(text);
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.effectiveVolume", String.format("%,d", volume)));
        }
    }

    protected void addExtraVolumeModifierInfo(List<Component> text) {
    }

    protected void addProblems(List<Component> curInfo) {
        if (this.te instanceof IMinWorkingPressure) {
            float min = ((IMinWorkingPressure)this.te).getMinWorkingPressure();
            float pressure = ((AbstractAirHandlingBlockEntity)this.te).getPressure();
            if (min > 0.0f && pressure < min) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughPressure", new Object[0]));
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyPressure", Float.valueOf(min)));
            } else if (min < 0.0f && pressure > min) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughVacuum", new Object[0]));
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyVacuum", Float.valueOf(min)));
            }
        }
    }

    protected void addInformation(List<Component> curInfo) {
    }

    protected void addWarnings(List<Component> curInfo) {
        IRedstoneControl teR;
        T t = this.te;
        if (t instanceof IRedstoneControl && !(teR = (IRedstoneControl)t).getRedstoneController().isEmitter() && !teR.getRedstoneController().shouldRun()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.redstoneDisallows", new Object[0]));
            if (teR.getRedstoneMode() == 1) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.provideRedstone", new Object[0]));
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.removeRedstone", new Object[0]));
            }
        }
    }

    void sendGUIButtonPacketToServer(String tag) {
        NetworkHandler.sendToServer(new PacketGuiButton(tag));
    }

    public List<Rect2i> getTabRectangles() {
        return this.getStatWidgets().stream().map(IGuiAnimatedStat::getBounds).collect(Collectors.toList());
    }

    void refreshScreen() {
        Window mw = Minecraft.m_91087_().m_91268_();
        int i = mw.m_85445_();
        int j = mw.m_85446_();
        this.m_6575_(Minecraft.m_91087_(), i, j);
        this.f_169369_.stream().filter(widget -> widget instanceof Tickable).forEach(w -> ((Tickable)w).m_7673_());
    }

    protected void sendDelayed(int ticks) {
        this.sendDelay = ticks;
    }

    protected void doDelayedAction() {
    }

    public void m_7861_() {
        if (this.sendDelay > 0) {
            this.doDelayedAction();
        }
        super.m_7861_();
    }

    protected boolean shouldParseVariablesInTooltips() {
        return false;
    }

    public void onGuiUpdate() {
    }

    public Collection<ItemStack> getTargetItems() {
        return Collections.emptyList();
    }

    public Collection<FluidStack> getTargetFluids() {
        return Collections.emptyList();
    }

    <R extends PneumaticCraftRecipe> Optional<R> getCurrentRecipe(PneumaticCraftRecipeType<R> type) {
        String id = ((AbstractPneumaticCraftBlockEntity)this.te).getCurrentRecipeIdSynced();
        return id.isEmpty() ? Optional.empty() : Optional.ofNullable(type.getRecipe(ClientUtils.getClientLevel(), new ResourceLocation(id)));
    }

    private static class SideConfiguratorButton
    extends WidgetButtonExtended {
        private final SideConfigurator.RelativeFace relativeFace;

        public SideConfiguratorButton(int startX, int startY, SideConfigurator.RelativeFace relativeFace, Button.OnPress pressable) {
            super(startX, startY, 20, 20, (Component)Component.m_237119_(), pressable);
            this.relativeFace = relativeFace;
        }
    }
}

