/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import shetiphian.core.common.Function;
import shetiphian.platforms.Roster;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TileEntityPlatformFrame
extends TileEntityPlatformBase {
    private EnumTorchType torch = EnumTorchType.NONE;

    public TileEntityPlatformFrame(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.FRAME.get(), pos, state);
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.m_128344_("torch", (byte)this.torch.ordinal());
    }

    @Override
    protected void processNBT(CompoundTag nbtTag) {
        super.processNBT(nbtTag);
        this.torch = EnumTorchType.byIndex(nbtTag.m_128445_("torch"));
    }

    protected void processNBT_SyncOnly(CompoundTag nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        Function.updateLighting((BlockEntity)this);
    }

    @Override
    protected boolean canApplyCovering(EnumCovering covering) {
        return covering.renderOnRails() && super.canApplyCovering(covering);
    }

    public EnumTorchType getTorch() {
        return this.torch;
    }

    public boolean setTorch(EnumTorchType torch) {
        if (torch != null && torch != EnumTorchType.NONE) {
            this.torch = torch;
            this.updateLightValue();
            return true;
        }
        return false;
    }

    public void removeTorch() {
        switch (this.torch) {
            case GLOWSTONE: {
                this.torch = EnumTorchType.LIGHT;
                return;
            }
            case LAMP_OFF: {
                this.torch = EnumTorchType.REDSTONE_ON;
                return;
            }
            case LAMP_ON: {
                this.torch = EnumTorchType.REDSTONE_OFF;
                return;
            }
        }
        this.torch = EnumTorchType.NONE;
        this.updateLightValue();
    }

    @Override
    public void addExtraDrops(List<ItemStack> drops) {
        super.addExtraDrops(drops);
        if (this.torch != null && this.torch != EnumTorchType.NONE) {
            drops.add(this.torch.getItemStack());
            if (this.torch.isUpgrade()) {
                drops.add(this.torch.getBaseItemStack());
            }
        }
    }

    public int getLightValue() {
        if (this.torch != null && this.torch != EnumTorchType.NONE) {
            switch (this.torch) {
                case REDSTONE_ON: {
                    return Blocks.f_50174_.m_49966_().m_60791_();
                }
                case LIGHT: {
                    return Blocks.f_50081_.m_49966_().m_60791_();
                }
                case GLOWSTONE: 
                case SOULSTONE: {
                    return Blocks.f_50141_.m_49966_().m_60791_();
                }
                case LAMP_ON: {
                    return ((BlockState)Blocks.f_50261_.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true))).m_60791_();
                }
                case SOUL: {
                    return Blocks.f_50139_.m_49966_().m_60791_();
                }
            }
        }
        return 0;
    }
}

