/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.BlockInfo;
import shetiphian.core.common.Function;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.ToolHelper;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.gui.GuiPlatformSelect;
import shetiphian.platforms.client.gui.GuiWrench;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.PlatformDataSet;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRailing;

public class EventHandler {
    private static long debounce;
    public static BlockPos RANGE_START;

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player = event.getEntity();
        if (player == null || event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Level world = event.getLevel();
        BlockState state = world.m_8055_(pos = event.getPos());
        if ((state.m_60734_() instanceof BlockPlatformBase || RANGE_START != null) && player.m_21205_().m_41619_() && ToolHelper.isWrench((ItemStack)player.m_21206_())) {
            if (player.f_19853_.m_5776_()) {
                if (RANGE_START == null) {
                    RANGE_START = pos;
                } else {
                    BlockPos rangeEnd;
                    Direction direction = event.getFace();
                    if (direction == null) {
                        BlockInfo info = Function.getBlockInfront((Level)world, (Entity)player, (double)0.0, (boolean)false);
                        if (info == null) {
                            return;
                        }
                        direction = info.face;
                    }
                    BlockPos blockPos = rangeEnd = world.m_8055_(pos).m_60734_() instanceof BlockPlatformBase ? pos : pos.m_121945_(direction);
                    if (EventHandler.checkEditRange(rangeEnd, player, false) && event.getFace() != null) {
                        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUIEdit(player, world, RANGE_START, rangeEnd));
                    }
                    RANGE_START = null;
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if (state.m_60734_() instanceof BlockPlatformBase) {
            BlockEntity te = world.m_7702_(event.getPos());
            ItemStack stack = event.getItemStack();
            if (stack == null) {
                return;
            }
            if (te instanceof TileEntityPlatformBase) {
                TileEntityPlatformBase tile = (TileEntityPlatformBase)te;
                if (player.m_6047_()) {
                    EnumCovering covering;
                    if (tile.getCovering() != EnumCovering.NONE) {
                        if (ToolHelper.isShovel((ItemStack)stack)) {
                            tile.playCoveringSound(player, false);
                            tile.setCovering(EnumCovering.NONE);
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.SUCCESS);
                            return;
                        }
                    } else if (stack.m_41720_() instanceof BlockItem && ((Boolean)Configuration.DUST_COVERING.canManuallyAdd.get()).booleanValue() && (covering = tile.setCoveringTexture(stack)) != EnumCovering.NONE) {
                        ((BlockPlatformBase)state.m_60734_()).changeCovering(state, world, pos, covering);
                        tile.playCoveringSound(player, true);
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        return;
                    }
                }
                if (ToolHelper.isWrench((ItemStack)stack) && state.m_60734_() instanceof BlockPlatformBase) {
                    boolean changeType;
                    EnumPlatformType platformType = ((BlockPlatformBase)state.m_60734_()).getPlatformType();
                    boolean bl = changeType = platformType != EnumPlatformType.FRAME && player.m_6047_();
                    if (changeType && this.useGUI(player, platformType)) {
                        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUISelect(player, world, pos, platformType, tile));
                    } else {
                        BlockState result = ((BlockPlatformBase)state.m_60734_()).rotateBlock(state, (LevelAccessor)world, pos, tile, changeType ? Rotation.NONE : Rotation.CLOCKWISE_90);
                        player.m_6674_(event.getHand());
                        if (!changeType && result != state) {
                            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)result, (boolean)true);
                        }
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
    }

    private boolean useGUI(Player player, EnumPlatformType platformType) {
        int option = player.f_19853_.m_5776_() ? ((Configuration.Menu_General.PlatformSelect)((Object)Configuration.GENERAL.platformSelect.get())).ordinal() : ((Integer)PlayerConfigs.getConfig((Player)player, (ResourceLocation)Values.keyConfigPlatformSelectMode, (Object)Configuration.Menu_General.PlatformSelect.MIXED.ordinal())).intValue();
        return option == Configuration.Menu_General.PlatformSelect.GUI.ordinal() || option == Configuration.Menu_General.PlatformSelect.MIXED.ordinal() && (platformType == EnumPlatformType.FLAT || platformType == EnumPlatformType.FLOOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUISelect(Player player, Level world, BlockPos pos, EnumPlatformType platformType, TileEntityPlatformBase tile) {
        if (System.currentTimeMillis() > debounce + 250L) {
            debounce = System.currentTimeMillis();
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)new GuiPlatformSelect(player, world, pos, platformType, tile)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_() && event.getEntity() instanceof Player) {
            Configuration.sync();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUIEdit(Player player, Level world, BlockPos rangeStart, BlockPos rangeEnd) {
        int minY = Math.min(rangeStart.m_123342_(), rangeEnd.m_123342_());
        HashMap counters = new HashMap();
        HashMap<EnumPlatformType, PlatformDataSet> presets = new HashMap<EnumPlatformType, PlatformDataSet>();
        this.addPreset(presets, world.m_8055_(rangeStart), world, rangeStart, player, null);
        this.addPreset(presets, world.m_8055_(rangeStart), world, rangeEnd, player, null);
        HashSet<BlockPos> posEditBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> posPlaceBlocks = new HashSet<BlockPos>();
        BlockPos.m_121990_((BlockPos)rangeStart, (BlockPos)rangeEnd).filter(boxPos -> {
            BlockState boxState = world.m_8055_(boxPos);
            if (boxState.m_60767_().m_76336_()) {
                BlockPos.MutableBlockPos scanPos = new BlockPos.MutableBlockPos(boxPos.m_123341_(), boxPos.m_123342_(), boxPos.m_123343_());
                while (scanPos.m_123342_() >= minY) {
                    if ((!world.m_46859_((BlockPos)(scanPos = scanPos.m_122173_(Direction.DOWN))) || !posPlaceBlocks.contains(scanPos)) && !(world.m_8055_((BlockPos)scanPos).m_60734_() instanceof BlockPlatformBase)) continue;
                    return false;
                }
                posPlaceBlocks.add(boxPos.m_7949_());
                return false;
            }
            return this.addPreset((Map<EnumPlatformType, PlatformDataSet>)presets, boxState, world, (BlockPos)boxPos, player, counters);
        }).forEach(pos -> posEditBlocks.add(pos.m_7949_()));
        if (presets.size() > 0) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiWrench(presets, posEditBlocks, posPlaceBlocks));
        }
    }

    private boolean addPreset(Map<EnumPlatformType, PlatformDataSet> presets, BlockState state, Level world, BlockPos pos, Player player, Map<EnumPlatformType, Integer> counters) {
        Block block = state.m_60734_();
        if (block instanceof BlockPlatformBase) {
            BlockEntity tile;
            EnumPlatformType type = ((BlockPlatformBase)block).getPlatformType();
            if (type.isAddon() && (tile = world.m_7702_(pos)) instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked()) {
                return false;
            }
            if (counters != null) {
                counters.put(type, counters.getOrDefault((Object)type, 0) + 1);
            }
            if (!presets.containsKey((Object)type)) {
                presets.put(type, new PlatformDataSet(type, state, world, pos, player));
            }
            return true;
        }
        return false;
    }

    public static boolean checkEditRange(BlockPos rangeEnd, Player player, boolean display) {
        int x = Math.abs(RANGE_START.m_123341_() - rangeEnd.m_123341_());
        int y = Math.abs(RANGE_START.m_123342_() - rangeEnd.m_123342_());
        int z = Math.abs(RANGE_START.m_123343_() - rangeEnd.m_123343_());
        if (display && player != null) {
            player.m_5661_((Component)Component.m_237113_((String)String.format("%d x %d x %d", x + 1, y + 1, z + 1)), true);
        }
        return x < 64 && y < 4 && z < 64 && x * y * z < 1024;
    }
}

