/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformIncline;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRailing;

public class BlockPlatformType {

    public static abstract class Walkways
    extends BlockPlatformBase {
        public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getWalkwayValues());

        public Walkways(EnumPlatformType type) {
            super(type);
        }

        @Override
        public PropertySubType getPropertySubType() {
            return SUBTYPE;
        }

        @Override
        protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
        }
    }

    public static abstract class Singles
    extends BlockPlatformBase {
        public Singles(EnumPlatformType type) {
            super(type);
        }

        @Override
        public PropertySubType getPropertySubType() {
            return null;
        }
    }

    public static abstract class Inclines
    extends BlockPlatformBase {
        public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getInclineValues());

        public Inclines(EnumPlatformType type) {
            super(type);
        }

        @Override
        public PropertySubType getPropertySubType() {
            return SUBTYPE;
        }

        protected VoxelShape getRailingBox(EnumSubType.EnumStyle style, EnumPlatformType railType, boolean collision, Direction direction) {
            if (style == EnumSubType.EnumStyle.RIGHT || style == EnumSubType.EnumStyle.LEFT) {
                String key = railType + "_" + style + (collision ? "_collide" : "_select");
                String key2 = key + "_shifted";
                if (!HITBOXES.contains((Object)key2, (Object)direction)) {
                    HITBOXES.put((Object)key2, (Object)direction, (Object)((VoxelShape)HITBOXES.get((Object)key, (Object)direction)).m_83216_(0.0, 1.0, 0.0));
                }
                return (VoxelShape)HITBOXES.get((Object)key2, (Object)direction);
            }
            return (VoxelShape)HITBOXES.get((Object)(railType + "_middle" + (collision ? "_collide" : "_select")), (Object)direction);
        }

        protected int getSupports(Level world, BlockPos pos) {
            AABB aabbDown;
            BlockState stateDown;
            Block blockDown;
            int support = world.m_46859_(pos.m_7495_()) ? 2 : ((blockDown = (stateDown = world.m_8055_(pos.m_7495_())).m_60734_()) instanceof FenceBlock || blockDown instanceof WallBlock || blockDown instanceof LanternBlock ? 1 : ((aabbDown = this.getShapeBoundingBox(stateDown.m_60808_((BlockGetter)world, pos.m_7495_()))) != null && aabbDown.f_82292_ >= 1.0 ? (aabbDown.f_82288_ > 0.1875 || aabbDown.f_82290_ > 0.1875 || aabbDown.f_82291_ < 0.8125 || aabbDown.f_82293_ < 0.8125 ? 1 : 0) : 2));
            return support;
        }
    }

    public static abstract class Railings
    extends BlockPlatformBase {
        public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getSimpleValues());

        public Railings(EnumPlatformType type) {
            super(type);
        }

        @Override
        public PropertySubType getPropertySubType() {
            return SUBTYPE;
        }

        @Override
        protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
            TileEntityPlatformBase oTile = Railings.getTile((BlockGetter)world, pos.m_7495_());
            if (tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinkedToRamp() && !(oTile instanceof TileEntityPlatformIncline)) {
                world.m_7471_(pos, false);
            }
            if (tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinkedToFloor() && !(oTile instanceof TileEntityPlatformFloor)) {
                world.m_7471_(pos, false);
            }
        }
    }
}

