/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.pipez.corelib.client.RenderUtils;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.helpers.WrappedFluidStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WrappedGasStack
extends AbstractStack<GasStack> {
    public WrappedGasStack(GasStack stack) {
        super(stack);
    }

    @Nullable
    public static WrappedGasStack dummyStack(Object o) {
        if (o instanceof Gas) {
            GasStack stack = new GasStack((IGasProvider)((Gas)o), 1000L);
            return new WrappedGasStack(stack);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrixStack, int x, int y) {
        TextureAtlasSprite texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(((Gas)((GasStack)this.stack).getType()).getIcon());
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int chemicalTint = ((GasStack)this.stack).getChemicalTint();
        RenderSystem.m_157429_((float)RenderUtils.getRedFloat(chemicalTint), (float)RenderUtils.getGreenFloat(chemicalTint), (float)RenderUtils.getBlueFloat(chemicalTint), (float)RenderUtils.getAlphaFloat(chemicalTint));
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture.m_118414_().m_118330_());
        WrappedFluidStack.fluidBlit(matrixStack, x, y, 16, 16, texture, ((Gas)((GasStack)this.stack).getType()).getTint());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltip(Screen screen) {
        ResourceLocation registryName;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.m_91087_().f_91066_.f_92125_ && (registryName = MekanismAPI.gasRegistry().getKey((Object)((Gas)((GasStack)this.stack).getType()))) != null) {
            tooltip.add((Component)Component.m_237113_((String)registryName.toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237119_().m_7220_(((GasStack)this.stack).getTextComponent());
    }

    @Override
    public boolean isEmpty() {
        return ((GasStack)this.stack).isEmpty();
    }
}

