/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.utils.GasTag;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class GasUtils {
    public static final Tag<Gas> EMPTY_GAS_TAG = new SingleElementTag<Gas>(((Gas)GasStack.EMPTY.getType()).getRegistryName(), (Gas)GasStack.EMPTY.getType());

    @Nullable
    public static Tag<Gas> getGas(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            TagKey tagKey = ChemicalTags.GAS.tag(id);
            ITagManager tags = MekanismAPI.gasRegistry().tags();
            if (tags == null) {
                return nullIfNotExists ? null : EMPTY_GAS_TAG;
            }
            ITag tag = tags.getTag(tagKey);
            if (tag.isEmpty()) {
                return nullIfNotExists ? null : EMPTY_GAS_TAG;
            }
            return new GasTag((ITag<Gas>)tag, id);
        }
        ResourceLocation id = new ResourceLocation(name);
        if (!MekanismAPI.gasRegistry().containsKey(id)) {
            return nullIfNotExists ? null : EMPTY_GAS_TAG;
        }
        Gas gas = (Gas)MekanismAPI.gasRegistry().getValue(new ResourceLocation(name));
        if (gas == null) {
            return nullIfNotExists ? null : EMPTY_GAS_TAG;
        }
        return new SingleElementTag<Gas>(id, gas);
    }

    @Nullable
    public static Tag<Gas> getGasTag(String name, boolean nullIfNotExists) {
        ResourceLocation id = new ResourceLocation(name);
        TagKey tagKey = ChemicalTags.GAS.tag(id);
        ITagManager tags = MekanismAPI.gasRegistry().tags();
        if (tags == null) {
            return nullIfNotExists ? null : EMPTY_GAS_TAG;
        }
        ITag tag = tags.getTag(tagKey);
        if (tag.isEmpty()) {
            return nullIfNotExists ? null : EMPTY_GAS_TAG;
        }
        return new GasTag((ITag<Gas>)tag, id);
    }

    @Nullable
    public static GasStack getGasContained(ItemStack stack) {
        LazyOptional c = stack.getCapability(ModCapabilities.GAS_HANDLER_CAPABILITY);
        IGasHandler handler = (IGasHandler)c.orElse(null);
        if (handler == null) {
            return null;
        }
        if (handler.getTanks() <= 0) {
            return null;
        }
        return ((GasStack)handler.getChemicalInTank(0)).copy();
    }
}

