/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.energy;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.Cleaner;
import java.util.Comparator;
import java.util.function.Function;
import mekanism.api.Action;
import mekanism.api.energy.EnergyConversionHelper;
import mekanism.api.energy.IEnergyConversion;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyHandler;
import net.roguelogix.phosphophyllite.mixin.helpers.IPhosphophylliteLazyOptional;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;

@NonnullDefault
public class EnergyHandlerWrappers {
    private static final ObjectArrayList<WrapperRegistration<?>> supportedCapabilitiesList = new ObjectArrayList();
    private static final Object2ObjectMap<Capability<?>, WrapperRegistration<?>> supportedCapabilitiesMap = new Object2ObjectOpenHashMap();
    private static final Cleaner CLEANER = Cleaner.create();

    public static synchronized <T> void registerWrapper(Capability<T> capability, Function<T, IPhosphophylliteEnergyHandler> toWrapperConstructor, Function<IPhosphophylliteEnergyHandler, T> fromWrapperConstructor, int priority) {
        EnergyHandlerWrappers.registerWrapper(new WrapperRegistration<T>(capability, toWrapperConstructor, fromWrapperConstructor, priority));
    }

    public static synchronized <T> void registerWrapper(WrapperRegistration<T> registration) {
        supportedCapabilitiesList.add(registration);
        Comparator<WrapperRegistration> comparator = Comparator.comparingInt(WrapperRegistration::priority);
        supportedCapabilitiesList.sort(comparator.reversed());
        supportedCapabilitiesMap.put(registration.capability, registration);
    }

    public static LazyOptional<IPhosphophylliteEnergyHandler> findCapability(BlockEntity entity, Direction direction) {
        for (int i = 0; i < supportedCapabilitiesList.size(); ++i) {
            LazyOptional capabilityOptional;
            WrapperRegistration registration = (WrapperRegistration)supportedCapabilitiesList.get(i);
            if (registration == null || !(capabilityOptional = entity.getCapability(registration.capability, direction)).isPresent()) continue;
            LazyOptional wrappedOptional = registration.wrapTo(capabilityOptional).cast();
            if (wrappedOptional == capabilityOptional) {
                return wrappedOptional.cast();
            }
            NonNullConsumer listener = opt -> wrappedOptional.invalidate();
            CLEANER.register(wrappedOptional, () -> {
                if (capabilityOptional instanceof IPhosphophylliteLazyOptional) {
                    IPhosphophylliteLazyOptional phosOpt = (IPhosphophylliteLazyOptional)capabilityOptional;
                    phosOpt.removeListener(listener);
                }
            });
            capabilityOptional.addListener(listener);
            return wrappedOptional.cast();
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<?> attemptWrap(Capability<?> capability, LazyOptional<IPhosphophylliteEnergyHandler> handler) {
        WrapperRegistration registration = (WrapperRegistration)supportedCapabilitiesMap.get(capability);
        if (registration == null || !handler.isPresent()) {
            return LazyOptional.empty();
        }
        LazyOptional<?> wrappedOptional = registration.wrapFrom(handler);
        if (wrappedOptional == handler) {
            return handler;
        }
        NonNullConsumer listener = opt -> wrappedOptional.invalidate();
        CLEANER.register(wrappedOptional, () -> {
            if (handler instanceof IPhosphophylliteLazyOptional) {
                ((IPhosphophylliteLazyOptional)handler).removeListener(listener);
            }
        });
        handler.addListener(listener);
        return wrappedOptional;
    }

    static {
        EnergyHandlerWrappers.registerWrapper(IPhosphophylliteEnergyHandler.CAPABILITY, Function.identity(), Function.identity(), Integer.MAX_VALUE);
    }

    private record WrapperRegistration<T>(Capability<T> capability, Function<T, IPhosphophylliteEnergyHandler> toWrapperConstructor, Function<IPhosphophylliteEnergyHandler, T> fromWrapperConstructor, int priority) {
        LazyOptional<IPhosphophylliteEnergyHandler> wrapTo(LazyOptional<?> optional) {
            return LazyOptional.of(() -> this.toWrapperConstructor.apply(optional.orElse(null)));
        }

        LazyOptional<?> wrapFrom(LazyOptional<IPhosphophylliteEnergyHandler> optional) {
            return LazyOptional.of(() -> this.fromWrapperConstructor.apply((IPhosphophylliteEnergyHandler)optional.orElse(null)));
        }
    }

    private static class Mekanism {
        private static final IEnergyConversion JouleFEConversion = EnergyConversionHelper.feConversion();
        public static final Capability<IStrictEnergyHandler> STRICT_ENERGY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IStrictEnergyHandler>(){});

        private Mekanism() {
        }

        @OnModLoad
        public static void onModLoad() {
            EnergyHandlerWrappers.registerWrapper(STRICT_ENERGY, ToWrapper::new, FromWrapper::new, -1);
        }

        private static class FromWrapper
        implements IStrictEnergyHandler {
            private final IPhosphophylliteEnergyHandler phosHandler;
            private final FloatingLong referenceValue = FloatingLong.create((long)0L);
            private final FloatingLong returnedValue = FloatingLong.create((long)0L);

            FromWrapper(IPhosphophylliteEnergyHandler phosHandler) {
                this.phosHandler = phosHandler;
            }

            private void verifyUnchanged() {
                if (!this.referenceValue.equals(this.returnedValue)) {
                    throw new IllegalStateException("Previous caller to getEnergy, getMaxEnergy, or getNeededEnergy modified returned value, this behavior is not allowed");
                }
            }

            public int getEnergyContainerCount() {
                return 1;
            }

            public FloatingLong getEnergy(int container) {
                this.verifyUnchanged();
                if (container != 0) {
                    return FloatingLong.ZERO;
                }
                this.referenceValue.minusEqual(this.referenceValue);
                this.returnedValue.minusEqual(this.returnedValue);
                this.referenceValue.plusEqual(FloatingLong.create((long)this.phosHandler.energyStored()));
                this.returnedValue.plusEqual(this.referenceValue);
                return this.returnedValue;
            }

            public void setEnergy(int container, FloatingLong energy) {
                this.verifyUnchanged();
                throw new RuntimeException("setEnergy not implemented");
            }

            public FloatingLong getMaxEnergy(int container) {
                this.verifyUnchanged();
                if (container != 0) {
                    return FloatingLong.ZERO;
                }
                this.referenceValue.minusEqual(this.referenceValue);
                this.returnedValue.minusEqual(this.returnedValue);
                this.referenceValue.plusEqual(JouleFEConversion.convertInPlaceFrom(FloatingLong.create((long)this.phosHandler.maxEnergyStored())));
                this.returnedValue.plusEqual(this.referenceValue);
                return this.returnedValue;
            }

            public FloatingLong getNeededEnergy(int container) {
                this.verifyUnchanged();
                if (container != 0) {
                    return FloatingLong.ZERO;
                }
                this.referenceValue.minusEqual(this.referenceValue);
                this.returnedValue.minusEqual(this.returnedValue);
                this.referenceValue.plusEqual(JouleFEConversion.convertInPlaceFrom(FloatingLong.create((long)(this.phosHandler.maxEnergyStored() - this.phosHandler.energyStored()))));
                this.returnedValue.plusEqual(this.referenceValue);
                return this.returnedValue;
            }

            public FloatingLong insertEnergy(int container, FloatingLong amount, Action action) {
                this.verifyUnchanged();
                if (container != 0) {
                    return FloatingLong.ZERO;
                }
                return this.insertEnergy(amount, action);
            }

            public FloatingLong extractEnergy(int container, FloatingLong amount, Action action) {
                this.verifyUnchanged();
                if (container != 0) {
                    return FloatingLong.ZERO;
                }
                return this.extractEnergy(amount, action);
            }

            public FloatingLong insertEnergy(FloatingLong amount, Action action) {
                this.verifyUnchanged();
                long toInsert = JouleFEConversion.convertTo(amount).longValue();
                long inserted = this.phosHandler.insertEnergy(toInsert, action.simulate());
                long remaining = toInsert - inserted;
                if (remaining == 0L) {
                    return FloatingLong.ZERO;
                }
                return JouleFEConversion.convertInPlaceFrom(FloatingLong.create((long)remaining));
            }

            public FloatingLong extractEnergy(FloatingLong amount, Action action) {
                this.verifyUnchanged();
                long toExtract = JouleFEConversion.convertTo(amount).longValue();
                long extracted = this.phosHandler.extractEnergy(toExtract, action.simulate());
                if (extracted == 0L) {
                    return FloatingLong.ZERO;
                }
                return JouleFEConversion.convertInPlaceFrom(FloatingLong.create((long)extracted));
            }
        }

        private static class ToWrapper
        implements IPhosphophylliteEnergyHandler {
            private final IStrictEnergyHandler mekHandler;

            ToWrapper(IStrictEnergyHandler mekHandler) {
                this.mekHandler = mekHandler;
            }

            @Override
            public long insertEnergy(long maxInsert, boolean simulate) {
                long inserted = 0L;
                int containers = this.mekHandler.getEnergyContainerCount();
                for (int i = 0; i < containers; ++i) {
                    FloatingLong JAfterInsert;
                    FloatingLong toInsertRF = FloatingLong.create((long)(maxInsert - inserted));
                    FloatingLong toInsertJ = JouleFEConversion.convertInPlaceFrom(toInsertRF);
                    FloatingLong simulatedInsertRemainingJ = this.mekHandler.insertEnergy(i, toInsertJ, Action.SIMULATE);
                    FloatingLong simulatedInsertedRF = JouleFEConversion.convertInPlaceTo(toInsertJ.minusEqual(simulatedInsertRemainingJ)).floor();
                    inserted += simulatedInsertedRF.longValue();
                    if (simulate || (JAfterInsert = this.mekHandler.insertEnergy(i, JouleFEConversion.convertInPlaceFrom(simulatedInsertedRF), Action.EXECUTE)).isZero()) continue;
                    throw new IllegalStateException("Mekanism energy handler state changed between simulation and push");
                }
                return inserted;
            }

            @Override
            public long extractEnergy(long maxExtract, boolean simulate) {
                long extracted = 0L;
                int containers = this.mekHandler.getEnergyContainerCount();
                for (int i = 0; i < containers; ++i) {
                    FloatingLong ableToExtractJ;
                    FloatingLong totalExtracted;
                    FloatingLong attemptExtractRF = FloatingLong.create((long)(maxExtract - extracted));
                    FloatingLong attemptExtractJ = JouleFEConversion.convertInPlaceFrom(attemptExtractRF);
                    FloatingLong amountExtractedJ = this.mekHandler.extractEnergy(i, attemptExtractJ, Action.SIMULATE);
                    FloatingLong ableToExtractRF = JouleFEConversion.convertInPlaceTo(amountExtractedJ).floor();
                    extracted += ableToExtractRF.longValue();
                    if (simulate || (totalExtracted = this.mekHandler.extractEnergy(i, ableToExtractJ = JouleFEConversion.convertInPlaceTo(ableToExtractRF), Action.EXECUTE)).equals(ableToExtractJ)) continue;
                    throw new IllegalStateException("Mekanism energy handler state changed between simulation and pull");
                }
                return extracted;
            }

            @Override
            public long energyStored() {
                long stored = 0L;
                int containers = this.mekHandler.getEnergyContainerCount();
                FloatingLong scratchFloatingLong = FloatingLong.create((long)0L);
                for (int i = 0; i < containers; ++i) {
                    scratchFloatingLong = scratchFloatingLong.minusEqual(scratchFloatingLong);
                    scratchFloatingLong = scratchFloatingLong.plusEqual(this.mekHandler.getEnergy(i));
                    long containerStored = (scratchFloatingLong = JouleFEConversion.convertInPlaceTo(scratchFloatingLong)).longValue();
                    if (stored + containerStored < stored) {
                        return Long.MAX_VALUE;
                    }
                    stored += containerStored;
                }
                return stored;
            }

            @Override
            public long maxEnergyStored() {
                long maxStored = 0L;
                int containers = this.mekHandler.getEnergyContainerCount();
                FloatingLong scratchFloatingLong = FloatingLong.create((long)0L);
                for (int i = 0; i < containers; ++i) {
                    scratchFloatingLong = scratchFloatingLong.minusEqual(scratchFloatingLong);
                    scratchFloatingLong = scratchFloatingLong.plusEqual(this.mekHandler.getMaxEnergy(i));
                    long containerMaxStored = (scratchFloatingLong = JouleFEConversion.convertInPlaceTo(scratchFloatingLong)).longValue();
                    if (maxStored + containerMaxStored < maxStored) {
                        return Long.MAX_VALUE;
                    }
                    maxStored += containerMaxStored;
                }
                return maxStored;
            }
        }
    }

    private static class Forge {
        public static final Capability<IEnergyStorage> FORGE_ENERGY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEnergyStorage>(){});

        private Forge() {
        }

        @OnModLoad
        public static void onModLoad() {
            EnergyHandlerWrappers.registerWrapper(FORGE_ENERGY_CAPABILITY, ToWrapper::new, FromWrapper::new, Integer.MIN_VALUE);
        }

        private static class FromWrapper
        implements IEnergyStorage {
            private final IPhosphophylliteEnergyHandler phosHandler;

            private FromWrapper(IPhosphophylliteEnergyHandler phosHandler) {
                this.phosHandler = phosHandler;
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return Math.toIntExact(this.phosHandler.insertEnergy(maxReceive, simulate));
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)this.phosHandler.extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return Util.clampToInt(this.phosHandler.energyStored());
            }

            public int getMaxEnergyStored() {
                return Util.clampToInt(this.phosHandler.maxEnergyStored());
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }
        }

        private static class ToWrapper
        implements IPhosphophylliteEnergyHandler {
            private final IEnergyStorage forgeStorage;

            ToWrapper(IEnergyStorage forgeStorage) {
                this.forgeStorage = forgeStorage;
            }

            @Override
            public long insertEnergy(long maxInsert, boolean simulate) {
                return this.forgeStorage.receiveEnergy(Util.clampToInt(maxInsert), simulate);
            }

            @Override
            public long extractEnergy(long maxExtract, boolean simulate) {
                return this.forgeStorage.extractEnergy(Util.clampToInt(maxExtract), simulate);
            }

            @Override
            public long energyStored() {
                return this.forgeStorage.getEnergyStored();
            }

            @Override
            public long maxEnergyStored() {
                return this.forgeStorage.getMaxEnergyStored();
            }
        }
    }
}

