/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.energy.IEnergyTile;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyHandler;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PowerWhiteHoleTile
extends PhosphophylliteTile
implements IEnergyTile {
    @RegisterTile(value="power_white_hole")
    public static final BlockEntityType.BlockEntitySupplier<PowerWhiteHoleTile> SUPPLIER = new RegisterTile.Producer<PowerWhiteHoleTile>(PowerWhiteHoleTile::new);
    private static final Direction[] directions = Direction.values();
    private final ObjectArrayList<LazyOptional<IPhosphophylliteEnergyHandler>> handlers = new ObjectArrayList();
    private LazyOptional<IPhosphophylliteEnergyHandler> energyHandler;
    private long sentLastTick;
    private boolean doPush;
    private boolean allowPull;

    public PowerWhiteHoleTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.energyHandler = LazyOptional.empty();
        this.sentLastTick = 0L;
        this.rotateCapability(null);
    }

    @Override
    public LazyOptional<IPhosphophylliteEnergyHandler> energyHandler() {
        return this.energyHandler;
    }

    public void tick() {
        assert (this.f_58857_ != null);
        this.sentLastTick = 0L;
        if (this.doPush) {
            this.handlers.forEach(cap -> cap.ifPresent(this::sendEnergy));
        }
    }

    private void sendEnergy(IPhosphophylliteEnergyHandler handler) {
        long sent = handler.insertEnergy(Long.MAX_VALUE, false);
        if (this.sentLastTick + sent < this.sentLastTick) {
            this.sentLastTick = Long.MAX_VALUE;
            return;
        }
        this.sentLastTick += sent;
    }

    public void rotateCapability(@Nullable Player player) {
        this.energyHandler.invalidate();
        this.energyHandler = LazyOptional.of(() -> new IPhosphophylliteEnergyHandler(){

            private void ensureValid() {
                if (!Phosphophyllite.CONFIG.debugMode) {
                    return;
                }
                if (!PowerWhiteHoleTile.this.energyHandler.isPresent()) {
                    throw new IllegalStateException("Attempt to use capability when not present");
                }
                if (PowerWhiteHoleTile.this.energyHandler.orElse((Object)this) != this) {
                    throw new IllegalStateException("Attempt to use capability after invalidate");
                }
            }

            @Override
            public long insertEnergy(long maxInsert, boolean simulate) {
                this.ensureValid();
                if (maxInsert < 0L) {
                    if (Phosphophyllite.CONFIG.debugMode) {
                        throw new IllegalStateException("Something tried to insert negative power");
                    }
                    return 0L;
                }
                return 0L;
            }

            @Override
            public long extractEnergy(long maxExtract, boolean simulate) {
                this.ensureValid();
                if (maxExtract < 0L) {
                    if (Phosphophyllite.CONFIG.debugMode) {
                        throw new IllegalStateException("Something tried to extract negative power");
                    }
                    return 0L;
                }
                if (!PowerWhiteHoleTile.this.allowPull) {
                    return 0L;
                }
                if (!simulate) {
                    if (PowerWhiteHoleTile.this.sentLastTick + maxExtract < PowerWhiteHoleTile.this.sentLastTick) {
                        PowerWhiteHoleTile.this.sentLastTick = Long.MAX_VALUE;
                        return maxExtract;
                    }
                    PowerWhiteHoleTile.this.sentLastTick += maxExtract;
                }
                return maxExtract;
            }

            @Override
            public long energyStored() {
                this.ensureValid();
                return Long.MAX_VALUE;
            }

            @Override
            public long maxEnergyStored() {
                this.ensureValid();
                return Long.MAX_VALUE;
            }
        });
        if (player != null) {
            player.m_213846_((Component)Component.m_237113_((String)"Capability invalidated"));
        }
    }

    public void nextOption(Player player) {
        if (this.doPush) {
            if (this.allowPull) {
                this.allowPull = false;
            } else {
                this.allowPull = true;
                this.doPush = false;
            }
        } else {
            this.doPush = true;
            this.allowPull = true;
        }
        if (player.m_7578_()) {
            player.m_213846_((Component)Component.m_237113_((String)("doPush: " + this.doPush + ", allowPull: " + this.allowPull)));
        }
    }

    @Override
    public void onAdded() {
        for (Direction direction : directions) {
            this.updateCapability(direction, null, this.m_58899_());
        }
    }

    @Override
    public void onRemoved(boolean chunkUnload) {
        this.energyHandler.invalidate();
    }

    @Override
    protected void readNBT(CompoundTag compound) {
        this.doPush = compound.m_128471_("doPush");
        this.allowPull = compound.m_128471_("allowPull");
    }

    @Override
    protected CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("doPush", this.doPush);
        tag.m_128379_("allowPull", this.allowPull);
        return tag;
    }

    @Override
    @Nonnull
    public DebugInfo getDebugInfo() {
        return super.getDebugInfo().add("SentLastTick: " + this.sentLastTick).add("DoPush " + this.doPush).add("AllowPull " + this.allowPull);
    }

    public void updateCapability(Direction updateDirection, @Nullable Block oldBlock, BlockPos updatePos) {
        int index = updateDirection.ordinal();
        LazyOptional capability = (LazyOptional)this.handlers.get(index);
        if (Phosphophyllite.CONFIG.debugMode && capability.isPresent() && oldBlock != null) {
            assert (this.f_58857_ != null);
            BlockState currentBlockState = this.f_58857_.m_8055_(updatePos);
            if (currentBlockState.m_60734_() != oldBlock) {
                Phosphophyllite.LOGGER.warn("Block updated from " + ForgeRegistries.BLOCKS.getKey((Object)oldBlock) + " without invalidating capability");
                this.handlers.set(index, (Object)LazyOptional.empty());
            }
        }
        if (!capability.isPresent()) {
            this.handlers.set(index, (Object)this.findEnergyCapability(updateDirection));
        }
    }
}

