/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.klikli_dev.occultism.common.misc.StorageControllerSlot;
import com.klikli_dev.occultism.network.OccultismPackets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class StorageControllerContainerBase
extends AbstractContainerMenu
implements IStorageControllerContainer {
    public static ConcurrentMap<BlockPos, UUID> openContainers = new ConcurrentHashMap<BlockPos, UUID>();
    public Inventory playerInventory;
    public Player player;
    protected ResultContainer result;
    protected StorageControllerSlot slotCraftOutput;
    protected StorageControllerCraftingInventory matrix;
    protected SimpleContainer orderInventory;
    protected CraftingRecipe currentRecipe;
    protected boolean recipeLocked = false;

    protected StorageControllerContainerBase(@Nullable MenuType<?> type, int id, Inventory playerInventory) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.player = playerInventory.f_35978_;
        this.result = new ResultContainer();
        this.orderInventory = new SimpleContainer(1);
    }

    public static boolean canOpen(Player player, BlockPos pos) {
        if (!openContainers.containsKey(pos) || ((UUID)openContainers.get(pos)).equals(player.m_20148_())) {
            return true;
        }
        player.m_213846_((Component)Component.m_237115_((String)"messages.occultism.container_already_open").m_130940_(ChatFormatting.RED));
        return false;
    }

    public static void reserve(Player player, BlockPos pos) {
        openContainers.put(pos, player.m_20148_());
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        return GlobalBlockPos.from((BlockEntity)this.getStorageController());
    }

    @Override
    public CraftingContainer getCraftMatrix() {
        return this.matrix;
    }

    public void m_6199_(Container inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        this.updateCraftingSlots(false);
        this.m_38946_();
        this.findRecipeForMatrix();
    }

    @Override
    public SimpleContainer getOrderSlot() {
        return this.orderInventory;
    }

    public ItemStack m_7648_(Player player, int index) {
        if (player.f_19853_.f_46443_) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            IStorageController storageController = this.getStorageController();
            if (index == 0) {
                this.craftShift(player, storageController);
                return ItemStack.f_41583_;
            }
            if (storageController != null) {
                int remainingItems = storageController.insertStack(slotStack, false);
                ItemStack remainingItemStack = remainingItems == 0 ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)slotStack, (int)remainingItems);
                slot.m_5852_(remainingItemStack);
                this.m_38946_();
                OccultismPackets.sendTo((ServerPlayer)player, storageController.getMessageUpdateStacks());
                if (!remainingItemStack.m_41619_()) {
                    slot.m_142406_(player, slotStack);
                }
                return ItemStack.f_41583_;
            }
        }
        return result;
    }

    public void m_6877_(Player playerIn) {
        this.updateCraftingSlots(false);
        this.updateOrderSlot(true);
        super.m_6877_(playerIn);
        openContainers.values().removeIf(uuid -> uuid.equals(playerIn.m_20148_()));
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 56;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupCraftingGrid() {
        int craftingGridTop = 113;
        int craftingGridLeft = 85;
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.matrix, index++, craftingGridLeft + j * 18, craftingGridTop + i * 18));
            }
        }
    }

    protected void setupCraftingOutput() {
        int craftingOutputTop = 131;
        int craftingOutputLeft = 178;
        this.slotCraftOutput = new StorageControllerSlot(this.playerInventory.f_35978_, this.matrix, (Container)this.result, this, 0, craftingOutputLeft, craftingOutputTop);
        this.m_38897_((Slot)this.slotCraftOutput);
    }

    protected void setupOrderInventorySlot() {
        int orderSlotTop = 36;
        int orderSlotLeft = 13;
        this.m_38897_(new Slot((Container)this.orderInventory, 0, orderSlotLeft, orderSlotTop));
    }

    protected abstract void setupPlayerHotbar();

    protected void findRecipeForMatrixClient() {
        Optional optional = this.player.f_19853_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.matrix, this.player.f_19853_);
        optional.ifPresentOrElse(iCraftingRecipe -> {
            this.currentRecipe = iCraftingRecipe;
        }, () -> {
            this.currentRecipe = null;
        });
    }

    protected void findRecipeForMatrix() {
        if (!this.player.f_19853_.f_46443_) {
            CraftingRecipe icraftingrecipe;
            this.currentRecipe = null;
            ServerPlayer serverplayerentity = (ServerPlayer)this.player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = this.player.f_19853_.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.matrix, this.player.f_19853_);
            if (optional.isPresent() && this.result.m_40135_(this.player.f_19853_, serverplayerentity, (Recipe)(icraftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.m_5874_((Container)this.matrix);
                this.currentRecipe = icraftingrecipe;
            }
            this.result.m_6836_(0, itemstack);
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, 0, 0, itemstack));
        }
    }

    protected void craftShift(Player player, IStorageController storageController) {
        ItemStack newResult;
        if (this.matrix == null) {
            return;
        }
        this.findRecipeForMatrixClient();
        if (this.currentRecipe == null) {
            return;
        }
        this.recipeLocked = true;
        ArrayList<ItemStack> recipeCopy = new ArrayList<ItemStack>(this.matrix.m_6643_());
        for (int i = 0; i < this.matrix.m_6643_(); ++i) {
            recipeCopy.add(this.matrix.m_8020_(i).m_41777_());
        }
        ItemStack result = this.currentRecipe.m_5874_((Container)this.matrix);
        if (result.m_41619_()) {
            return;
        }
        int resultStackSize = result.m_41613_();
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        int crafted = 0;
        while (crafted + resultStackSize <= result.m_41741_() && this.currentRecipe != null && (newResult = this.currentRecipe.m_5874_((Container)this.matrix).m_41777_()).m_41720_() == result.m_41720_() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInventory), (ItemStack)newResult, (boolean)true).m_41619_() && this.currentRecipe.m_5818_((Container)this.matrix, player.f_19853_)) {
            int i;
            resultList.add(newResult);
            NonNullList remainingCraftingItems = this.currentRecipe.m_7457_((Container)this.matrix);
            for (i = 0; i < remainingCraftingItems.size(); ++i) {
                ItemStack currentCraftingItem = (ItemStack)remainingCraftingItems.get(i);
                ItemStack stackInSlot = this.matrix.m_8020_(i);
                if (currentCraftingItem.m_41619_()) {
                    this.matrix.m_8020_(i).m_41774_(1);
                    continue;
                }
                if (!stackInSlot.m_41720_().getCraftingRemainingItem(stackInSlot).m_41619_()) {
                    ItemStack container = stackInSlot.m_41720_().getCraftingRemainingItem(stackInSlot);
                    if (!stackInSlot.m_41753_()) {
                        stackInSlot = container;
                        this.matrix.m_6836_(i, stackInSlot);
                        continue;
                    }
                    stackInSlot.m_41774_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)container);
                    continue;
                }
                if (!currentCraftingItem.m_41619_()) {
                    if (stackInSlot.m_41619_()) {
                        this.matrix.m_6836_(i, currentCraftingItem);
                        continue;
                    }
                    if (!stackInSlot.m_41763_() && ItemStack.m_41658_((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                        this.matrix.m_6836_(i, currentCraftingItem);
                        continue;
                    }
                    if (ItemStack.m_41758_((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                        this.matrix.m_6836_(i, currentCraftingItem);
                        continue;
                    }
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newResult);
                    continue;
                }
                if (stackInSlot.m_41619_()) continue;
                this.matrix.m_7407_(i, 1);
                stackInSlot = this.matrix.m_8020_(i);
            }
            crafted += resultStackSize;
            for (i = 0; i < this.matrix.m_6643_(); ++i) {
                ItemStack stackInSlot = this.matrix.m_8020_(i);
                if (!stackInSlot.m_41619_()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackComparator comparator = !recipeStack.m_41619_() ? new ItemStackComparator(recipeStack) : null;
                ItemStack requestedItem = this.getStorageController().getOneOfMostCommonItem(comparator, false);
                this.matrix.m_6836_(i, requestedItem);
            }
            this.m_6199_((Container)this.matrix);
        }
        ItemStack finalResult = new ItemStack((ItemLike)result.m_41720_(), 0);
        finalResult.m_41751_(result.m_41783_());
        for (ItemStack intermediateResult : resultList) {
            finalResult.m_41764_(finalResult.m_41613_() + intermediateResult.m_41613_());
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)finalResult);
        this.m_38946_();
        this.recipeLocked = false;
        this.m_6199_((Container)this.matrix);
        OccultismPackets.sendTo((ServerPlayer)player, this.getStorageController().getMessageUpdateStacks());
    }
}

