/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.GuardianFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GuardianFamiliarRenderer
extends MobRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/guardian_familiar.png");

    public GuardianFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GuardianFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_GUARDIAN)), 0.3f);
        this.m_115326_(new GuardianFamiliarOverlay((RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel>)this, context));
        this.m_115326_(new ToolsLayer((RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
        this.m_115326_(new GuardianFamiliarTree((RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
    }

    public void render(GuardianFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack ppMatrixStackStack, MultiBufferSource pBuffer, int pPackedLight) {
        boolean noLegs;
        ppMatrixStackStack.m_85836_();
        boolean bl = noLegs = pEntity.getLives() <= 2;
        ppMatrixStackStack.m_85837_(0.0, pEntity.isSitting() ? (noLegs ? -0.5 : -0.36) : (double)pEntity.getAnimationHeight(pPartialTicks) * 0.08, 0.0);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, ppMatrixStackStack, pBuffer, pPackedLight);
        ppMatrixStackStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(GuardianFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class GuardianFamiliarOverlay
    extends RenderLayer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        private static final ResourceLocation OVERLAY = new ResourceLocation("occultism", "textures/entity/guardian_familiar_overlay.png");
        private final GuardianFamiliarModel model;

        public GuardianFamiliarOverlay(RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel> parent, EntityRendererProvider.Context context) {
            super(parent);
            this.model = new GuardianFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_GUARDIAN));
        }

        public void render(PoseStack ppMatrixStackStack, MultiBufferSource pBuffer, int pPackedLight, GuardianFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!pLivingEntity.m_20145_()) {
                ((GuardianFamiliarModel)this.m_117386_()).m_102624_(this.model);
                this.model.m_6839_((Entity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
                this.model.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                VertexConsumer ivertexbuilder = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)OVERLAY));
                this.model.m_7695_(ppMatrixStackStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.m_115338_((LivingEntity)pLivingEntity, (float)0.0f), pLivingEntity.getRed(), pLivingEntity.getGreen(), pLivingEntity.getBlue(), (Mth.m_14089_((float)(pAgeInTicks / 20.0f)) + 1.0f) * 0.3f + 0.4f);
            }
        }
    }

    private static class ToolsLayer
    extends RenderLayer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        public ToolsLayer(RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, GuardianFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.m_20145_() || !pLivingEntity.hasTools()) {
                return;
            }
            ItemInHandRenderer itemRenderer = Minecraft.m_91087_().m_91290_().m_234586_();
            ItemTransforms.TransformType ground = ItemTransforms.TransformType.GROUND;
            GuardianFamiliarModel model = (GuardianFamiliarModel)this.m_117386_();
            pMatrixStack.m_85836_();
            model.body.m_104299_(pMatrixStack);
            pMatrixStack.m_85837_(-0.15, -0.25, -0.25);
            pMatrixStack.m_85845_(new Quaternion(0.0f, -60.0f, 0.0f, true));
            itemRenderer.m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_42425_), ground, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
            pMatrixStack.m_85836_();
            model.body.m_104299_(pMatrixStack);
            pMatrixStack.m_85837_(-0.15, 0.1, 0.37);
            pMatrixStack.m_85845_(new Quaternion(0.0f, 60.0f, -110.0f, true));
            itemRenderer.m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_42428_), ground, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
            if (model.leftArm1.f_104207_) {
                pMatrixStack.m_85836_();
                model.body.m_104299_(pMatrixStack);
                model.leftArm1.m_104299_(pMatrixStack);
                pMatrixStack.m_85837_(0.21, 0.2, 0.0);
                pMatrixStack.m_85845_(new Quaternion(0.0f, 0.0f, 210.0f, true));
                itemRenderer.m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_42427_), ground, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.m_85849_();
            }
        }
    }

    private static class GuardianFamiliarTree
    extends RenderLayer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        private static final ResourceLocation TREE = new ResourceLocation("occultism", "textures/entity/guardian_familiar_tree.png");
        private static final ResourceLocation CHRISTMAS = new ResourceLocation("occultism", "textures/entity/guardian_familiar_christmas.png");

        public GuardianFamiliarTree(RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GuardianFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.m_20145_()) {
                return;
            }
            boolean isChristmas = FamiliarUtil.isChristmas();
            boolean hasTree = entitylivingbaseIn.hasTree();
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)(isChristmas ? CHRISTMAS : TREE)));
            GuardianFamiliarModel model = (GuardianFamiliarModel)this.m_117386_();
            model.tree1.f_104207_ = isChristmas || hasTree;
            model.tree2.f_104207_ = isChristmas || hasTree;
            model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

