/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;

public class SpawnTraderCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"tryspawntrader");
        LiteralArgumentBuilder permission = (LiteralArgumentBuilder)builder.requires(stack -> stack.m_6761_(3));
        LiteralArgumentBuilder pos = (LiteralArgumentBuilder)permission.then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(SpawnTraderCommand::trySpawnTrader));
        dispatcher.register(pos);
        return builder;
    }

    private static int trySpawnTrader(CommandContext<CommandSourceStack> stack) {
        WanderingTrader trader = (WanderingTrader)EntityType.f_20494_.m_20600_(((CommandSourceStack)stack.getSource()).m_81372_(), null, null, null, new BlockPos(Vec3Argument.m_120844_(stack, (String)"pos")), MobSpawnType.EVENT, false, false);
        if (trader != null) {
            for (int j = 0; j < 2; ++j) {
                SpawnTraderCommand.tryToSpawnLlamaFor(((CommandSourceStack)stack.getSource()).m_81372_(), trader);
            }
            trader.m_35891_(48000);
        }
        try {
            ServerPlayer serverPlayer = ((CommandSourceStack)stack.getSource()).m_81375_();
            String message = trader != null ? "Spawned Trader at " + trader.m_20182_() : "Trader spawn blocked.";
            serverPlayer.m_213846_((Component)Component.m_237113_((String)message));
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        return 0;
    }

    private static void tryToSpawnLlamaFor(ServerLevel serverLevel, WanderingTrader trader) {
        TraderLlama traderllama;
        BlockPos blockpos = SpawnTraderCommand.findSpawnPositionNear((LevelReader)serverLevel, trader.m_20183_(), 4);
        if (blockpos != null && (traderllama = (TraderLlama)EntityType.f_20488_.m_20592_(serverLevel, null, null, blockpos, MobSpawnType.EVENT, false, false)) != null) {
            traderllama.m_21463_((Entity)trader, true);
        }
    }

    @Nullable
    private static BlockPos findSpawnPositionNear(LevelReader levelReader, BlockPos blockPos, int range) {
        BlockPos blockpos = null;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = blockPos.m_123341_() + random.nextInt(range * 2) - range;
            BlockPos blockpos1 = new BlockPos(j, l = levelReader.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = blockPos.m_123343_() + random.nextInt(range * 2) - range), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)levelReader, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }
}

