/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.mods.myrtrees.common.block;

import io.alwa.mods.myrtrees.common.MyrtreesConfig;
import io.alwa.mods.myrtrees.common.block.FilledRubberwoodLogBlock;
import io.alwa.mods.myrtrees.common.block.RubberwoodLogBlock;
import io.alwa.mods.myrtrees.common.blockentity.WoodenBucketBlockEntity;
import io.alwa.mods.myrtrees.common.item.MyrtreesItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WoodenBucketBlock
extends Block
implements EntityBlock {
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public WoodenBucketBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50014_));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    private boolean canAttachTo(BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return blockGetter.m_8055_(blockPos).m_60734_() instanceof RubberwoodLogBlock || blockGetter.m_8055_(blockPos).m_60734_() instanceof FilledRubberwoodLogBlock;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return !this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)levelReader, blockPos.m_121945_(direction.m_122424_()), direction);
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof WoodenBucketBlockEntity) {
            WoodenBucketBlockEntity bucket = (WoodenBucketBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_()) {
                ItemStack itemStack = new ItemStack((ItemLike)MyrtreesItems.WOODEN_BUCKET.get());
                if (bucket.latex > 0) {
                    CompoundTag compoundTag = new CompoundTag();
                    compoundTag.m_128405_("latex", bucket.latex);
                    if (!compoundTag.m_128456_()) {
                        itemStack.m_41700_("BlockEntityTag", (Tag)compoundTag);
                    }
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WoodenBucketBlockEntity(pos, state);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof WoodenBucketBlockEntity) {
            WoodenBucketBlockEntity e = (WoodenBucketBlockEntity)entity;
            if (e.latex >= MyrtreesConfig.LATEX_FOR_ITEM) {
                e.latex -= MyrtreesConfig.LATEX_FOR_ITEM;
                if (!level.m_5776_()) {
                    WoodenBucketBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)new ItemStack((ItemLike)MyrtreesItems.LATEX.get()));
                    e.m_6596_();
                }
            }
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237113_((String)String.format("%,d / %,d", e.latex, MyrtreesConfig.BUCKET_CAPACITY)), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            list.add((Component)Component.m_237113_((String)String.format("%,d / %,d", stack.m_41783_().m_128469_("BlockEntityTag").m_128451_("latex"), MyrtreesConfig.BUCKET_CAPACITY)).m_130940_(ChatFormatting.GRAY));
        }
    }
}

