/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.mods.myrtrees.common;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.alwa.mods.myrtrees.common.MyrtreesConfig;
import io.alwa.mods.myrtrees.common.block.MyrtreesBlocks;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.jetbrains.annotations.Nullable;

public class RubberTreeGeneration {
    public static final DeferredRegister<TrunkPlacerType<?>> TRUNK_REGISTRY = DeferredRegister.create((String)"myrtrees", (ResourceKey)Registry.f_122849_);
    private static final RegistrySupplier<TrunkPlacerType<?>> RUBBER_TREE_TRUNK_TYPE = TRUNK_REGISTRY.register("rubber_trunk_placer", () -> new TrunkPlacerType(RubberwoodTreeTrunkPlacer.CODEC));
    private static Holder<ConfiguredFeature<TreeConfiguration, ?>> RUBBER_TREE_CONFIGURED_FEATURE;
    private static Holder<PlacedFeature> RUBBER_TREE_PLACEMENT;

    public static void initialize() {
        RUBBER_TREE_CONFIGURED_FEATURE = FeatureUtils.m_206488_((String)"rubber_tree", (Feature)Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)MyrtreesBlocks.RUBBERWOOD_LOG.get()), (TrunkPlacer)new RubberwoodTreeTrunkPlacer(5, 3, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)MyrtreesBlocks.RUBBERWOOD_LEAVES.get()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        RUBBER_TREE_PLACEMENT = PlacementUtils.m_206513_((String)"rubber_tree_placement", RUBBER_TREE_CONFIGURED_FEATURE, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)(0.01f * (float)MyrtreesConfig.TREE_CHANCE), (int)1), InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)MyrtreesBlocks.RUBBERWOOD_SAPLING.get().m_49966_(), (Vec3i)BlockPos.f_121853_)), BiomeFilter.m_191561_()});
    }

    public static void biomeModifications(BiomeModifications.BiomeContext context, BiomeProperties.Mutable properties) {
        if (context.hasTag(BiomeTags.f_207610_) || !MyrtreesConfig.ONLY_JUNGLE && (context.hasTag(BiomeTags.f_207611_) || context.hasTag(BiomeTags.f_207589_) || context.hasTag(BiomeTags.f_215816_))) {
            properties.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RUBBER_TREE_PLACEMENT);
        }
    }

    private static class RubberwoodTreeTrunkPlacer
    extends TrunkPlacer {
        public static final Codec<RubberwoodTreeTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> RubberwoodTreeTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, RubberwoodTreeTrunkPlacer::new));

        public RubberwoodTreeTrunkPlacer(int x, int y, int z) {
            super(x, y, z);
        }

        protected TrunkPlacerType<?> m_7362_() {
            return (TrunkPlacerType)RUBBER_TREE_TRUNK_TYPE.get();
        }

        public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader levelSimulatedRW, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, int i, BlockPos blockPos, TreeConfiguration treeConfiguration) {
            RubberwoodTreeTrunkPlacer.m_226169_((LevelSimulatedReader)levelSimulatedRW, biConsumer, (RandomSource)randomSource, (BlockPos)blockPos.m_7495_(), (TreeConfiguration)treeConfiguration);
            for (int j = 0; j < i; ++j) {
                if (j == 1) {
                    biConsumer.accept(blockPos.m_6630_(j), MyrtreesBlocks.FILLED_RUBBERWOOD_LOG.get().m_49966_());
                    continue;
                }
                this.m_226187_(levelSimulatedRW, biConsumer, randomSource, blockPos.m_6630_(j), treeConfiguration);
            }
            return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(blockPos.m_6630_(i), 0, false));
        }
    }

    public static class RubberWoodTree
    extends AbstractTreeGrower {
        @Nullable
        protected Holder<? extends ConfiguredFeature<?, ?>> m_213888_(RandomSource random, boolean bl) {
            return RUBBER_TREE_CONFIGURED_FEATURE;
        }
    }
}

